/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.config.domain.database;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mule.config.spring.parsers.PreProcessor;
import org.mule.config.spring.parsers.generic.MuleOrphanDefinitionParser;
import org.mule.config.spring.parsers.processors.CheckExclusiveAttributes;
import org.mule.module.db.internal.config.domain.database.DbConfigResolverFactoryBean;
import org.mule.module.db.internal.domain.type.ArrayResolvedDbType;
import org.mule.module.db.internal.domain.type.ResolvedDbType;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class DbConfigDefinitionParser
extends MuleOrphanDefinitionParser {
    public static final String CONNECTION_PROPERTIES_ELEMENT_NAME = "connection-properties";
    public static final String PROPERTY_ELEMENT_NAME = "property";
    public static final String DATA_TYPES_ELEMENT = "data-types";
    public static final String DATA_TYPE_ELEMENT = "data-type";
    public static final String TYPE_ID_ATTRIBUTE = "id";
    private static final Map<String, Integer> TRANSACTION_ISOLATION_MAPPING = new HashMap<String, Integer>();
    private static final String KEY_ATTRIBUTE_NAME = "key";
    private static final String VALUE_ATTRIBUTE_NAME = "value";
    public static final String TRANSACTION_ISOLATION_ATTRIBUTE = "transactionIsolation";
    public static final String URL_ATTRIBUTE = "url";
    public static final String USER_ATTRIBUTE = "user";
    public static final String PASSWORD_ATTRIBUTE = "password";
    public static final String DRIVER_ATTRIBUTE = "driver";
    public static final String HOST_ATTRIBUTE = "host";
    public static final String PORT_ATTRIBUTE = "port";
    public static final String DATABASE_ATTRIBUTE = "database";
    public static final String LOGIN_TIMEOUT_ATTRIBUTE = "connectionTimeout";
    public static final String DATA_SOURCE_REF_ATTRIBUTE = "dataSource-ref";
    public static final String USE_XA_TRANSACTIONS_ATTRIBUTE = "useXaTransactions";
    public static final String TYPE_NAME_ATTIRBUTE = "name";

    public DbConfigDefinitionParser(Class<? extends DbConfigResolverFactoryBean> dbConfigFactoryClass, CheckExclusiveAttributes exclusiveAttributes) {
        super(dbConfigFactoryClass, true);
        this.addMapping(TRANSACTION_ISOLATION_ATTRIBUTE, TRANSACTION_ISOLATION_MAPPING);
        this.addIgnored(CONNECTION_PROPERTIES_ELEMENT_NAME);
        this.addIgnored(DATA_TYPES_ELEMENT);
        this.registerPreProcessor((PreProcessor)exclusiveAttributes);
    }

    protected void doParse(Element element, ParserContext context, BeanDefinitionBuilder builder) {
        super.doParse(element, context, builder);
        this.parseConnectionProperties(element, builder);
        this.parseCustomDataTypes(element, builder);
    }

    private void parseCustomDataTypes(Element element, BeanDefinitionBuilder builder) {
        ArrayList<ResolvedDbType> customDbTypes = new ArrayList<ResolvedDbType>();
        Element customTypes = DomUtils.getChildElementByTagName((Element)element, (String)DATA_TYPES_ELEMENT);
        if (customTypes != null) {
            for (Element dataType : DomUtils.getChildElementsByTagName((Element)customTypes, (String)DATA_TYPE_ELEMENT)) {
                String name = dataType.getAttribute(TYPE_NAME_ATTIRBUTE);
                int id = Integer.valueOf(dataType.getAttribute(TYPE_ID_ATTRIBUTE));
                if (id == 2003) {
                    customDbTypes.add(new ArrayResolvedDbType(id, name));
                    continue;
                }
                customDbTypes.add(new ResolvedDbType(id, name));
            }
        }
        builder.addPropertyValue("customDataTypes", customDbTypes);
    }

    private void parseConnectionProperties(Element element, BeanDefinitionBuilder builder) {
        LinkedHashMap<String, String> propertiesMap = new LinkedHashMap<String, String>();
        Element properties = DomUtils.getChildElementByTagName((Element)element, (String)CONNECTION_PROPERTIES_ELEMENT_NAME);
        if (properties != null) {
            for (Element property : DomUtils.getChildElementsByTagName((Element)properties, (String)PROPERTY_ELEMENT_NAME)) {
                propertiesMap.put(property.getAttribute(KEY_ATTRIBUTE_NAME), property.getAttribute(VALUE_ATTRIBUTE_NAME));
            }
        }
        builder.addPropertyValue("connectionProperties", propertiesMap);
    }

    static {
        TRANSACTION_ISOLATION_MAPPING.put("", -1);
        TRANSACTION_ISOLATION_MAPPING.put("NONE", 0);
        TRANSACTION_ISOLATION_MAPPING.put("READ_COMMITTED", 2);
        TRANSACTION_ISOLATION_MAPPING.put("READ_UNCOMMITTED", 1);
        TRANSACTION_ISOLATION_MAPPING.put("REPEATABLE_READ", 4);
        TRANSACTION_ISOLATION_MAPPING.put("SERIALIZABLE", 8);
    }
}

