/*
 * Decompiled with CFR 0.152.
 */
package org.mule.api.config;

import java.lang.reflect.Field;
import java.net.URLClassLoader;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.config.DefaultThreadingProfileConfig;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.util.ClassUtils;

@SmallTest
public class DefaultThreadingProfileConfigTestCase
extends AbstractMuleTestCase {
    public static final int MAX_THREADS_ACTIVE = 16;
    public static final int MAX_THREADS_IDLE = 1;
    public static final int MAX_BUFFER_SIZE = 0;
    public static final long MAX_THREAD_TTL = 60000L;
    public static final long THREAD_WAIT_TIMEOUT = 30000L;
    public static final String INVALID_PROPERTY_VALUE = "test";

    @Test
    public void usesDefaultMaxThreadsActive() throws Exception {
        this.checkMaxThreadsActive(16);
    }

    @Test
    public void usesCustomMaxThreadsActive() throws Exception {
        int customValue = 17;
        MuleTestUtils.testWithSystemProperty("mule.defaultThreadingProfile.maxThreadsActive", Integer.toString(17), new MuleTestUtils.TestCallback(){

            @Override
            public void run() throws Exception {
                DefaultThreadingProfileConfigTestCase.this.checkMaxThreadsActive(17);
            }
        });
    }

    @Test(expected=ExceptionInInitializerError.class)
    public void failsOnInvalidCustomMaxThreadsActive() throws Exception {
        MuleTestUtils.testWithSystemProperty("mule.defaultThreadingProfile.maxThreadsActive", INVALID_PROPERTY_VALUE, new MuleTestUtils.TestCallback(){

            @Override
            public void run() throws Exception {
                DefaultThreadingProfileConfigTestCase.this.getMaxThreadsActive();
            }
        });
    }

    @Test
    public void usesDefaultMaxThreadsIdle() throws Exception {
        this.checkMaxThreadsIdle(1);
    }

    @Test
    public void usesCustomMaxThreadsIdle() throws Exception {
        int customValue = 2;
        MuleTestUtils.testWithSystemProperty("mule.defaultThreadingProfile.maxThreadsIdle", Integer.toString(2), new MuleTestUtils.TestCallback(){

            @Override
            public void run() throws Exception {
                DefaultThreadingProfileConfigTestCase.this.checkMaxThreadsIdle(2);
            }
        });
    }

    @Test(expected=ExceptionInInitializerError.class)
    public void failsOnInvalidCustomMaxThreadsIdle() throws Exception {
        MuleTestUtils.testWithSystemProperty("mule.defaultThreadingProfile.maxThreadsIdle", INVALID_PROPERTY_VALUE, new MuleTestUtils.TestCallback(){

            @Override
            public void run() throws Exception {
                DefaultThreadingProfileConfigTestCase.this.getMaxThreadsIdle();
            }
        });
    }

    @Test
    public void usesDefaultMaxBufferSize() throws Exception {
        this.checkMaxBufferSize(0);
    }

    @Test
    public void usesCustomMaxBufferSize() throws Exception {
        boolean customValue = true;
        MuleTestUtils.testWithSystemProperty("mule.defaultThreadingProfile.maxBufferSize", Integer.toString(1), new MuleTestUtils.TestCallback(){

            @Override
            public void run() throws Exception {
                DefaultThreadingProfileConfigTestCase.this.checkMaxBufferSize(1);
            }
        });
    }

    @Test(expected=ExceptionInInitializerError.class)
    public void failsOnInvalidCustomMaxBufferSize() throws Exception {
        MuleTestUtils.testWithSystemProperty("mule.defaultThreadingProfile.maxBufferSize", INVALID_PROPERTY_VALUE, new MuleTestUtils.TestCallback(){

            @Override
            public void run() throws Exception {
                DefaultThreadingProfileConfigTestCase.this.getMaxBufferSize();
            }
        });
    }

    @Test
    public void usesDefaultMaxThreadTTL() throws Exception {
        this.checkMaxThreadTTL(60000L);
    }

    @Test
    public void usesCustomMaxThreadTTL() throws Exception {
        long customValue = 60001L;
        MuleTestUtils.testWithSystemProperty("mule.defaultThreadingProfile.maxThreadTTL", Long.toString(60001L), new MuleTestUtils.TestCallback(){

            @Override
            public void run() throws Exception {
                DefaultThreadingProfileConfigTestCase.this.checkMaxThreadTTL(60001L);
            }
        });
    }

    @Test(expected=ExceptionInInitializerError.class)
    public void failsOnInvalidCustomMaxThreadsTTL() throws Exception {
        MuleTestUtils.testWithSystemProperty("mule.defaultThreadingProfile.maxThreadTTL", INVALID_PROPERTY_VALUE, new MuleTestUtils.TestCallback(){

            @Override
            public void run() throws Exception {
                DefaultThreadingProfileConfigTestCase.this.getMaxThreadTTL();
            }
        });
    }

    @Test
    public void usesDefaultThreadWaitTimeout() throws Exception {
        this.checkThreadWaitTimeout(30000L);
    }

    @Test
    public void usesCustomThreadWaitTimeout() throws Exception {
        long customValue = 30001L;
        MuleTestUtils.testWithSystemProperty("mule.defaultThreadingProfile.maxWaitTimeout", Long.toString(30001L), new MuleTestUtils.TestCallback(){

            @Override
            public void run() throws Exception {
                DefaultThreadingProfileConfigTestCase.this.checkThreadWaitTimeout(30001L);
            }
        });
    }

    @Test(expected=ExceptionInInitializerError.class)
    public void failsOnInvalidCustomThreadWaitTimeout() throws Exception {
        MuleTestUtils.testWithSystemProperty("mule.defaultThreadingProfile.maxWaitTimeout", INVALID_PROPERTY_VALUE, new MuleTestUtils.TestCallback(){

            @Override
            public void run() throws Exception {
                DefaultThreadingProfileConfigTestCase.this.getThreadWaitTimeout();
            }
        });
    }

    private void checkMaxThreadsActive(int expected) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        Assert.assertThat((Object)this.getMaxThreadsActive(), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    private void checkMaxThreadsIdle(int expected) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        Assert.assertThat((Object)this.getMaxThreadsIdle(), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    private void checkMaxBufferSize(int expected) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        Assert.assertThat((Object)this.getMaxBufferSize(), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    private void checkMaxThreadTTL(long expected) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        Assert.assertThat((Object)this.getMaxThreadTTL(), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    private void checkThreadWaitTimeout(long expected) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        Assert.assertThat((Object)this.getThreadWaitTimeout(), (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    private int getMaxThreadsActive() throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        return this.getIntegerConstant("DEFAULT_MAX_THREADS_ACTIVE");
    }

    private int getMaxThreadsIdle() throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        return this.getIntegerConstant("DEFAULT_MAX_THREADS_IDLE");
    }

    private int getMaxBufferSize() throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        return this.getIntegerConstant("DEFAULT_MAX_BUFFER_SIZE");
    }

    private long getMaxThreadTTL() throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        return this.getLongConstant("DEFAULT_MAX_THREAD_TTL");
    }

    private long getThreadWaitTimeout() throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        return this.getLongConstant("DEFAULT_THREAD_WAIT_TIMEOUT");
    }

    private int getIntegerConstant(String fieldName) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        Class clazz = this.loadDefaultThreadingProfileClass();
        Field field = clazz.getDeclaredField(fieldName);
        return field.getInt(clazz);
    }

    private long getLongConstant(String fieldName) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        Class clazz = this.loadDefaultThreadingProfileClass();
        Field field = clazz.getDeclaredField(fieldName);
        return field.getLong(clazz);
    }

    private Class loadDefaultThreadingProfileClass() throws ClassNotFoundException {
        URLClassLoader classLoader = new URLClassLoader(((URLClassLoader)Thread.currentThread().getContextClassLoader()).getURLs(), null);
        return ClassUtils.loadClass((String)DefaultThreadingProfileConfig.class.getCanonicalName(), (ClassLoader)classLoader);
    }
}

