/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.datetime;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.el.datetime.Instant;
import org.mule.api.store.ObjectStore;
import org.mule.el.datetime.DateTime;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class DateTimeTestCase
extends AbstractMuleContextTestCase {
    private Calendar currentCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    private DateTime now = new DateTime(this.currentCalendar).withTimeZone("UTC");

    @Test
    public void milliSeconds() {
        junit.framework.Assert.assertTrue((this.now.getMilliSeconds() < 1000L ? 1 : 0) != 0);
    }

    @Test
    public void isBefore() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, 1);
        junit.framework.Assert.assertTrue((boolean)this.now.isBefore((Instant)new DateTime(cal)));
    }

    @Test
    public void isAfter() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        junit.framework.Assert.assertTrue((boolean)this.now.isAfter((Instant)new DateTime(cal)));
    }

    @Test
    public void format() {
        SimpleDateFormat df = new SimpleDateFormat("EEE, MMM d, yyyy");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        junit.framework.Assert.assertEquals((String)df.format(this.now.toDate()), (String)this.now.format("EEE, MMM d, yyyy"));
    }

    @Test
    public void timeZone() {
        junit.framework.Assert.assertEquals((String)TimeZone.getTimeZone("UTC").getDisplayName(), (String)this.now.getTimeZone());
    }

    @Test
    public void plusSeconds() {
        junit.framework.Assert.assertEquals((int)((this.currentCalendar.get(13) + 1) % 60), (int)this.now.plusSeconds(1).getSeconds());
    }

    @Test
    public void plusMinutes() {
        junit.framework.Assert.assertEquals((int)((this.now.getMinutes() + 1) % 60), (int)this.now.plusMinutes(1).getMinutes());
    }

    @Test
    public void plusHours() {
        junit.framework.Assert.assertEquals((int)((this.now.getHours() + 1) % 24), (int)this.now.plusHours(1).getHours());
    }

    @Test
    public void plusDays() {
        junit.framework.Assert.assertEquals((int)(this.now.getDayOfYear() % 365 + 1), (int)this.now.plusDays(1).getDayOfYear());
    }

    @Test
    public void plusWeeks() {
        junit.framework.Assert.assertEquals((int)(this.now.getWeekOfYear() % 52 + 1), (int)this.now.plusWeeks(1).getWeekOfYear());
    }

    @Test
    public void plusMonths() {
        junit.framework.Assert.assertEquals((int)(this.now.getMonth() % 12 + 1), (int)this.now.plusMonths(1).getMonth());
    }

    @Test
    public void plusYears() {
        junit.framework.Assert.assertEquals((int)(this.now.getYear() + 1), (int)this.now.plusYears(1).getYear());
    }

    @Test
    public void withTimeZone() {
        int hour = this.now.getHours();
        Assert.assertEquals((long)hour, (long)this.now.withTimeZone("GMT-03:00").getHours());
    }

    @Test
    public void changeTimeZone() {
        int hour = this.now.getHours();
        Assert.assertEquals((long)((hour + 24 - 3) % 24), (long)this.now.changeTimeZone("GMT-03:00").getHours());
    }

    @Test
    public void withLocale() {
        SimpleDateFormat df = new SimpleDateFormat("E");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        Assert.assertEquals((Object)df.format(new Date()), (Object)this.now.withLocale("en_US").format("E"));
    }

    @Test
    public void seconds() {
        Assert.assertEquals((long)this.currentCalendar.get(13), (long)this.now.getSeconds());
    }

    @Test
    public void minutes() {
        Assert.assertEquals((long)this.currentCalendar.get(12), (long)this.now.getMinutes());
    }

    @Test
    public void hourOfDay() {
        Assert.assertEquals((long)this.currentCalendar.get(11), (long)this.now.getHours());
    }

    @Test
    public void dayOfWeek() {
        Assert.assertEquals((long)this.currentCalendar.get(7), (long)this.now.getDayOfWeek());
    }

    @Test
    public void dayOfMonth() {
        Assert.assertEquals((long)this.currentCalendar.get(5), (long)this.now.getDayOfMonth());
    }

    @Test
    public void dayOfYear() {
        Assert.assertEquals((long)this.currentCalendar.get(6), (long)this.now.getDayOfYear());
    }

    @Test
    public void weekOfMonth() {
        Assert.assertEquals((long)this.currentCalendar.get(4), (long)this.now.getWeekOfMonth());
    }

    @Test
    public void weekOfYear() {
        Assert.assertEquals((long)this.currentCalendar.get(3), (long)this.now.getWeekOfYear());
    }

    @Test
    public void monthOfYear() {
        Assert.assertEquals((long)(this.currentCalendar.get(2) + 1), (long)this.now.getMonth());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)DatatypeConverter.printDateTime((Calendar)this.currentCalendar).substring(0, 18), (Object)this.now.toString().substring(0, 18));
    }

    @Test
    public void toDate() {
        Assert.assertEquals(Date.class, this.now.toDate().getClass());
    }

    @Test
    public void toCalendar() {
        Assert.assertEquals(GregorianCalendar.class, this.now.toCalendar().getClass());
    }

    @Test
    public void toXMLCalendar() throws DatatypeConfigurationException {
        Assert.assertTrue((boolean)(this.now.toXMLCalendar() instanceof XMLGregorianCalendar));
    }

    @Test
    public void fromDate() {
        Date date = new Date();
        date.setYear(0);
        date.setMonth(0);
        date.setDate(1);
        Assert.assertEquals((long)1900L, (long)new DateTime(date).getYear());
        Assert.assertEquals((long)1L, (long)new DateTime(date).getMonth());
        Assert.assertEquals((long)1L, (long)new DateTime(date).getDayOfMonth());
    }

    @Test
    public void fromCalendar() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1, 1900);
        cal.set(2, 0);
        cal.set(5, 1);
        Assert.assertEquals((long)1900L, (long)new DateTime((Calendar)cal).getYear());
        Assert.assertEquals((long)1L, (long)new DateTime((Calendar)cal).getMonth());
        Assert.assertEquals((long)1L, (long)new DateTime((Calendar)cal).getDayOfMonth());
    }

    @Test
    public void fromXMLCalendar() throws DatatypeConfigurationException {
        XMLGregorianCalendar xmlCal = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
        xmlCal.setYear(1900);
        xmlCal.setMonth(1);
        xmlCal.setDay(1);
        Assert.assertEquals((long)1900L, (long)new DateTime(xmlCal).getYear());
        Assert.assertEquals((long)1L, (long)new DateTime(xmlCal).getMonth());
        Assert.assertEquals((long)1L, (long)new DateTime(xmlCal).getDayOfMonth());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void serialization() throws Exception {
        String key = "key";
        ObjectStore os = muleContext.getObjectStoreManager().getObjectStore("DateTimeTestCase", true);
        try {
            os.store((Serializable)((Object)"key"), (Serializable)this.now);
            DateTime recovered = (DateTime)os.retrieve((Serializable)((Object)"key"));
            Assert.assertEquals((Object)this.now, (Object)recovered);
        }
        finally {
            os.clear();
        }
    }
}

