/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.mvel.datatype;

import java.nio.charset.StandardCharsets;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.api.transformer.DataType;
import org.mule.el.mvel.MVELExpressionLanguage;
import org.mule.el.mvel.datatype.PayloadEnricherDataTypePropagator;
import org.mule.mvel2.MVEL;
import org.mule.mvel2.ParserContext;
import org.mule.mvel2.compiler.CompiledExpression;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.matcher.DataTypeMatcher;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transformer.types.TypedValue;

public class PayloadEnricherDataTypePropagatorTestCase
extends AbstractMuleContextTestCase {
    public static final String CUSTOM_ENCODING = StandardCharsets.UTF_16.name();
    private final PayloadEnricherDataTypePropagator dataTypePropagator = new PayloadEnricherDataTypePropagator();

    @Test
    public void propagatesPayloadDataType() throws Exception {
        this.doPayloadDataTypeTest("payload = 'unused'");
    }

    @Test
    public void propagatesMessagePayloadDataType() throws Exception {
        this.doPayloadDataTypeTest("message.payload = 'unused'");
    }

    private void doPayloadDataTypeTest(String expression) throws Exception {
        DataType expectedDataType = DataTypeFactory.create(String.class, (String)"text/json");
        expectedDataType.setEncoding(CUSTOM_ENCODING);
        MVELExpressionLanguage expressionLanguage = (MVELExpressionLanguage)muleContext.getExpressionLanguage();
        CompiledExpression compiledExpression = (CompiledExpression)MVEL.compileExpression((String)expression, (ParserContext)new ParserContext(expressionLanguage.getParserConfiguration()));
        MuleEvent testEvent = PayloadEnricherDataTypePropagatorTestCase.getTestEvent("Test Message");
        this.dataTypePropagator.propagate(testEvent.getMessage(), new TypedValue((Object)"Test Message", expectedDataType), compiledExpression);
        MatcherAssert.assertThat((Object)testEvent.getMessage().getDataType(), DataTypeMatcher.like(String.class, "text/json", CUSTOM_ENCODING));
    }
}

