/*
 * Decompiled with CFR 0.152.
 */
package org.mule.mule.enricher;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.NonBlockingVoidMuleEvent;
import org.mule.RequestContext;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transformer.DataType;
import org.mule.api.transport.PropertyScope;
import org.mule.api.transport.ReplyToHandler;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.config.i18n.CoreMessages;
import org.mule.construct.Flow;
import org.mule.enricher.MessageEnricher;
import org.mule.processor.chain.DefaultMessageProcessorChain;
import org.mule.processor.strategy.NonBlockingProcessingStrategy;
import org.mule.tck.SensingNullMessageProcessor;
import org.mule.tck.SensingNullReplyToHandler;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.matcher.DataTypeMatcher;
import org.mule.transformer.simple.StringAppendTransformer;
import org.mule.transformer.types.DataTypeFactory;

public class MessageEnricherTestCase
extends AbstractMuleContextTestCase {
    public static final String FOO_FLOW_VAR_EXPRESSION = "#[flowVars['foo']]";

    @Test
    public void testEnrichHeaderWithPayload() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[header:myHeader]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setPayload((Object)"test");
                return event;
            }
        });
        enricher.initialise();
        MuleMessage result = enricher.process(MessageEnricherTestCase.getTestEvent("")).getMessage();
        Assert.assertEquals((Object)"test", (Object)result.getOutboundProperty("myHeader"));
        Assert.assertEquals((Object)"", (Object)result.getPayload());
    }

    @Test
    public void testEnrichHeaderWithHeader() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[header:header1]", "#[header:myHeader]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setOutboundProperty("header1", (Object)"test");
                return event;
            }
        });
        MuleMessage result = enricher.process(MessageEnricherTestCase.getTestEvent("")).getMessage();
        Assert.assertEquals((Object)"test", (Object)result.getOutboundProperty("myHeader"));
        Assert.assertEquals((Object)"", (Object)result.getPayload());
    }

    @Test
    public void testEnrichHeadersMToN() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[header:header1]", "#[header:myHeader1]"));
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[header:header2]", "#[header:myHeader2]"));
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[header:header3]", "#[header:myHeader3]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setOutboundProperty("header1", (Object)"test");
                event.getMessage().setOutboundProperty("header2", (Object)"test2");
                event.getMessage().setOutboundProperty("header3", (Object)"test3");
                return event;
            }
        });
        MuleMessage result = enricher.process(MessageEnricherTestCase.getTestEvent("")).getMessage();
        Assert.assertNull((Object)result.getOutboundProperty("myHeader"));
        Assert.assertEquals((Object)"test2", (Object)result.getOutboundProperty("myHeader2"));
        Assert.assertEquals((Object)"test3", (Object)result.getOutboundProperty("myHeader3"));
        Assert.assertEquals((Object)"", (Object)result.getPayload());
    }

    @Test
    public void testEnrichHeaderNestedEvaluator() throws Exception {
        muleContext.getRegistry().registerObject("appender", (Object)new StringAppendTransformer(" append"));
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[process:appender:#[header:header1]]", "#[header:myHeader]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setOutboundProperty("header1", (Object)"test");
                return event;
            }
        });
        MuleEvent event = MessageEnricherTestCase.getTestEvent("");
        RequestContext.setEvent((MuleEvent)event);
        Assert.assertEquals((Object)"test append", (Object)enricher.process(MessageEnricherTestCase.getTestEvent("")).getMessage().getOutboundProperty("myHeader"));
    }

    @Test
    public void testEnrichWithNullResponse() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[header:myHeader]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                return null;
            }
        });
        MuleMessage result = enricher.process(MessageEnricherTestCase.getTestEvent("")).getMessage();
        Assert.assertNull((Object)result.getOutboundProperty("myHeader"));
        Assert.assertEquals((Object)"", (Object)result.getPayload());
    }

    @Test
    public void testEnrichWithException() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[header:myHeader]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                throw new MessagingException(CoreMessages.createStaticMessage((String)"Expected"), event);
            }
        });
        try {
            enricher.process(MessageEnricherTestCase.getTestEvent(""));
            Assert.fail((String)"Expected a MessagingException");
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"Expected."));
        }
        Assert.assertThat((Object)RequestContext.getEvent().getReplyToHandler(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void propogateMessage() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[header:myHeader]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setPayload((Object)"enriched");
                return event;
            }
        });
        MuleEvent in = MessageEnricherTestCase.getTestEvent("");
        in.getMessage().setOutboundProperty("foo", (Object)"bar");
        MuleEvent out = enricher.process(in);
        junit.framework.Assert.assertSame((Object)in, (Object)out);
        junit.framework.Assert.assertSame((Object)in.getMessage(), (Object)out.getMessage());
        Assert.assertEquals((Object)in.getMessage().getUniqueId(), (Object)out.getMessage().getUniqueId());
        Assert.assertEquals((Object)in.getMessage().getPropertyNames(), (Object)out.getMessage().getPropertyNames());
        Assert.assertEquals((Object)"bar", (Object)out.getMessage().getOutboundProperty("foo"));
        Assert.assertEquals((Object)in.getMessage().getPayload(), (Object)out.getMessage().getPayload());
    }

    @Test
    public void propogateMessagePropagateSession() throws Exception {
        ((DefaultMuleConfiguration)muleContext.getConfiguration()).setEnricherPropagatesSessionVariableChanges(true);
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[header:myHeader]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setPayload((Object)"enriched");
                return event;
            }
        });
        MuleEvent in = MessageEnricherTestCase.getTestEvent("");
        in.getMessage().setOutboundProperty("foo", (Object)"bar");
        MuleEvent out = enricher.process(in);
        junit.framework.Assert.assertNotSame((Object)in, (Object)out);
        junit.framework.Assert.assertSame((Object)in.getMessage(), (Object)out.getMessage());
        Assert.assertEquals((Object)in.getMessage().getUniqueId(), (Object)out.getMessage().getUniqueId());
        Assert.assertEquals((Object)in.getMessage().getPropertyNames(), (Object)out.getMessage().getPropertyNames());
        Assert.assertEquals((Object)"bar", (Object)out.getMessage().getOutboundProperty("foo"));
        Assert.assertEquals((Object)"", (Object)out.getMessage().getPayload());
    }

    @Test
    public void propagatesVariables() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[header:myHeader]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setPayload((Object)"enriched");
                return event;
            }
        });
        MuleEvent in = MessageEnricherTestCase.getTestEvent("");
        in.getSession().setProperty("sessionFoo", (Serializable)((Object)"bar"));
        in.getMessage().setInvocationProperty("flowFoo", (Object)"bar");
        MuleEvent out = enricher.process(in);
        Assert.assertEquals((Object)"bar", (Object)out.getSession().getProperty("sessionFoo"));
        Assert.assertEquals((Object)"bar", (Object)out.getMessage().getInvocationProperty("flowFoo"));
    }

    @Test
    public void doNotImplicitlyEnrichMessagePayload() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[header:myHeader]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setPayload((Object)"enriched");
                return event;
            }
        });
        MuleEvent in = MessageEnricherTestCase.getTestEvent("");
        MuleEvent out = enricher.process(in);
        Assert.assertEquals((Object)"", (Object)out.getMessage().getPayload());
    }

    @Test
    public void doNotImplicitlyEnrichMessageProperties() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[header:myHeader]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setOutboundProperty("foo", (Object)"bar");
                return event;
            }
        });
        MuleEvent in = MessageEnricherTestCase.getTestEvent("");
        MuleEvent out = enricher.process(in);
        Assert.assertNull((Object)out.getMessage().getOutboundProperty("foo"));
    }

    @Test
    public void doNotImplicitlyEnrichFlowVariable() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[header:myHeader]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setInvocationProperty("flowFoo", (Object)"bar");
                return event;
            }
        });
        MuleEvent in = MessageEnricherTestCase.getTestEvent("");
        MuleEvent out = enricher.process(in);
        Assert.assertNull((Object)out.getMessage().getInvocationProperty("flowFoo"));
    }

    @Test
    public void doNotImplicitlyEnrichSessionVariable() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[header:myHeader]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getSession().setProperty("sessionFoo", (Serializable)((Object)"bar"));
                return event;
            }
        });
        MuleEvent in = MessageEnricherTestCase.getTestEvent("");
        MuleEvent out = enricher.process(in);
        Assert.assertNull((Object)out.getSession().getProperty("sessionFoo"));
    }

    @Test
    public void propagatesSession() throws Exception {
        ((DefaultMuleConfiguration)muleContext.getConfiguration()).setEnricherPropagatesSessionVariableChanges(true);
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[header:myHeader]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getSession().setProperty("sessionFoo", (Serializable)((Object)"bar"));
                return event;
            }
        });
        MuleEvent in = MessageEnricherTestCase.getTestEvent("");
        MuleEvent out = enricher.process(in);
        Assert.assertEquals((Object)"bar", (Object)out.getSession().getProperty("sessionFoo"));
    }

    @Test
    public void enrichFlowVariable() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[variable:foo]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setPayload((Object)"bar");
                return event;
            }
        });
        MuleEvent in = MessageEnricherTestCase.getTestEvent("");
        MuleEvent out = enricher.process(in);
        Assert.assertEquals((Object)"bar", (Object)out.getMessage().getInvocationProperty("foo"));
    }

    @Test
    public void enrichSessionVariable() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[sessionVars['foo']]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setPayload((Object)"bar");
                return event;
            }
        });
        MuleEvent in = MessageEnricherTestCase.getTestEvent("");
        MuleEvent out = enricher.process(in);
        Assert.assertEquals((Object)"bar", (Object)out.getSessionVariable("foo"));
    }

    @Test
    public void enrichesFlowVarWithDataType() throws Exception {
        this.doEnrichDataTypePropagationTest(new MessageEnricher.EnrichExpressionPair("#[payload]", FOO_FLOW_VAR_EXPRESSION));
    }

    @Test
    public void enrichesFlowVarWithDataTypeUsingExpressionEvaluator() throws Exception {
        this.doEnrichDataTypePropagationTest(new MessageEnricher.EnrichExpressionPair(FOO_FLOW_VAR_EXPRESSION));
    }

    @Test
    public void enricherConservesSameEventInstance() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[sessionVars['foo']]"));
        SensingNullMessageProcessor sensingNullMessageProcessor = new SensingNullMessageProcessor();
        enricher.setEnrichmentMessageProcessor((MessageProcessor)sensingNullMessageProcessor);
        DefaultMuleEvent in = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext), MessageExchangePattern.REQUEST_RESPONSE, (FlowConstruct)Mockito.mock(Flow.class));
        MuleEvent out = enricher.process((MuleEvent)in);
        Assert.assertThat((Object)out, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)in)));
        Assert.assertThat((Object)sensingNullMessageProcessor.event, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)in)));
    }

    @Test
    public void enricherConservesSameEventInstanceNonBlockingTargetNonBlocking() throws Exception {
        SensingNullMessageProcessor sensingNullMessageProcessor = new SensingNullMessageProcessor();
        MessageEnricher enricher = this.createNonBlockingEnricher(sensingNullMessageProcessor);
        SensingNullReplyToHandler nullReplyToHandler = new SensingNullReplyToHandler();
        MuleEvent in = this.createNonBlockingEvent(nullReplyToHandler);
        MuleEvent out = this.processEnricherInChain(enricher, in);
        nullReplyToHandler.latch.await(5000L, TimeUnit.MILLISECONDS);
        Assert.assertThat((Object)sensingNullMessageProcessor.event.getMessage(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)in.getMessage())));
        Assert.assertThat((Object)out, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(NonBlockingVoidMuleEvent.class)));
        Assert.assertThat((Object)nullReplyToHandler.event.getMessage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)in.getMessage())));
    }

    @Test
    public void enricherConservesSameEventInstanceNonBlockingTargetBlocking() throws Exception {
        SensingNullMessageProcessor sensingNullMessageProcessor = new SensingNullMessageProcessor(){

            @Override
            public boolean isNonBlocking(MuleEvent event) {
                return false;
            }
        };
        MessageEnricher enricher = this.createNonBlockingEnricher(sensingNullMessageProcessor);
        SensingNullReplyToHandler nullReplyToHandler = new SensingNullReplyToHandler();
        MuleEvent in = this.createNonBlockingEvent(nullReplyToHandler);
        MuleEvent out = this.processEnricherInChain(enricher, in);
        Assert.assertThat((Object)sensingNullMessageProcessor.event.getMessage(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)in.getMessage())));
        Assert.assertThat((Object)out.getMessage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)in.getMessage())));
    }

    @Test
    public void testEnrichWithExceptionNonBlocking() throws Exception {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[header:myHeader]"));
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                throw new MessagingException(CoreMessages.createStaticMessage((String)"Expected"), event);
            }
        });
        try {
            SensingNullReplyToHandler nullReplyToHandler = new SensingNullReplyToHandler();
            enricher.process(this.createNonBlockingEvent(nullReplyToHandler));
            Assert.fail((String)"Expected a MessagingException");
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"Expected."));
        }
        Assert.assertThat((Object)RequestContext.getEvent().getReplyToHandler(), (Matcher)CoreMatchers.instanceOf(ReplyToHandler.class));
    }

    private MuleEvent createNonBlockingEvent(SensingNullReplyToHandler nullReplyToHandler) {
        Flow flow = (Flow)Mockito.mock(Flow.class);
        Mockito.when((Object)flow.getProcessingStrategy()).thenReturn((Object)new NonBlockingProcessingStrategy());
        return new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)"Test Message", muleContext), MessageExchangePattern.REQUEST_RESPONSE, (ReplyToHandler)nullReplyToHandler, (FlowConstruct)flow);
    }

    private MessageEnricher createNonBlockingEnricher(SensingNullMessageProcessor sensingNullMessageProcessor) {
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(new MessageEnricher.EnrichExpressionPair("#[sessionVars['foo']]"));
        enricher.setEnrichmentMessageProcessor((MessageProcessor)sensingNullMessageProcessor);
        return enricher;
    }

    private MuleEvent processEnricherInChain(MessageEnricher enricher, final MuleEvent in) throws MuleException {
        return DefaultMessageProcessorChain.from((MessageProcessor[])new MessageProcessor[]{enricher, new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                ((ThreadSafeAccess)event).assertAccess(true);
                Assert.assertThat((Object)event.getMessage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)in.getMessage())));
                return event;
            }
        }}).process(in);
    }

    private void doEnrichDataTypePropagationTest(MessageEnricher.EnrichExpressionPair pair) throws Exception {
        final DataType dataType = DataTypeFactory.create(String.class, (String)"text/json");
        dataType.setEncoding(StandardCharsets.UTF_16.name());
        MessageEnricher enricher = new MessageEnricher();
        enricher.setMuleContext(muleContext);
        enricher.addEnrichExpressionPair(pair);
        enricher.setEnrichmentMessageProcessor(new MessageProcessor(){

            public MuleEvent process(MuleEvent event) throws MuleException {
                event.getMessage().setPayload((Object)"bar", dataType);
                return event;
            }
        });
        MuleEvent in = MessageEnricherTestCase.getTestEvent("");
        MuleEvent out = enricher.process(in);
        Assert.assertEquals((Object)"bar", (Object)out.getMessage().getInvocationProperty("foo"));
        Assert.assertThat((Object)out.getMessage().getPropertyDataType("foo", PropertyScope.INVOCATION), DataTypeMatcher.like(String.class, "text/json", StandardCharsets.UTF_16.name()));
    }
}

