/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleMessageCollection;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.filter.Filter;
import org.mule.api.transport.PropertyScope;
import org.mule.routing.CorrelationMode;
import org.mule.routing.filters.RegExFilter;
import org.mule.routing.outbound.MulticastingRouter;
import org.mule.routing.outbound.OutboundRoutingTestEvent;
import org.mule.routing.outbound.RouterTestUtils;
import org.mule.tck.MuleEventCheckAnswer;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class MulticastingRouterTestCase
extends AbstractMuleContextTestCase {
    public MulticastingRouterTestCase() {
        this.setStartContext(true);
    }

    @Test
    public void testMulticastingRouterAsync() throws Exception {
        RegExFilter filter = new RegExFilter("(.*) Message");
        OutboundEndpoint endpoint1 = MulticastingRouterTestCase.getTestOutboundEndpoint("Test1Provider", "test://test1", null, (Filter)filter, null);
        Assert.assertNotNull((Object)endpoint1);
        OutboundEndpoint mockendpoint1 = RouterTestUtils.createMockEndpoint(endpoint1);
        OutboundEndpoint endpoint2 = MulticastingRouterTestCase.getTestOutboundEndpoint("Test2Provider", "test://test2", null, (Filter)filter, null);
        Assert.assertNotNull((Object)endpoint2);
        OutboundEndpoint mockendpoint2 = RouterTestUtils.createMockEndpoint(endpoint2);
        MulticastingRouter router = this.createObject(MulticastingRouter.class);
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add(mockendpoint1);
        endpoints.add(mockendpoint2);
        router.setRoutes(endpoints);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", muleContext);
        Assert.assertTrue((boolean)router.isMatch((MuleMessage)message));
        Mockito.when((Object)mockendpoint1.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer());
        Mockito.when((Object)mockendpoint2.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer());
        MuleSession session = (MuleSession)Mockito.mock(MuleSession.class);
        router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, session, muleContext));
    }

    @Test
    public void testMulticastingRouterSync() throws Exception {
        OutboundEndpoint endpoint1 = MulticastingRouterTestCase.getTestOutboundEndpoint("Test1Provider", "test://Test1Provider?exchangePattern=request-response");
        Assert.assertNotNull((Object)endpoint1);
        OutboundEndpoint mockendpoint1 = RouterTestUtils.createMockEndpoint(endpoint1);
        OutboundEndpoint endpoint2 = MulticastingRouterTestCase.getTestOutboundEndpoint("Test2Provider", "test://Test2Provider?exchangePattern=request-response");
        Assert.assertNotNull((Object)endpoint2);
        OutboundEndpoint mockendpoint2 = RouterTestUtils.createMockEndpoint(endpoint2);
        MulticastingRouter router = this.createObject(MulticastingRouter.class);
        RegExFilter filter = new RegExFilter("(.*) Message");
        router.setFilter((Filter)filter);
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add(mockendpoint1);
        endpoints.add(mockendpoint2);
        router.setRoutes(endpoints);
        Assert.assertEquals((Object)filter, (Object)router.getFilter());
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", muleContext);
        Assert.assertTrue((boolean)router.isMatch((MuleMessage)message));
        OutboundRoutingTestEvent event = new OutboundRoutingTestEvent((MuleMessage)message, null, muleContext);
        Mockito.when((Object)mockendpoint1.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer(event));
        Mockito.when((Object)mockendpoint2.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer(event));
        MuleSession session = (MuleSession)Mockito.mock(MuleSession.class);
        MuleEvent result = router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, session, muleContext));
        Assert.assertNotNull((Object)result);
        MuleMessage resultMessage = result.getMessage();
        Assert.assertNotNull((Object)resultMessage);
        Assert.assertTrue((boolean)(resultMessage instanceof MuleMessageCollection));
        Assert.assertEquals((long)2L, (long)((MuleMessageCollection)resultMessage).size());
    }

    @Test
    public void testMulticastingRouterMixedSyncAsync() throws Exception {
        OutboundEndpoint endpoint1 = MulticastingRouterTestCase.getTestOutboundEndpoint("Test1Provider", "test://Test1Provider?exchangePattern=request-response");
        Assert.assertNotNull((Object)endpoint1);
        OutboundEndpoint mockendpoint1 = RouterTestUtils.createMockEndpoint(endpoint1);
        OutboundEndpoint endpoint2 = MulticastingRouterTestCase.getTestOutboundEndpoint("Test2Provider", "test://Test2Provider?exchangePattern=request-response");
        Assert.assertNotNull((Object)endpoint2);
        OutboundEndpoint mockendpoint2 = RouterTestUtils.createMockEndpoint(endpoint2);
        MulticastingRouter router = this.createObject(MulticastingRouter.class);
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add(mockendpoint1);
        endpoints.add(mockendpoint2);
        router.setRoutes(endpoints);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", muleContext);
        Assert.assertTrue((boolean)router.isMatch((MuleMessage)message));
        OutboundRoutingTestEvent event = new OutboundRoutingTestEvent((MuleMessage)message, null, muleContext);
        Mockito.when((Object)mockendpoint1.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer(event));
        Mockito.when((Object)mockendpoint2.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer());
        MuleSession session = (MuleSession)Mockito.mock(MuleSession.class);
        MuleEvent result = router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, session, muleContext));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)this.getPayload((MuleMessage)message), (Object)this.getPayload(result.getMessage()));
    }

    @Test
    public void testMulticastingRouterCorrelationIdPropagation() throws Exception {
        RegExFilter filter = new RegExFilter("(.*) Message");
        OutboundEndpoint endpoint1 = MulticastingRouterTestCase.getTestOutboundEndpoint("Test1Provider", "test://test1", null, (Filter)filter, null);
        Assert.assertNotNull((Object)endpoint1);
        OutboundEndpoint mockendpoint1 = RouterTestUtils.createMockEndpoint(endpoint1);
        OutboundEndpoint endpoint2 = MulticastingRouterTestCase.getTestOutboundEndpoint("Test2Provider", "test://test2", null, (Filter)filter, null);
        Assert.assertNotNull((Object)endpoint2);
        OutboundEndpoint mockendpoint2 = RouterTestUtils.createMockEndpoint(endpoint2);
        MulticastingRouter router = this.createObject(MulticastingRouter.class);
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add(mockendpoint1);
        endpoints.add(mockendpoint2);
        router.setRoutes(endpoints);
        router.setEnableCorrelation(CorrelationMode.NEVER);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", muleContext);
        message.setProperty("MULE_CORRELATION_ID", (Object)"MyCustomCorrelationId", PropertyScope.INBOUND);
        Assert.assertTrue((boolean)router.isMatch((MuleMessage)message));
        Answer<MuleEvent> answer = new Answer<MuleEvent>(){

            public MuleEvent answer(InvocationOnMock invocation) throws Throwable {
                Object[] arguments = invocation.getArguments();
                Assert.assertEquals((long)1L, (long)arguments.length);
                Assert.assertTrue((boolean)(arguments[0] instanceof MuleEvent));
                MuleEvent event = (MuleEvent)arguments[0];
                String correlationId = (String)event.getMessage().getOutboundProperty("MULE_CORRELATION_ID");
                Assert.assertNotNull((Object)correlationId);
                Assert.assertEquals((Object)"MyCustomCorrelationId", (Object)correlationId);
                return event;
            }
        };
        Mockito.when((Object)mockendpoint1.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)answer);
        Mockito.when((Object)mockendpoint2.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)answer);
        MuleSession session = (MuleSession)Mockito.mock(MuleSession.class);
        router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, session, muleContext));
    }

    private String getPayload(MuleMessage message) throws Exception {
        Object payload = message.getPayload();
        if (payload instanceof List) {
            payload = ((List)payload).get(0);
        }
        return payload.toString();
    }
}

