/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import junit.framework.Assert;
import org.junit.Test;
import org.mule.api.transport.Connectable;
import org.mule.tck.SerializationTestUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transport.ConnectException;
import org.mule.transport.TestNotSerializableConnectable;
import org.mule.transport.TestSerializableConnectable;

public class ConnectExceptionTestCase
extends AbstractMuleContextTestCase {
    private static final String message = "a message";
    private static final String value = "Hello world!";

    @Test
    public void testSerializableConnectException() throws Exception {
        TestSerializableConnectable connectable = new TestSerializableConnectable();
        connectable.setValue(value);
        ConnectException e = new ConnectException((Throwable)new Exception(message), (Connectable)connectable);
        e = SerializationTestUtils.testException(e, muleContext);
        Assert.assertTrue((boolean)e.getMessage().contains(message));
        Connectable failed = e.getFailed();
        Assert.assertNotNull((String)"Connectable was not serialized", (Object)failed);
        Assert.assertTrue((boolean)(failed instanceof TestSerializableConnectable));
        Assert.assertEquals((String)value, (String)((TestSerializableConnectable)failed).getValue());
    }

    @Test
    public void testNonSerializableConnectException() throws Exception {
        ConnectException e = new ConnectException((Throwable)new Exception(message), (Connectable)new TestNotSerializableConnectable());
        e = SerializationTestUtils.testException(e, muleContext);
        Assert.assertTrue((boolean)e.getMessage().contains(message));
        Connectable failed = e.getFailed();
        Assert.assertNull((Object)failed);
    }
}

