/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.nio.charset.StandardCharsets;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.api.transformer.DataType;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.DataTypeUtils;

@SmallTest
public class DataTypeUtilsTestCase
extends AbstractMuleTestCase {
    @Test
    public void generatesContentTypeWithCharset() throws Exception {
        DataType dataType = DataTypeFactory.create(Object.class, (String)"application/json");
        dataType.setEncoding(StandardCharsets.UTF_8.name());
        String contentType = DataTypeUtils.getContentType((DataType)dataType);
        MatcherAssert.assertThat((Object)contentType, (Matcher)Matchers.equalTo((Object)"application/json; charset=UTF-8"));
    }

    @Test
    public void generatesContentTypeWithoutCharset() throws Exception {
        DataType dataType = DataTypeFactory.create(Object.class, (String)"application/json");
        String contentType = DataTypeUtils.getContentType((DataType)dataType);
        MatcherAssert.assertThat((Object)contentType, (Matcher)Matchers.equalTo((Object)"application/json"));
    }
}

