/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.util.FileUtils;
import org.mule.util.FilenameUtils;
import org.mule.util.SystemUtils;

@SmallTest
public class FilenameUtilsTestCase
extends AbstractMuleTestCase {
    @Test
    public void testFileWithPathComponentsNullParameter() {
        File result = FilenameUtils.fileWithPathComponents(null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testFileWithNullElements() {
        File tempDir = this.getBuidDirectory();
        File result = FilenameUtils.fileWithPathComponents((String[])new String[]{tempDir.getAbsolutePath(), "tmp", null, "bar"});
        String resultNormalized = result.getAbsolutePath().replace(File.separatorChar, '|');
        String excpected = tempDir.getAbsolutePath().replace(File.separatorChar, '|') + "|tmp|bar";
        Assert.assertEquals((Object)excpected, (Object)resultNormalized);
    }

    @Test
    public void testFileWithPathComponents() {
        String tempDirPath = this.getBuidDirectory().getAbsolutePath();
        File result = FilenameUtils.fileWithPathComponents((String[])new String[]{tempDirPath, "tmp", "foo", "bar"});
        String resultNormalized = result.getAbsolutePath().replace(File.separatorChar, '|');
        String expected = tempDirPath.replace(File.separatorChar, '|') + "|tmp|foo|bar";
        Assert.assertEquals((Object)expected, (Object)resultNormalized);
    }

    private File getBuidDirectory() {
        return FileUtils.newFile((File)SystemUtils.getUserDir(), (String)"target");
    }
}

