/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.ast;

import org.mvel.ASTNode;
import org.mvel.Accessor;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.optimizers.AccessorOptimizer;
import org.mvel.optimizers.OptimizerFactory;

public class ContextDeepPropertyNode
extends ASTNode {
    private Accessor accessor;

    public ContextDeepPropertyNode(char[] expr, int fields) {
        super(expr, fields);
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        try {
            return this.valRet(this.accessor.getValue(ctx, thisValue, factory));
        }
        catch (NullPointerException e) {
            if (this.accessor == null) {
                AccessorOptimizer aO = OptimizerFactory.getThreadAccessorOptimizer();
                this.accessor = aO.optimizeAccessor(this.name, ctx, thisValue, factory, false);
                return this.valRet(this.accessor.getValue(ctx, thisValue, factory));
            }
            throw e;
        }
        catch (ClassCastException e) {
            return this.handleDynamicDeoptimization(ctx, thisValue, factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object handleDynamicDeoptimization(Object ctx, Object thisValue, VariableResolverFactory factory) {
        ContextDeepPropertyNode contextDeepPropertyNode = this;
        synchronized (contextDeepPropertyNode) {
            this.accessor = null;
            return this.getReducedValueAccelerated(ctx, thisValue, factory);
        }
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return this.getReducedValueAccelerated(ctx, thisValue, factory);
    }
}

