/*
 * Decompiled with CFR 0.152.
 */
package org.mvel;

import java.util.Map;
import java.util.regex.Pattern;
import org.mvel.ASTNode;
import org.mvel.AbstractParser;
import org.mvel.CompileException;
import org.mvel.DataConversion;
import org.mvel.EndWithValue;
import org.mvel.ParseException;
import org.mvel.ParserContext;
import org.mvel.Soundex;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.integration.impl.ClassImportResolverFactory;
import org.mvel.integration.impl.MapVariableResolverFactory;
import org.mvel.optimizers.OptimizerFactory;
import org.mvel.util.ExecutionStack;
import org.mvel.util.ParseTools;
import org.mvel.util.PropertyTools;
import org.mvel.util.StringAppender;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MVELInterpretedRuntime
extends AbstractParser {
    private boolean returnBigDecimal = false;
    private int roundingMode = 5;
    private Object ctx;
    private VariableResolverFactory variableFactory;

    Object parse() {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.mvel.optimizers.impl.refl.ReflectiveAccessorOptimizer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        OptimizerFactory.setThreadAccessorOptimizer(clazz);
        this.debugSymbols = false;
        try {
            this.stk = new ExecutionStack();
            this.cursor = 0;
            this.parseAndExecuteInterpreted();
            if (parserContext != null && (parserContext.get() == null || ((ParserContext)parserContext.get()).getRootParser() == this)) {
                MVELInterpretedRuntime.contextControl(1, null, null);
            }
            return ParseTools.handleParserEgress(this.stk.peek(), this.returnBigDecimal);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            throw new ParseException("unexpected end of statement", this.expr, this.length);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            if (this.cursor >= this.length) {
                throw new ParseException("unexpected end of statement", this.expr, this.length);
            }
            throw e;
        }
        catch (EndWithValue end) {
            return ParseTools.handleParserEgress(end.getValue(), this.returnBigDecimal);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseAndExecuteInterpreted() {
        tk = null;
        holdOverRegister = null;
        this.lastWasIdentifier = false;
        try {
            block9: while (true) lbl-1000:
            // 12 sources

            {
                if ((tk = this.nextToken()) == null) {
                    if (holdOverRegister == null) return;
                    this.stk.push(holdOverRegister);
                    return;
                }
                holdOverRegister = null;
                if (this.lastWasIdentifier && this.lastNode.isDiscard()) {
                    this.stk.discard();
                }
                if (this.stk.size() == 0) {
                    this.stk.push(tk.getReducedValue(this.ctx, this.ctx, this.variableFactory));
                }
                if (!tk.isOperator()) continue;
                operator = tk.getOperator();
                switch (operator) {
                    case 12: {
                        if (this.stk.peek() instanceof Boolean && !((Boolean)this.stk.peek()).booleanValue()) {
                            if (this.unwindStatement()) {
                                return;
                            }
                            this.stk.clear();
                            ** break;
                        }
                        this.stk.discard();
                        ** break;
                    }
                    case 13: {
                        if (this.stk.peek() instanceof Boolean && ((Boolean)this.stk.peek()).booleanValue()) {
                            if (this.unwindStatement()) {
                                return;
                            }
                            this.stk.clear();
                            ** break;
                        }
                        this.stk.discard();
                        ** break;
                    }
                    case 28: {
                        if (((Boolean)this.stk.pop()).booleanValue()) continue block9;
                        this.stk.clear();
                        while ((tk = this.nextToken()) != null && !tk.isOperator(new Integer(29))) {
                        }
                        ** break;
                    }
                    case 29: {
                        ** break;
                    }
                    case 36: {
                        if (this.hasNoMore()) continue block9;
                        holdOverRegister = this.stk.pop();
                        this.stk.clear();
                        ** break;
                    }
                }
                this.stk.push(this.nextToken().getReducedValue(this.ctx, this.ctx, this.variableFactory), operator);
                this.reduceTrinary();
            }
        }
        catch (NullPointerException e) {
            if (tk == null) throw e;
            if (tk.isOperator() == false) throw e;
            if (this.cursor < this.length) throw e;
            throw new CompileException(new StringBuffer("incomplete statement: ").append(tk.getName()).append(" (possible use of reserved keyword as identifier: ").append(tk.getName()).append(")").toString());
        }
    }

    private boolean hasNoMore() {
        return this.cursor >= this.length;
    }

    private void reduceTrinary() {
        Object v1 = null;
        Object v2 = null;
        try {
            while (this.stk.size() > 1) {
                Integer operator = (Integer)this.stk.pop();
                v1 = this.stk.pop();
                v2 = this.stk.pop();
                switch (operator) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        this.stk.push(ParseTools.doOperations(v2, operator, v1));
                        break;
                    }
                    case 14: {
                        if (!PropertyTools.isEmpty(v2) || !PropertyTools.isEmpty(v1)) {
                            this.stk.clear();
                            this.stk.push(!PropertyTools.isEmpty(v2) ? v2 : v1);
                            return;
                        }
                        this.stk.push(null);
                        break;
                    }
                    case 15: {
                        this.stk.push(new Boolean(Pattern.compile(String.valueOf(v1)).matcher(String.valueOf(v2)).matches()));
                        break;
                    }
                    case 16: {
                        if (v1 instanceof Class) {
                            this.stk.push(new Boolean(((Class)v1).isInstance(v2)));
                            break;
                        }
                        this.stk.push(new Boolean(Thread.currentThread().getContextClassLoader().loadClass(String.valueOf(v1)).isInstance(v2)));
                        break;
                    }
                    case 35: {
                        if (v1 instanceof Class) {
                            this.stk.push(new Boolean(DataConversion.canConvert(v2.getClass(), (Class)v1)));
                            break;
                        }
                        this.stk.push(new Boolean(DataConversion.canConvert(v2.getClass(), Thread.currentThread().getContextClassLoader().loadClass(String.valueOf(v1)))));
                        break;
                    }
                    case 17: {
                        this.stk.push(new Boolean(ParseTools.containsCheck(v2, v1)));
                        break;
                    }
                    case 21: {
                        this.stk.push(new Integer(MVELInterpretedRuntime.asInt(v2) & MVELInterpretedRuntime.asInt(v1)));
                        break;
                    }
                    case 22: {
                        this.stk.push(new Integer(MVELInterpretedRuntime.asInt(v2) | MVELInterpretedRuntime.asInt(v1)));
                        break;
                    }
                    case 23: {
                        this.stk.push(new Integer(MVELInterpretedRuntime.asInt(v2) ^ MVELInterpretedRuntime.asInt(v1)));
                        break;
                    }
                    case 25: {
                        this.stk.push(new Integer(MVELInterpretedRuntime.asInt(v2) << MVELInterpretedRuntime.asInt(v1)));
                        break;
                    }
                    case 27: {
                        int iv2 = MVELInterpretedRuntime.asInt(v2);
                        if (iv2 < 0) {
                            iv2 *= -1;
                        }
                        this.stk.push(new Integer(iv2 << MVELInterpretedRuntime.asInt(v1)));
                        break;
                    }
                    case 24: {
                        this.stk.push(new Integer(MVELInterpretedRuntime.asInt(v2) >> MVELInterpretedRuntime.asInt(v1)));
                        break;
                    }
                    case 26: {
                        this.stk.push(new Integer(MVELInterpretedRuntime.asInt(v2) >>> MVELInterpretedRuntime.asInt(v1)));
                        break;
                    }
                    case 18: {
                        this.stk.push(new StringAppender(String.valueOf(v2)).append(String.valueOf(v1)).toString());
                        break;
                    }
                    case 19: {
                        this.stk.push(new Boolean(Soundex.soundex(String.valueOf(v1)).equals(Soundex.soundex(String.valueOf(v2)))));
                        break;
                    }
                    case 20: {
                        this.stk.push(new Float(PropertyTools.similarity(String.valueOf(v1), String.valueOf(v2))));
                    }
                }
            }
        }
        catch (ClassCastException e) {
            if ((this.fields & 0x1000) == 0) {
                this.fields |= 0x1000;
                ASTNode tk = this.nextToken();
                if (tk != null) {
                    this.stk.push(v1, this.nextToken(), tk.getOperator());
                    this.reduceTrinary();
                    return;
                }
            }
            throw new CompileException(new StringBuffer("syntax error or incomptable types (left=").append(v1 != null ? v1.getClass().getName() : "null").append(", right=").append(v2 != null ? v2.getClass().getName() : "null").append(")").toString(), this.expr, this.cursor, e);
        }
        catch (Exception e) {
            throw new CompileException("failed to subEval expression", e);
        }
    }

    private static int asInt(Object o) {
        return (Integer)o;
    }

    private boolean unwindStatement() {
        ASTNode tk;
        while ((tk = this.nextToken()) != null && !tk.isOperator(new Integer(36)) && !tk.isOperator(new Integer(13))) {
        }
        return tk == null;
    }

    public MVELInterpretedRuntime setExpressionArray(char[] expressionArray) {
        this.expr = expressionArray;
        this.length = expressionArray.length;
        return this;
    }

    public int getRoundingMode() {
        return this.roundingMode;
    }

    public void setRoundingMode(int roundingMode) {
        this.roundingMode = roundingMode;
    }

    public boolean isReturnBigDecimal() {
        return this.returnBigDecimal;
    }

    public void setReturnBigDecimal(boolean returnBigDecimal) {
        this.returnBigDecimal = returnBigDecimal;
    }

    MVELInterpretedRuntime(char[] expression, Object ctx, Map<String, Object> variables) {
        this.expr = expression;
        this.length = this.expr.length;
        this.ctx = ctx;
        this.variableFactory = new MapVariableResolverFactory(variables);
    }

    MVELInterpretedRuntime(char[] expression, Object ctx) {
        this.expr = expression;
        this.length = this.expr.length;
        this.ctx = ctx;
    }

    MVELInterpretedRuntime(String expression, Object ctx, Map<String, Object> variables) {
        this.setExpression(expression);
        this.ctx = ctx;
        this.variableFactory = new MapVariableResolverFactory(variables);
    }

    MVELInterpretedRuntime(String expression) {
        this.setExpression(expression);
    }

    MVELInterpretedRuntime(char[] expression) {
        this.expr = expression;
        this.length = expression.length;
    }

    MVELInterpretedRuntime(char[] expr, Object ctx, VariableResolverFactory resolverFactory) {
        this.expr = expr;
        this.length = expr.length;
        this.ctx = ctx;
        this.variableFactory = resolverFactory;
    }

    MVELInterpretedRuntime(Object ctx, Map<String, Object> variables) {
        this.ctx = ctx;
        this.variableFactory = new MapVariableResolverFactory(variables);
    }

    MVELInterpretedRuntime(String expression, Object ctx, VariableResolverFactory resolverFactory) {
        this.setExpression(expression);
        this.ctx = ctx;
        this.variableFactory = resolverFactory;
    }

    MVELInterpretedRuntime(String expression, VariableResolverFactory resolverFactory) {
        this.setExpression(expression);
        this.variableFactory = resolverFactory;
    }

    MVELInterpretedRuntime(String expression, Object ctx) {
        this.setExpression(expression);
        this.ctx = ctx;
    }

    private void chainFactory(VariableResolverFactory factory) {
        VariableResolverFactory vrf = this.variableFactory;
        while (vrf.getNextFactory() != null) {
            vrf = vrf.getNextFactory();
        }
        vrf.setNextFactory(factory);
    }

    protected boolean hasImport(String name) {
        if (this.getParserContext().hasImport(name)) {
            return true;
        }
        ClassImportResolverFactory vrf = ParseTools.findClassImportResolverFactory(this.variableFactory);
        return vrf != null && vrf.isResolveable(name);
    }

    protected Class getImport(String name) {
        if (this.getParserContext().hasImport(name)) {
            return this.getParserContext().getImport(name);
        }
        ClassImportResolverFactory vrf = ParseTools.findClassImportResolverFactory(this.variableFactory);
        return (Class)vrf.getVariableResolver(name).getValue();
    }
}

