/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.ast;

import org.mvel.ASTNode;
import org.mvel.ExecutableStatement;
import org.mvel.MVEL;
import org.mvel.ast.Assignment;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.util.ParseTools;
import org.mvel.util.PropertyTools;

public class TypedVarNode
extends ASTNode
implements Assignment {
    private String name;
    private char[] stmt;
    private transient ExecutableStatement statement;

    public TypedVarNode(char[] expr, int fields, Class type) {
        super(expr, fields);
        this.egressType = type;
        int assignStart = PropertyTools.find(expr, '=');
        if (assignStart != -1) {
            this.name = new String(expr, 0, assignStart).trim();
            ParseTools.checkNameSafety(this.name);
            this.stmt = ParseTools.subset(expr, assignStart + 1);
            if (((fields |= 0x800) & 0x10) != 0) {
                this.statement = (ExecutableStatement)ParseTools.subCompileExpression(this.stmt);
            }
        } else {
            this.name = new String(expr);
            ParseTools.checkNameSafety(this.name);
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.statement == null) {
            this.statement = (ExecutableStatement)ParseTools.subCompileExpression(this.stmt);
        }
        Object o = this.statement.getValue(ctx, thisValue, factory);
        ParseTools.finalLocalVariableFactory(factory).createVariable(this.name, o, this.egressType);
        return o;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        Object o = MVEL.eval(this.stmt, thisValue, factory);
        ParseTools.finalLocalVariableFactory(factory).createVariable(this.name, o, this.egressType);
        return o;
    }

    public String getName() {
        return this.name;
    }

    public String getAssignmentVar() {
        return this.name;
    }
}

