/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.netty.impl.handlers;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.neo4j.bolt.connection.netty.impl.spi.ResponseHandler;
import org.neo4j.bolt.connection.summary.BeginSummary;
import org.neo4j.bolt.connection.values.Value;

public class BeginTxResponseHandler
implements ResponseHandler {
    private final CompletableFuture<BeginSummary> beginTxFuture;

    public BeginTxResponseHandler(CompletableFuture<BeginSummary> beginTxFuture) {
        this.beginTxFuture = Objects.requireNonNull(beginTxFuture);
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        Value db = metadata.get("db");
        String databaseName = db != null ? db.asString() : null;
        this.beginTxFuture.complete(new BeginSummaryImpl(databaseName));
    }

    @Override
    public void onFailure(Throwable error) {
        this.beginTxFuture.completeExceptionally(error);
    }

    @Override
    public void onRecord(Value[] fields) {
        throw new UnsupportedOperationException("Transaction begin is not expected to receive records: " + Arrays.toString(fields));
    }

    private record BeginSummaryImpl(String database) implements BeginSummary
    {
        public Optional<String> databaseName() {
            return Optional.ofNullable(this.database);
        }
    }
}

