/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Collections;
import java.util.Map;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.InternalEntity;
import org.neo4j.driver.internal.value.RelationshipValue;
import org.neo4j.driver.types.Relationship;

public class InternalRelationship
extends InternalEntity
implements Relationship {
    private long start;
    private String startElementId;
    private long end;
    private String endElementId;
    private final String type;

    public InternalRelationship(long id, long start, long end, String type) {
        this(id, start, end, type, Collections.emptyMap());
    }

    public InternalRelationship(long id, long start, long end, String type, Map<String, Value> properties) {
        this(id, String.valueOf(id), start, String.valueOf(start), end, String.valueOf(end), type, properties);
    }

    public InternalRelationship(long id, String elementId, long start, String startElementId, long end, String endElementId, String type, Map<String, Value> properties) {
        super(id, elementId, properties);
        this.start = start;
        this.startElementId = startElementId;
        this.end = end;
        this.endElementId = endElementId;
        this.type = type;
    }

    @Override
    public boolean hasType(String relationshipType) {
        return this.type().equals(relationshipType);
    }

    public void setStartAndEnd(long start, String startElementId, long end, String endElementId) {
        this.start = start;
        this.startElementId = startElementId;
        this.end = end;
        this.endElementId = endElementId;
    }

    @Override
    @Deprecated
    public long startNodeId() {
        return this.start;
    }

    @Override
    public String startNodeElementId() {
        return this.startElementId;
    }

    @Override
    @Deprecated
    public long endNodeId() {
        return this.end;
    }

    @Override
    public String endNodeElementId() {
        return this.endElementId;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public Value asValue() {
        return new RelationshipValue(this);
    }

    @Override
    public String toString() {
        return String.format("relationship<%s>", this.id());
    }
}

