/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.adaptedbolt;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.neo4j.bolt.connection.AccessMode;
import org.neo4j.bolt.connection.AuthInfo;
import org.neo4j.bolt.connection.AuthTokens;
import org.neo4j.bolt.connection.BoltConnection;
import org.neo4j.bolt.connection.BoltConnectionState;
import org.neo4j.bolt.connection.BoltProtocolVersion;
import org.neo4j.bolt.connection.BoltServerAddress;
import org.neo4j.bolt.connection.DatabaseName;
import org.neo4j.bolt.connection.NotificationConfig;
import org.neo4j.bolt.connection.ResponseHandler;
import org.neo4j.bolt.connection.TelemetryApi;
import org.neo4j.bolt.connection.TransactionType;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.adaptedbolt.AdaptingDriverResponseHandler;
import org.neo4j.driver.internal.adaptedbolt.DriverBoltConnection;
import org.neo4j.driver.internal.adaptedbolt.DriverResponseHandler;
import org.neo4j.driver.internal.adaptedbolt.ErrorMapper;
import org.neo4j.driver.internal.value.BoltValueFactory;

final class AdaptingDriverBoltConnection
implements DriverBoltConnection {
    private final BoltConnection connection;
    private final ErrorMapper errorMapper;
    private final BoltValueFactory boltValueFactory;

    AdaptingDriverBoltConnection(BoltConnection connection, ErrorMapper errorMapper, BoltValueFactory boltValueFactory) {
        this.connection = Objects.requireNonNull(connection);
        this.errorMapper = Objects.requireNonNull(errorMapper);
        this.boltValueFactory = Objects.requireNonNull(boltValueFactory);
    }

    @Override
    public <T> CompletionStage<T> onLoop(Supplier<T> supplier) {
        return this.connection.onLoop(supplier);
    }

    @Override
    public CompletionStage<DriverBoltConnection> route(DatabaseName databaseName, String impersonatedUser, Set<String> bookmarks) {
        return this.connection.route(databaseName, impersonatedUser, bookmarks).exceptionally(this.errorMapper::mapAndTrow).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<DriverBoltConnection> beginTransaction(DatabaseName databaseName, AccessMode accessMode, String impersonatedUser, Set<String> bookmarks, TransactionType transactionType, Duration txTimeout, Map<String, Value> txMetadata, String txType, NotificationConfig notificationConfig) {
        return this.connection.beginTransaction(databaseName, accessMode, impersonatedUser, bookmarks, transactionType, txTimeout, this.boltValueFactory.toBoltMap(txMetadata), txType, notificationConfig).exceptionally(this.errorMapper::mapAndTrow).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<DriverBoltConnection> runInAutoCommitTransaction(DatabaseName databaseName, AccessMode accessMode, String impersonatedUser, Set<String> bookmarks, String query, Map<String, Value> parameters, Duration txTimeout, Map<String, Value> txMetadata, NotificationConfig notificationConfig) {
        return this.connection.runInAutoCommitTransaction(databaseName, accessMode, impersonatedUser, bookmarks, query, this.boltValueFactory.toBoltMap(parameters), txTimeout, this.boltValueFactory.toBoltMap(txMetadata), notificationConfig).exceptionally(this.errorMapper::mapAndTrow).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<DriverBoltConnection> run(String query, Map<String, Value> parameters) {
        return this.connection.run(query, this.boltValueFactory.toBoltMap(parameters)).exceptionally(this.errorMapper::mapAndTrow).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<DriverBoltConnection> pull(long qid, long request) {
        return this.connection.pull(qid, request).exceptionally(this.errorMapper::mapAndTrow).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<DriverBoltConnection> discard(long qid, long number) {
        return this.connection.discard(qid, number).exceptionally(this.errorMapper::mapAndTrow).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<DriverBoltConnection> commit() {
        return this.connection.commit().exceptionally(this.errorMapper::mapAndTrow).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<DriverBoltConnection> rollback() {
        return this.connection.rollback().exceptionally(this.errorMapper::mapAndTrow).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<DriverBoltConnection> reset() {
        return this.connection.reset().exceptionally(this.errorMapper::mapAndTrow).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<DriverBoltConnection> logoff() {
        return this.connection.logoff().exceptionally(this.errorMapper::mapAndTrow).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<DriverBoltConnection> logon(Map<String, Value> authMap) {
        return this.connection.logon(AuthTokens.custom(this.boltValueFactory.toBoltMap(authMap))).exceptionally(this.errorMapper::mapAndTrow).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<DriverBoltConnection> telemetry(TelemetryApi telemetryApi) {
        return this.connection.telemetry(telemetryApi).exceptionally(this.errorMapper::mapAndTrow).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<DriverBoltConnection> clear() {
        return this.connection.clear().exceptionally(this.errorMapper::mapAndTrow).thenApply(ignored -> this);
    }

    @Override
    public CompletionStage<Void> flush(DriverResponseHandler handler) {
        return this.connection.flush((ResponseHandler)new AdaptingDriverResponseHandler(handler, this.errorMapper, this.boltValueFactory)).exceptionally(this.errorMapper::mapAndTrow);
    }

    @Override
    public CompletionStage<Void> forceClose(String reason) {
        return this.connection.forceClose(reason).exceptionally(this.errorMapper::mapAndTrow);
    }

    @Override
    public CompletionStage<Void> close() {
        return this.connection.close().exceptionally(this.errorMapper::mapAndTrow);
    }

    @Override
    public BoltConnectionState state() {
        return this.connection.state();
    }

    @Override
    public CompletionStage<AuthInfo> authData() {
        return this.connection.authInfo().exceptionally(this.errorMapper::mapAndTrow);
    }

    @Override
    public String serverAgent() {
        return this.connection.serverAgent();
    }

    @Override
    public BoltServerAddress serverAddress() {
        return this.connection.serverAddress();
    }

    @Override
    public BoltProtocolVersion protocolVersion() {
        return this.connection.protocolVersion();
    }

    @Override
    public boolean telemetrySupported() {
        return this.connection.telemetrySupported();
    }

    @Override
    public boolean serverSideRoutingEnabled() {
        return this.connection.serverSideRoutingEnabled();
    }
}

