/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.util;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphalgo.impl.util.PriorityMap;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.RelationshipExpander;
import org.neo4j.graphdb.traversal.BranchOrderingPolicy;
import org.neo4j.graphdb.traversal.BranchSelector;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.graphdb.traversal.TraversalContext;
import org.neo4j.helpers.Function2;
import org.neo4j.kernel.StandardExpander;

public abstract class BestFirstSelectorFactory<P extends Comparable<P>, D>
implements BranchOrderingPolicy {
    private final Function2<Visit<P>, P, Boolean> interestPredicate;
    public static final PriorityMap.Converter<Node, TraversalBranch> CONVERTER = new PriorityMap.Converter<Node, TraversalBranch>(){

        @Override
        public Node convert(TraversalBranch source) {
            return source.endNode();
        }
    };

    public BestFirstSelectorFactory(boolean forMultiplePaths) {
        this.interestPredicate = forMultiplePaths ? new Function2<Visit<P>, P, Boolean>(){

            public Boolean apply(Visit<P> from1, P from2) {
                return from1.compareTo(from2) >= 0;
            }
        } : new Function2<Visit<P>, P, Boolean>(){

            public Boolean apply(Visit<P> from1, P from2) {
                return from1.compareTo(from2) > 0;
            }
        };
    }

    public BranchSelector create(TraversalBranch startSource, PathExpander expander) {
        return new BestFirstSelector(this, startSource, this.getStartData(), expander);
    }

    public BranchSelector create(TraversalBranch startSource, RelationshipExpander expander) {
        return new BestFirstSelector(this, startSource, this.getStartData(), StandardExpander.toPathExpander((RelationshipExpander)expander));
    }

    protected abstract P getStartData();

    protected abstract P addPriority(TraversalBranch var1, P var2, D var3);

    protected abstract D calculateValue(TraversalBranch var1);

    public static final class BestFirstSelector
    implements BranchSelector {
        private final PriorityMap<TraversalBranch, Node, P> queue = PriorityMap.withNaturalOrder(CONVERTER);
        private TraversalBranch current;
        private P currentAggregatedValue;
        private final PathExpander expander;
        private final Map<Long, Visit<P>> visits = new HashMap();
        final /* synthetic */ BestFirstSelectorFactory this$0;

        public BestFirstSelector(TraversalBranch source, P startData, PathExpander expander) {
            this.this$0 = var1_1;
            this.current = source;
            this.currentAggregatedValue = startData;
            this.expander = expander;
        }

        public TraversalBranch next(TraversalContext metadata) {
            TraversalBranch next;
            while ((next = this.current.next(this.expander, metadata)) != null) {
                boolean newStay;
                long endNodeId = next.endNode().getId();
                Visit stay = this.visits.get(endNodeId);
                if (stay != null && stay.visited) continue;
                Object cost = this.this$0.calculateValue(next);
                Object newPriority = this.this$0.addPriority(next, this.currentAggregatedValue, cost);
                boolean bl = newStay = stay == null;
                if (newStay) {
                    stay = new Visit(newPriority);
                    this.visits.put(endNodeId, stay);
                }
                if (!newStay && !((Boolean)this.this$0.interestPredicate.apply(stay, newPriority)).booleanValue()) continue;
                this.queue.put(next, newPriority);
                stay.cost = newPriority;
            }
            PriorityMap.Entry entry = this.queue.pop();
            if (entry != null) {
                this.current = entry.getEntity();
                this.currentAggregatedValue = (Comparable)entry.getPriority();
                this.visits.get(this.current.endNode().getId()).visited = true;
                return this.current;
            }
            return null;
        }
    }

    private static class Visit<P extends Comparable<P>>
    implements Comparable<P> {
        private P cost;
        private boolean visited;

        public Visit(P cost) {
            this.cost = cost;
        }

        @Override
        public int compareTo(P o) {
            return this.cost.compareTo(o);
        }
    }
}

