/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.neo4j.kernel.api.index.util.FolderLayout;

public class FailureStorage {
    public static final int MAX_FAILURE_SIZE = 16384;
    public static final String DEFAULT_FAILURE_FILE_NAME = "failure-message";
    private final FolderLayout folderLayout;
    private final String failureFileName;

    public FailureStorage(FolderLayout folderLayout, String failureFileName) {
        this.folderLayout = folderLayout;
        this.failureFileName = failureFileName;
    }

    public FailureStorage(FolderLayout folderLayout) {
        this(folderLayout, DEFAULT_FAILURE_FILE_NAME);
    }

    public synchronized void reserveForIndex(long indexId) throws IOException {
        File failureFile = this.failureFile(indexId);
        try (RandomAccessFile rwFile = new RandomAccessFile(failureFile, "rw");){
            FileChannel channel = rwFile.getChannel();
            channel.write(ByteBuffer.wrap(new byte[16384]));
            channel.force(true);
            channel.close();
        }
    }

    public synchronized void clearForIndex(long indexId) {
        this.failureFile(indexId).delete();
    }

    public synchronized String loadIndexFailure(long indexId) {
        File failureFile = this.failureFile(indexId);
        try {
            if (!failureFile.exists() || !this.isFailed(failureFile)) {
                return null;
            }
            return this.readFailure(failureFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void storeIndexFailure(long indexId, String failure) throws IOException {
        File failureFile = this.failureFile(indexId);
        try (RandomAccessFile rwFile = new RandomAccessFile(failureFile, "rw");){
            FileChannel channel = rwFile.getChannel();
            byte[] data = failure.getBytes("utf-8");
            channel.write(ByteBuffer.wrap(data, 0, Math.min(data.length, 16384)));
            channel.force(true);
            channel.close();
        }
    }

    private File failureFile(long indexId) {
        File folder = this.folderLayout.getFolder(indexId);
        folder.mkdirs();
        return new File(folder, this.failureFileName);
    }

    private String readFailure(File failureFile) throws IOException {
        try (RandomAccessFile rwFile = new RandomAccessFile(failureFile, "r");){
            FileChannel channel = rwFile.getChannel();
            byte[] data = new byte[(int)channel.size()];
            int readData = channel.read(ByteBuffer.wrap(data));
            channel.close();
            String string = readData <= 0 ? "" : new String(this.withoutZeros(data), "utf-8");
            return string;
        }
    }

    private byte[] withoutZeros(byte[] data) {
        byte[] result = new byte[this.lengthOf(data)];
        System.arraycopy(data, 0, result, 0, result.length);
        return result;
    }

    private int lengthOf(byte[] data) {
        for (int i = 0; i < data.length; ++i) {
            if (0 != data[i]) continue;
            return i;
        }
        return data.length;
    }

    private boolean isFailed(File failureFile) throws IOException {
        try (RandomAccessFile rFile = new RandomAccessFile(failureFile, "r");){
            FileChannel channel = rFile.getChannel();
            byte[] data = new byte[(int)channel.size()];
            channel.read(ByteBuffer.wrap(data));
            channel.close();
            boolean bl = !this.allZero(data);
            return bl;
        }
    }

    private boolean allZero(byte[] data) {
        for (byte b : data) {
            if (b == 0) continue;
            return false;
        }
        return true;
    }
}

