/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import java.util.Arrays;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.cache.SizeOfs;

class StringArrayProperty
extends DefinedProperty {
    private final String[] value;

    StringArrayProperty(int propertyKeyId, String[] value) {
        super(propertyKeyId);
        assert (value != null);
        this.value = value;
    }

    public String[] value() {
        return (String[])this.value.clone();
    }

    @Override
    public boolean valueEquals(Object value) {
        if (value instanceof String[]) {
            return Arrays.equals(this.value, (String[])value);
        }
        return this.valueCompare(this.value, value);
    }

    @Override
    int valueHash() {
        return Arrays.hashCode(this.value);
    }

    @Override
    boolean hasEqualValue(DefinedProperty that) {
        return Arrays.equals(this.value, ((StringArrayProperty)that).value);
    }

    @Override
    public int sizeOfObjectInBytesIncludingOverhead() {
        return SizeOfs.withObjectOverhead(SizeOfs.withReference(SizeOfs.sizeOfArray(this.value)));
    }
}

