/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.impl.cache.SizeOfs;

final class StringProperty
extends DefinedProperty {
    private final String value;

    StringProperty(int propertyKeyId, String value) {
        super(propertyKeyId);
        assert (value != null);
        this.value = value;
    }

    @Override
    public boolean valueEquals(Object other) {
        if (other instanceof String) {
            return this.value.equals(other);
        }
        return this.valueCompare(this.value, other);
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    int valueHash() {
        return this.value.hashCode();
    }

    @Override
    boolean hasEqualValue(DefinedProperty that) {
        return this.value.equals(((StringProperty)that).value);
    }

    @Override
    public int sizeOfObjectInBytesIncludingOverhead() {
        return SizeOfs.withObjectOverhead(SizeOfs.withReference(SizeOfs.sizeOf(this.value)));
    }
}

