/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Future;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.FutureAdapter;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.impl.api.index.AbstractSwallowingIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;

public class FailedIndexProxy
extends AbstractSwallowingIndexProxy {
    protected final IndexPopulator populator;
    private final String indexUserDescription;

    public FailedIndexProxy(IndexDescriptor descriptor, SchemaIndexProvider.Descriptor providerDescriptor, String indexUserDescription, IndexPopulator populator, IndexPopulationFailure populationFailure) {
        super(descriptor, providerDescriptor, populationFailure);
        this.populator = populator;
        this.indexUserDescription = indexUserDescription;
    }

    @Override
    public Future<Void> drop() throws IOException {
        this.populator.drop();
        return FutureAdapter.VOID;
    }

    @Override
    public InternalIndexState getState() {
        return InternalIndexState.FAILED;
    }

    @Override
    public boolean awaitStoreScanCompleted() throws IndexPopulationFailedKernelException {
        throw this.getPopulationFailure().asIndexPopulationFailure(this.getDescriptor(), this.indexUserDescription);
    }

    @Override
    public void activate() {
        throw new UnsupportedOperationException("Cannot activate a failed index.");
    }

    @Override
    public void validate() throws IndexPopulationFailedKernelException {
        throw this.getPopulationFailure().asIndexPopulationFailure(this.getDescriptor(), this.indexUserDescription);
    }

    @Override
    public ResourceIterator<File> snapshotFiles() {
        return IteratorUtil.emptyIterator();
    }
}

