/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.CommonAbstractStore;
import org.neo4j.kernel.impl.nioneo.store.DynamicBlockSize;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.nioneo.store.ExistingThenNewRecordAllocator;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.PropertyType;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RecordLoad;
import org.neo4j.kernel.impl.nioneo.store.RecordStore;
import org.neo4j.kernel.impl.nioneo.store.Store;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.util.StringLogger;

public abstract class AbstractDynamicStore
extends CommonAbstractStore
implements Store,
RecordStore<DynamicRecord>,
DynamicBlockSize {
    public static final byte[] NO_DATA = new byte[0];
    private final Config conf;
    private int blockSize;
    protected final DynamicRecordAllocator recordAllocator;
    public static final int BLOCK_HEADER_SIZE = 8;

    public AbstractDynamicStore(File fileName, Config conf, IdType idType, IdGeneratorFactory idGeneratorFactory, WindowPoolFactory windowPoolFactory, FileSystemAbstraction fileSystemAbstraction, StringLogger stringLogger) {
        super(fileName, conf, idType, idGeneratorFactory, windowPoolFactory, fileSystemAbstraction, stringLogger);
        this.conf = conf;
        this.recordAllocator = new ExistingThenNewRecordAllocator(this, this);
    }

    @Override
    protected int getEffectiveRecordSize() {
        return this.getBlockSize();
    }

    @Override
    public int getRecordSize() {
        return this.getBlockSize();
    }

    @Override
    public int getRecordHeaderSize() {
        return 8;
    }

    @Override
    protected void verifyFileSizeAndTruncate() throws IOException {
        int expectedVersionLength = UTF8.encode(AbstractDynamicStore.buildTypeDescriptorAndVersion(this.getTypeDescriptor())).length;
        long fileSize = this.getFileChannel().size();
        if ((fileSize - (long)expectedVersionLength) % (long)this.blockSize != 0L && !this.isReadOnly()) {
            this.setStoreNotOk(new IllegalStateException("Misaligned file size " + fileSize + " for " + this + ", expected version length " + expectedVersionLength));
        }
        if (this.getStoreOk() && !this.isReadOnly()) {
            this.getFileChannel().truncate(fileSize - (long)expectedVersionLength);
        }
    }

    @Override
    protected void readAndVerifyBlockSize() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        this.getFileChannel().position(0L);
        this.getFileChannel().read(buffer);
        buffer.flip();
        this.blockSize = buffer.getInt();
        if (this.blockSize <= 0) {
            throw new InvalidRecordException("Illegal block size: " + this.blockSize + " in " + this.getStorageFileName());
        }
    }

    @Override
    public int getBlockSize() {
        return this.blockSize;
    }

    public static int getRecordSize(int dataSize) {
        return dataSize + 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRecord(DynamicRecord record) {
        long blockId = record.getId();
        this.registerIdFromUpdateRecord(blockId);
        PersistenceWindow window = this.acquireWindow(blockId, OperationType.WRITE);
        try {
            Buffer buffer = window.getOffsettedBuffer(blockId);
            if (record.inUse()) {
                long nextBlock = record.getNextBlock();
                int highByteInFirstInteger = nextBlock == (long)Record.NO_NEXT_BLOCK.intValue() ? 0 : (int)((nextBlock & 0xF00000000L) >> 8);
                highByteInFirstInteger |= Record.IN_USE.byteValue() << 28;
                highByteInFirstInteger |= (record.isStartRecord() ? 0 : 1) << 31;
                int firstInteger = record.getLength();
                assert (firstInteger < 0xFFFFFF);
                buffer.putInt(firstInteger |= highByteInFirstInteger).putInt((int)nextBlock);
                if (!record.isLight()) {
                    buffer.put(record.getData());
                } else assert (this.getHighId() != record.getId() + 1L);
            } else {
                buffer.put(Record.NOT_IN_USE.byteValue());
                if (!this.isInRecoveryMode()) {
                    this.freeId(blockId);
                }
            }
        }
        finally {
            this.releaseWindow(window);
        }
    }

    @Override
    public void forceUpdateRecord(DynamicRecord record) {
        this.updateRecord(record);
    }

    protected Collection<DynamicRecord> allocateRecordsFromBytes(byte[] src) {
        return AbstractDynamicStore.allocateRecordsFromBytes(src, Collections.emptyList().iterator(), this.recordAllocator);
    }

    public static Collection<DynamicRecord> allocateRecordsFromBytes(byte[] src, Iterator<DynamicRecord> recordsToUseFirst, DynamicRecordAllocator dynamicRecordAllocator) {
        assert (src != null) : "Null src argument";
        LinkedList<DynamicRecord> recordList = new LinkedList<DynamicRecord>();
        DynamicRecord nextRecord = dynamicRecordAllocator.nextUsedRecordOrNew(recordsToUseFirst);
        int srcOffset = 0;
        int dataSize = dynamicRecordAllocator.dataSize();
        do {
            byte[] data;
            DynamicRecord record = nextRecord;
            record.setStartRecord(srcOffset == 0);
            if (src.length - srcOffset > dataSize) {
                data = new byte[dataSize];
                System.arraycopy(src, srcOffset, data, 0, dataSize);
                record.setData(data);
                nextRecord = dynamicRecordAllocator.nextUsedRecordOrNew(recordsToUseFirst);
                record.setNextBlock(nextRecord.getId());
                srcOffset += dataSize;
            } else {
                data = new byte[src.length - srcOffset];
                System.arraycopy(src, srcOffset, data, 0, data.length);
                record.setData(data);
                nextRecord = null;
                record.setNextBlock(Record.NO_NEXT_BLOCK.intValue());
            }
            recordList.add(record);
            assert (!record.isLight());
            assert (record.getData() != null);
        } while (nextRecord != null);
        return recordList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DynamicRecord> getLightRecords(long startBlockId) {
        LinkedList<DynamicRecord> recordList = new LinkedList<DynamicRecord>();
        long blockId = startBlockId;
        while (blockId != (long)Record.NO_NEXT_BLOCK.intValue()) {
            PersistenceWindow window = this.acquireWindow(blockId, OperationType.READ);
            try {
                DynamicRecord record = this.getRecord(blockId, window, RecordLoad.CHECK);
                recordList.add(record);
                blockId = record.getNextBlock();
            }
            finally {
                this.releaseWindow(window);
            }
        }
        return recordList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureHeavy(DynamicRecord record) {
        if (!record.isLight()) {
            return;
        }
        if (record.getLength() == 0) {
            record.setData(NO_DATA);
        }
        long blockId = record.getId();
        PersistenceWindow window = this.acquireWindow(blockId, OperationType.READ);
        try {
            Buffer buf = window.getBuffer();
            int offset = (int)(blockId - window.position()) * this.getBlockSize() + 8;
            buf.setOffset(offset);
            byte[] bytes = new byte[record.getLength()];
            buf.get(bytes);
            record.setData(bytes);
        }
        finally {
            this.releaseWindow(window);
        }
    }

    protected boolean isRecordInUse(ByteBuffer buffer) {
        return (buffer.get() & 0xFFFFFFF0) >> 4 == Record.IN_USE.byteValue();
    }

    private DynamicRecord getRecord(long blockId, PersistenceWindow window, RecordLoad load) {
        boolean readData;
        boolean inUse;
        DynamicRecord record = new DynamicRecord(blockId);
        Buffer buffer = window.getOffsettedBuffer(blockId);
        long firstInteger = buffer.getUnsignedInt();
        boolean isStartRecord = (firstInteger & Integer.MIN_VALUE) == 0L;
        long maskedInteger = firstInteger & Integer.MAX_VALUE;
        int highNibbleInMaskedInteger = (int)(maskedInteger >> 28);
        boolean bl = inUse = highNibbleInMaskedInteger == Record.IN_USE.intValue();
        if (!inUse && load != RecordLoad.FORCE) {
            throw new InvalidRecordException("DynamicRecord Not in use, blockId[" + blockId + "]");
        }
        int dataSize = this.getBlockSize() - 8;
        int nrOfBytes = (int)(firstInteger & 0xFFFFFFL);
        long nextBlock = buffer.getUnsignedInt();
        long nextModifier = (firstInteger & 0xF000000L) << 8;
        long longNextBlock = this.longFromIntAndMod(nextBlock, nextModifier);
        boolean bl2 = readData = load != RecordLoad.CHECK;
        if (longNextBlock != (long)Record.NO_NEXT_BLOCK.intValue() && nrOfBytes < dataSize || nrOfBytes > dataSize) {
            readData = false;
            if (load != RecordLoad.FORCE) {
                throw new InvalidRecordException("Next block set[" + nextBlock + "] current block illegal size[" + nrOfBytes + "/" + dataSize + "]");
            }
        }
        record.setInUse(inUse);
        record.setStartRecord(isStartRecord);
        record.setLength(nrOfBytes);
        record.setNextBlock(longNextBlock);
        if (readData) {
            byte[] byteArrayElement = new byte[nrOfBytes];
            buffer.get(byteArrayElement);
            record.setData(byteArrayElement);
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DynamicRecord getRecord(long id) {
        PersistenceWindow window = this.acquireWindow(id, OperationType.READ);
        try {
            DynamicRecord dynamicRecord = this.getRecord(id, window, RecordLoad.NORMAL);
            return dynamicRecord;
        }
        finally {
            this.releaseWindow(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DynamicRecord forceGetRecord(long id) {
        PersistenceWindow window;
        try {
            window = this.acquireWindow(id, OperationType.READ);
        }
        catch (InvalidRecordException e) {
            return new DynamicRecord(id);
        }
        try {
            DynamicRecord dynamicRecord = this.getRecord(id, window, RecordLoad.FORCE);
            return dynamicRecord;
        }
        finally {
            this.releaseWindow(window);
        }
    }

    @Override
    public DynamicRecord forceGetRaw(DynamicRecord record) {
        return record;
    }

    @Override
    public DynamicRecord forceGetRaw(long id) {
        return this.forceGetRecord(id);
    }

    @Override
    public Collection<DynamicRecord> getRecords(long startBlockId) {
        return this.getRecords(startBlockId, RecordLoad.NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DynamicRecord> getRecords(long startBlockId, RecordLoad loadFlag) {
        LinkedList<DynamicRecord> recordList = new LinkedList<DynamicRecord>();
        long blockId = startBlockId;
        while (blockId != (long)Record.NO_NEXT_BLOCK.intValue()) {
            PersistenceWindow window = this.acquireWindow(blockId, OperationType.READ);
            try {
                DynamicRecord record = this.getRecord(blockId, window, loadFlag);
                if (!record.inUse()) {
                    LinkedList<DynamicRecord> linkedList = recordList;
                    return linkedList;
                }
                recordList.add(record);
                blockId = record.getNextBlock();
            }
            finally {
                this.releaseWindow(window);
            }
        }
        return recordList;
    }

    @Override
    public Long getNextRecordReference(DynamicRecord record) {
        long nextId = record.getNextBlock();
        return Record.NO_NEXT_BLOCK.is(nextId) ? null : Long.valueOf(nextId);
    }

    public static ByteBuffer concatData(Collection<DynamicRecord> records, byte[] target) {
        int totalLength = 0;
        for (DynamicRecord record : records) {
            totalLength += record.getLength();
        }
        if (target.length < totalLength) {
            target = new byte[totalLength];
        }
        ByteBuffer buffer = ByteBuffer.wrap(target, 0, totalLength);
        for (DynamicRecord record : records) {
            buffer.put(record.getData());
        }
        buffer.position(0);
        return buffer;
    }

    private long findHighIdBackwards() throws IOException {
        StoreChannel fileChannel = this.getFileChannel();
        int recordSize = this.getBlockSize();
        long fileSize = fileChannel.size();
        long highId = fileSize / (long)recordSize;
        ByteBuffer byteBuffer = ByteBuffer.allocate(1);
        for (long i = highId; i > 0L; --i) {
            fileChannel.position(i * (long)recordSize);
            if (fileChannel.read(byteBuffer) <= 0) continue;
            byteBuffer.flip();
            boolean isInUse = this.isRecordInUse(byteBuffer);
            byteBuffer.clear();
            if (!isInUse) continue;
            return i;
        }
        return 0L;
    }

    @Override
    protected void rebuildIdGenerator() {
        if (this.getBlockSize() <= 0) {
            throw new InvalidRecordException("Illegal blockSize: " + this.getBlockSize());
        }
        this.stringLogger.debug("Rebuilding id generator for[" + this.getStorageFileName() + "] ...");
        this.closeIdGenerator();
        if (this.fileSystemAbstraction.fileExists(new File(this.getStorageFileName().getPath() + ".id"))) {
            boolean success = this.fileSystemAbstraction.deleteFile(new File(this.getStorageFileName().getPath() + ".id"));
            assert (success);
        }
        this.createIdGenerator(new File(this.getStorageFileName().getPath() + ".id"));
        this.openIdGenerator();
        this.setHighId(1L);
        StoreChannel fileChannel = this.getFileChannel();
        long highId = 0L;
        long defraggedCount = 0L;
        try {
            long fileSize = fileChannel.size();
            boolean fullRebuild = true;
            if (this.conf.get(Configuration.rebuild_idgenerators_fast).booleanValue()) {
                fullRebuild = false;
                highId = this.findHighIdBackwards();
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[1]);
            LinkedList<Long> freeIdList = new LinkedList<Long>();
            if (fullRebuild) {
                long i = 1L;
                while (i * (long)this.getBlockSize() < fileSize) {
                    fileChannel.position(i * (long)this.getBlockSize());
                    byteBuffer.clear();
                    fileChannel.read(byteBuffer);
                    byteBuffer.flip();
                    if (!this.isRecordInUse(byteBuffer)) {
                        freeIdList.add(i);
                    } else {
                        highId = i;
                        this.setHighId(highId + 1L);
                        while (!freeIdList.isEmpty()) {
                            this.freeId((Long)freeIdList.removeFirst());
                            ++defraggedCount;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to rebuild id generator " + this.getStorageFileName(), e);
        }
        this.setHighId(highId + 1L);
        this.stringLogger.debug("[" + this.getStorageFileName() + "] high id=" + this.getHighId() + " (defragged=" + defraggedCount + ")");
        this.stringLogger.logMessage(this.getStorageFileName() + " rebuild id generator, highId=" + this.getHighId() + " defragged count=" + defraggedCount, true);
        this.closeIdGenerator();
        this.openIdGenerator();
    }

    @Override
    protected long figureOutHighestIdInUse() {
        try {
            return this.getFileChannel().size() / (long)this.getBlockSize();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        return super.toString() + "[fileName:" + this.storageFileName.getName() + ", blockSize:" + (this.getRecordSize() - this.getRecordHeaderSize()) + "]";
    }

    public Pair<byte[], byte[]> readFullByteArray(Iterable<DynamicRecord> records, PropertyType propertyType) {
        for (DynamicRecord record : records) {
            this.ensureHeavy(record);
        }
        return AbstractDynamicStore.readFullByteArrayFromHeavyRecords(records, propertyType);
    }

    public static Pair<byte[], byte[]> readFullByteArrayFromHeavyRecords(Iterable<DynamicRecord> records, PropertyType propertyType) {
        int offset;
        byte[] header = null;
        LinkedList<byte[]> byteList = new LinkedList<byte[]>();
        int totalSize = 0;
        int i = 0;
        for (DynamicRecord record : records) {
            offset = 0;
            if (i++ == 0) {
                header = propertyType.readDynamicRecordHeader(record.getData());
                offset = header.length;
            }
            byteList.add(record.getData());
            totalSize += record.getData().length - offset;
        }
        byte[] bArray = new byte[totalSize];
        assert (header != null) : "header should be non-null since records should not be empty";
        int sourceOffset = header.length;
        offset = 0;
        for (byte[] currentArray : byteList) {
            System.arraycopy(currentArray, sourceOffset, bArray, offset, currentArray.length - sourceOffset);
            offset += currentArray.length - sourceOffset;
            sourceOffset = 0;
        }
        return Pair.of(header, bArray);
    }

    public static abstract class Configuration
    extends CommonAbstractStore.Configuration {
        public static final Setting<Boolean> rebuild_idgenerators_fast = GraphDatabaseSettings.rebuild_idgenerators_fast;
    }
}

