/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.logging;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.ConsoleLogger;

public class BufferingConsoleLogger
extends ConsoleLogger {
    private final List<LogMessage> buffer = new ArrayList<LogMessage>();

    public BufferingConsoleLogger() {
        super(StringLogger.DEV_NULL);
    }

    @Override
    public void log(String message) {
        this.buffer.add(new LogMessage(Level.LOG, message, null));
    }

    @Override
    public void warn(String message, Throwable warning) {
        this.buffer.add(new LogMessage(Level.WARN, message, warning));
    }

    @Override
    public void error(String message, Throwable error) {
        this.buffer.add(new LogMessage(Level.ERROR, message, error));
    }

    public void replayInto(ConsoleLogger target) {
        block5: for (LogMessage item : this.buffer) {
            switch (item.level) {
                case LOG: {
                    target.log(item.message);
                    continue block5;
                }
                case WARN: {
                    if (item.throwable != null) {
                        target.warn(item.message, item.throwable);
                        continue block5;
                    }
                    target.warn(item.message);
                    continue block5;
                }
                case ERROR: {
                    if (item.throwable != null) {
                        target.error(item.message, item.throwable);
                        continue block5;
                    }
                    target.error(item.message);
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Unknown level " + (Object)((Object)item.level));
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (LogMessage message : this.buffer) {
            builder.append(message.message).append(message.throwable != null ? message.throwable.getMessage() : "").append(String.format("%n", new Object[0]));
        }
        return builder.toString();
    }

    private static class LogMessage {
        private final Level level;
        private final String message;
        private final Throwable throwable;

        public LogMessage(Level level, String message, Throwable throwable) {
            this.level = level;
            this.message = message;
            this.throwable = throwable;
        }
    }

    private static enum Level {
        LOG,
        WARN,
        ERROR;

    }
}

