/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.Predicates;
import org.neo4j.kernel.configuration.ConfigurationChange;
import org.neo4j.kernel.configuration.ConfigurationChangeListener;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class RestartOnChange
implements ConfigurationChangeListener {
    private final org.neo4j.function.Predicate<String> restartSpecification;
    private final Lifecycle life;

    public RestartOnChange(final String configurationNamePrefix, Lifecycle life) {
        this(new org.neo4j.function.Predicate<String>(){

            public boolean test(String item) {
                return item.startsWith(configurationNamePrefix);
            }
        }, life);
    }

    @Deprecated
    public RestartOnChange(Predicate<String> restartSpecification, Lifecycle life) {
        this(Predicates.upgrade(restartSpecification), life);
    }

    public RestartOnChange(org.neo4j.function.Predicate<String> restartSpecification, Lifecycle life) {
        this.restartSpecification = restartSpecification;
        this.life = life;
    }

    @Override
    public void notifyConfigurationChanges(Iterable<ConfigurationChange> change) {
        boolean restart = false;
        for (ConfigurationChange configurationChange : change) {
            restart |= this.restartSpecification.test((Object)configurationChange.getName());
        }
        if (restart) {
            try {
                this.life.stop();
                this.life.start();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
}

