/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.collection.pool.Pool;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.KeyReadTokenNameLookup;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.constraints.NodePropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.cursor.DegreeItem;
import org.neo4j.kernel.api.cursor.NodeItem;
import org.neo4j.kernel.api.exceptions.ConstraintViolationTransactionFailureException;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationKernelException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.DuplicateSchemaRuleException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.procedures.ProcedureDescriptor;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.txstate.LegacyIndexTransactionState;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.api.txstate.TxStateVisitor;
import org.neo4j.kernel.impl.api.CachingLegacyIndexTransactionState;
import org.neo4j.kernel.impl.api.CountsRecordState;
import org.neo4j.kernel.impl.api.IndexReaderFactory;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.RelationshipDataExtractor;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionHeaderInformation;
import org.neo4j.kernel.impl.api.TransactionHooks;
import org.neo4j.kernel.impl.api.UpdateableSchemaState;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.SchemaIndexProviderMap;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.api.store.ProcedureCache;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.api.store.StoreStatement;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.RelationshipPropertyExistenceConstraintRule;
import org.neo4j.kernel.impl.store.record.UniquePropertyConstraintRule;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.state.NeoStoreTransactionContext;
import org.neo4j.kernel.impl.transaction.state.TransactionRecordState;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionTracer;
import org.neo4j.kernel.impl.util.collection.ArrayCollection;

public class KernelTransactionImplementation
implements KernelTransaction,
TxStateHolder {
    private final SchemaWriteGuard schemaWriteGuard;
    private final IndexingService indexService;
    private final TransactionHooks hooks;
    private final LabelScanStore labelScanStore;
    private final SchemaStorage schemaStorage;
    private final ConstraintIndexCreator constraintIndexCreator;
    private final SchemaIndexProviderMap providerMap;
    private final UpdateableSchemaState schemaState;
    private final StatementOperationParts operations;
    private final Pool<KernelTransactionImplementation> pool;
    private final ConstraintSemantics constraintSemantics;
    private final TransactionRecordState recordState;
    private final CountsRecordState counts = new CountsRecordState();
    private final TransactionHeaderInformationFactory headerInformationFactory;
    private final TransactionCommitProcess commitProcess;
    private final TransactionMonitor transactionMonitor;
    private final StoreReadLayer storeLayer;
    private final ProcedureCache procedureCache;
    private final Clock clock;
    private final TransactionToRecordStateVisitor txStateToRecordStateVisitor = new TransactionToRecordStateVisitor();
    private final Collection<Command> extractedCommands = new ArrayCollection<Command>(32);
    private final Locks locksManager;
    private final boolean txTerminationAwareLocks;
    private TransactionState txState;
    private LegacyIndexTransactionState legacyIndexTransactionState;
    private TransactionType transactionType = TransactionType.ANY;
    private TransactionHooks.TransactionHooksState hooksState;
    private boolean beforeHookInvoked;
    private Locks.Client locks;
    private StoreStatement storeStatement;
    private boolean closing;
    private boolean closed;
    private boolean failure;
    private boolean success;
    private volatile Status terminationReason;
    private long startTimeMillis;
    private long lastTransactionIdWhenStarted;
    private long lastTransactionTimestampWhenStarted;
    private KernelStatement currentStatement;
    private final TransactionTracer tracer;
    private TransactionEvent transactionEvent;
    private KernelTransaction.CloseListener closeListener;
    private final NeoStoreTransactionContext context;
    private volatile int reuseCount;
    private final Lock terminationReleaseLock = new ReentrantLock();

    public KernelTransactionImplementation(StatementOperationParts operations, SchemaWriteGuard schemaWriteGuard, LabelScanStore labelScanStore, IndexingService indexService, UpdateableSchemaState schemaState, TransactionRecordState recordState, SchemaIndexProviderMap providerMap, NeoStores neoStores, Locks locks, TransactionHooks hooks, ConstraintIndexCreator constraintIndexCreator, TransactionHeaderInformationFactory headerInformationFactory, TransactionCommitProcess commitProcess, TransactionMonitor transactionMonitor, StoreReadLayer storeLayer, LegacyIndexTransactionState legacyIndexTransactionState, Pool<KernelTransactionImplementation> pool, ConstraintSemantics constraintSemantics, Clock clock, TransactionTracer tracer, ProcedureCache procedureCache, NeoStoreTransactionContext context, boolean txTerminationAwareLocks) {
        this.operations = operations;
        this.schemaWriteGuard = schemaWriteGuard;
        this.labelScanStore = labelScanStore;
        this.indexService = indexService;
        this.recordState = recordState;
        this.providerMap = providerMap;
        this.schemaState = schemaState;
        this.locksManager = locks;
        this.txTerminationAwareLocks = txTerminationAwareLocks;
        this.hooks = hooks;
        this.constraintIndexCreator = constraintIndexCreator;
        this.headerInformationFactory = headerInformationFactory;
        this.commitProcess = commitProcess;
        this.transactionMonitor = transactionMonitor;
        this.storeLayer = storeLayer;
        this.procedureCache = procedureCache;
        this.context = context;
        this.legacyIndexTransactionState = new CachingLegacyIndexTransactionState(legacyIndexTransactionState);
        this.pool = pool;
        this.constraintSemantics = constraintSemantics;
        this.clock = clock;
        this.schemaStorage = new SchemaStorage(neoStores.getSchemaStore());
        this.tracer = tracer;
    }

    public KernelTransactionImplementation initialize(long lastCommittedTx, long lastTimeStamp) {
        this.locks = this.locksManager.newClient();
        this.terminationReason = null;
        this.success = false;
        this.failure = false;
        this.closed = false;
        this.closing = false;
        this.transactionType = TransactionType.ANY;
        this.beforeHookInvoked = false;
        this.recordState.initialize(lastCommittedTx);
        this.startTimeMillis = this.clock.currentTimeMillis();
        this.lastTransactionIdWhenStarted = lastCommittedTx;
        this.lastTransactionTimestampWhenStarted = lastTimeStamp;
        this.transactionEvent = this.tracer.beginTransaction();
        assert (this.transactionEvent != null) : "transactionEvent was null!";
        this.storeStatement = this.storeLayer.acquireStatement();
        this.closeListener = null;
        return this;
    }

    int getReuseCount() {
        return this.reuseCount;
    }

    @Override
    public void success() {
        this.success = true;
    }

    @Override
    public void failure() {
        this.failure = true;
    }

    @Override
    public Status getReasonIfTerminated() {
        return this.terminationReason;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markForTermination(Status reason) {
        if (!this.canBeTerminated()) {
            return;
        }
        int initialReuseCount = this.reuseCount;
        this.terminationReleaseLock.lock();
        try {
            boolean stillSameTransaction;
            boolean bl = stillSameTransaction = initialReuseCount == this.reuseCount;
            if (stillSameTransaction && this.canBeTerminated()) {
                this.failure = true;
                this.terminationReason = reason;
                if (this.txTerminationAwareLocks && this.locks != null) {
                    this.locks.stop();
                }
                this.transactionMonitor.transactionTerminated();
            }
        }
        finally {
            this.terminationReleaseLock.unlock();
        }
    }

    @Override
    public boolean isOpen() {
        return !this.closed && !this.closing;
    }

    @Override
    public KernelStatement acquireStatement() {
        this.assertTransactionOpen();
        if (this.currentStatement == null) {
            this.currentStatement = new KernelStatement(this, new IndexReaderFactory.Caching(this.indexService), this.labelScanStore, this, this.locks, this.operations, this.storeStatement);
        }
        this.currentStatement.acquire();
        return this.currentStatement;
    }

    public void releaseStatement(Statement statement) {
        assert (this.currentStatement == statement);
        this.currentStatement = null;
    }

    public void upgradeToDataTransaction() throws InvalidTransactionTypeKernelException {
        this.transactionType = this.transactionType.upgradeToDataTransaction();
    }

    public void upgradeToSchemaTransaction() throws InvalidTransactionTypeKernelException {
        this.doUpgradeToSchemaTransaction();
        this.transactionType = this.transactionType.upgradeToSchemaTransaction();
    }

    public void doUpgradeToSchemaTransaction() throws InvalidTransactionTypeKernelException {
        this.schemaWriteGuard.assertSchemaWritesAllowed();
    }

    private void dropCreatedConstraintIndexes() throws TransactionFailureException {
        if (this.hasTxStateWithChanges()) {
            for (IndexDescriptor createdConstraintIndex : this.txState().constraintIndexesCreatedInTx()) {
                try {
                    this.constraintIndexCreator.dropUniquenessConstraintIndex(createdConstraintIndex);
                }
                catch (DropIndexFailureException e) {
                    throw new IllegalStateException("Constraint index that was created in a transaction should be possible to drop during rollback of that transaction.", e);
                }
            }
        }
    }

    @Override
    public TransactionState txState() {
        if (this.txState == null) {
            this.txState = new TxState();
        }
        return this.txState;
    }

    @Override
    public LegacyIndexTransactionState legacyIndexTxState() {
        return this.legacyIndexTransactionState;
    }

    @Override
    public boolean hasTxStateWithChanges() {
        return this.txState != null && this.txState.hasChanges();
    }

    private void closeTransaction() {
        this.assertTransactionOpen();
        this.closed = true;
        this.closeCurrentStatementIfAny();
        if (this.closeListener != null) {
            this.closeListener.notify(this.success);
        }
    }

    private void closeCurrentStatementIfAny() {
        if (this.currentStatement != null) {
            this.currentStatement.forceClose();
            this.currentStatement = null;
        }
    }

    private void assertTransactionNotClosing() {
        if (this.closing) {
            throw new IllegalStateException("This transaction is already being closed.");
        }
    }

    private void prepareRecordChangesFromTransactionState() throws ConstraintValidationKernelException, CreateConstraintFailureException {
        if (this.hasTxStateWithChanges()) {
            this.txState().accept(this.txStateVisitor());
            this.txStateToRecordStateVisitor.done();
        }
    }

    private TxStateVisitor txStateVisitor() {
        return this.constraintSemantics.decorateTxStateVisitor(this.operations, this.storeStatement, this.storeLayer, this, this.txStateToRecordStateVisitor);
    }

    private void assertTransactionOpen() {
        if (this.closed) {
            throw new IllegalStateException("This transaction has already been completed.");
        }
    }

    private boolean hasChanges() {
        return this.hasTxStateWithChanges() || this.recordState.hasChanges() || this.legacyIndexTransactionState.hasChanges() || this.counts.hasChanges();
    }

    public TransactionRecordState getTransactionRecordState() {
        return this.recordState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws TransactionFailureException {
        block9: {
            this.assertTransactionOpen();
            this.assertTransactionNotClosing();
            this.closeCurrentStatementIfAny();
            this.closing = true;
            try {
                if (this.failure || !this.success || this.isTerminated()) {
                    this.rollback();
                    this.failOnNonExplicitRollbackIfNeeded();
                    break block9;
                }
                this.commit();
            }
            catch (Throwable throwable) {
                try {
                    this.closed = true;
                    this.closing = false;
                    this.transactionEvent.setSuccess(this.success);
                    this.transactionEvent.setFailure(this.failure);
                    this.transactionEvent.setTransactionType(this.transactionType.name());
                    this.transactionEvent.setReadOnly(this.txState == null || !this.txState.hasChanges());
                    this.transactionEvent.close();
                    this.transactionEvent = null;
                    this.legacyIndexTransactionState.clear();
                    this.recordState.clear();
                    this.counts.clear();
                    this.txState = null;
                    this.hooksState = null;
                    this.closeListener = null;
                }
                finally {
                    this.release();
                }
                throw throwable;
            }
        }
        try {
            this.closed = true;
            this.closing = false;
            this.transactionEvent.setSuccess(this.success);
            this.transactionEvent.setFailure(this.failure);
            this.transactionEvent.setTransactionType(this.transactionType.name());
            this.transactionEvent.setReadOnly(this.txState == null || !this.txState.hasChanges());
            this.transactionEvent.close();
            this.transactionEvent = null;
            this.legacyIndexTransactionState.clear();
            this.recordState.clear();
            this.counts.clear();
            this.txState = null;
            this.hooksState = null;
            this.closeListener = null;
        }
        finally {
            this.release();
        }
    }

    private void failOnNonExplicitRollbackIfNeeded() throws TransactionFailureException {
        if (this.success && this.isTerminated()) {
            throw new TransactionTerminatedException(this.terminationReason);
        }
        if (this.success) {
            throw new TransactionFailureException((Status)Status.Transaction.MarkedAsFailed, "Transaction rolled back even if marked as successful", new Object[0]);
        }
    }

    protected void dispose() {
        if (this.locks != null) {
            this.locks.close();
        }
        this.locks = null;
        this.transactionType = null;
        this.hooksState = null;
        this.txState = null;
        this.legacyIndexTransactionState = null;
        if (this.storeStatement != null) {
            this.storeStatement.close();
            this.storeStatement = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit() throws TransactionFailureException {
        boolean success = false;
        try (CommitEvent commitEvent = this.transactionEvent.beginCommitEvent();){
            if (this.hasTxStateWithChanges()) {
                if (this.txState.hasDataChanges()) {
                    try {
                        this.hooksState = this.hooks.beforeCommit(this.txState, this, this.storeLayer);
                        if (this.hooksState != null && this.hooksState.failed()) {
                            throw new TransactionFailureException((Status)Status.Transaction.HookFailed, (Throwable)this.hooksState.failure(), "", new Object[0]);
                        }
                    }
                    finally {
                        this.beforeHookInvoked = true;
                    }
                }
                this.context.init(this.locks);
                this.prepareRecordChangesFromTransactionState();
            }
            if (this.hasChanges()) {
                try (LockGroup lockGroup = new LockGroup();){
                    this.extractedCommands.clear();
                    this.recordState.extractCommands(this.extractedCommands);
                    this.legacyIndexTransactionState.extractCommands(this.extractedCommands);
                    this.counts.extractCommands(this.extractedCommands);
                    if (!this.extractedCommands.isEmpty()) {
                        PhysicalTransactionRepresentation transactionRepresentation = new PhysicalTransactionRepresentation(this.extractedCommands);
                        TransactionHeaderInformation headerInformation = this.headerInformationFactory.create();
                        transactionRepresentation.setHeader(headerInformation.getAdditionalHeader(), headerInformation.getMasterId(), headerInformation.getAuthorId(), this.startTimeMillis, this.lastTransactionIdWhenStarted, this.clock.currentTimeMillis(), this.locks.getLockSessionId());
                        this.commitProcess.commit(transactionRepresentation, lockGroup, commitEvent, TransactionApplicationMode.INTERNAL);
                    }
                }
            }
            success = true;
        }
        catch (ConstraintValidationKernelException | CreateConstraintFailureException e) {
            throw new ConstraintViolationTransactionFailureException(e.getUserMessage(new KeyReadTokenNameLookup(this.operations.keyReadOperations())), e);
        }
        finally {
            if (!success) {
                this.rollback();
            } else {
                this.afterCommit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollback() throws TransactionFailureException {
        block7: {
            try {
                try {
                    this.dropCreatedConstraintIndexes();
                }
                catch (IllegalStateException | SecurityException e) {
                    throw new TransactionFailureException((Status)Status.Transaction.CouldNotRollback, (Throwable)e, "Could not drop created constraint indexes", new Object[0]);
                }
                if (this.txState == null) break block7;
                try {
                    this.txState.accept(new TxStateVisitor.Adapter(){

                        @Override
                        public void visitCreatedNode(long id) {
                            KernelTransactionImplementation.this.storeLayer.releaseNode(id);
                        }

                        @Override
                        public void visitCreatedRelationship(long id, int type, long startNode, long endNode) {
                            KernelTransactionImplementation.this.storeLayer.releaseRelationship(id);
                        }
                    });
                }
                catch (ConstraintValidationKernelException | CreateConstraintFailureException e) {
                    throw new IllegalStateException("Releasing locks during rollback should perform no constraints checking.", e);
                }
            }
            finally {
                this.afterRollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterCommit() {
        try {
            this.closeTransaction();
            if (this.beforeHookInvoked) {
                this.hooks.afterCommit(this.txState, this, this.hooksState);
            }
        }
        finally {
            this.transactionMonitor.transactionFinished(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterRollback() {
        try {
            this.closeTransaction();
            if (this.beforeHookInvoked) {
                this.hooks.afterRollback(this.txState, this, this.hooksState);
            }
        }
        finally {
            this.transactionMonitor.transactionFinished(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release() {
        this.terminationReleaseLock.lock();
        try {
            this.locks.close();
            this.locks = null;
            this.terminationReason = null;
            this.pool.release((Object)this);
            if (this.storeStatement != null) {
                this.storeStatement.close();
                this.storeStatement = null;
            }
        }
        finally {
            ++this.reuseCount;
            this.terminationReleaseLock.unlock();
        }
    }

    private boolean canBeTerminated() {
        return !this.closed && !this.isTerminated();
    }

    private boolean isTerminated() {
        return this.terminationReason != null;
    }

    @Override
    public long lastTransactionTimestampWhenStarted() {
        return this.lastTransactionTimestampWhenStarted;
    }

    private void updateRelationshipsCountsFromDegrees(int type, int label, long outgoing, long incoming) {
        this.counts.incrementRelationshipCount(label, -1, -1, outgoing);
        this.counts.incrementRelationshipCount(-1, -1, label, incoming);
        this.counts.incrementRelationshipCount(label, type, -1, outgoing);
        this.counts.incrementRelationshipCount(-1, type, label, incoming);
    }

    private void updateRelationshipCount(long startNode, int type, long endNode, int delta) throws EntityNotFoundException {
        this.updateRelationshipsCountsFromDegrees(type, -1, delta, 0L);
        PrimitiveIntIterator startLabels = this.labelsOf(startNode);
        while (startLabels.hasNext()) {
            this.updateRelationshipsCountsFromDegrees(type, startLabels.next(), delta, 0L);
        }
        PrimitiveIntIterator endLabels = this.labelsOf(endNode);
        while (endLabels.hasNext()) {
            this.updateRelationshipsCountsFromDegrees(type, endLabels.next(), 0L, delta);
        }
    }

    /*
     * Exception decompiling
     */
    private PrimitiveIntIterator labelsOf(long nodeId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void registerCloseListener(KernelTransaction.CloseListener listener) {
        assert (this.closeListener == null);
        this.closeListener = listener;
    }

    public String toString() {
        return "KernelTransaction[" + this.locks.getLockSessionId() + "]";
    }

    private class TransactionToRecordStateVisitor
    extends TxStateVisitor.Adapter {
        private final RelationshipDataExtractor edge = new RelationshipDataExtractor();
        private boolean clearState;

        private TransactionToRecordStateVisitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void done() {
            try {
                if (this.clearState) {
                    KernelTransactionImplementation.this.schemaState.clear();
                }
            }
            finally {
                this.clearState = false;
            }
        }

        @Override
        public void visitCreatedNode(long id) {
            KernelTransactionImplementation.this.recordState.nodeCreate(id);
            KernelTransactionImplementation.this.counts.incrementNodeCount(-1, 1L);
        }

        @Override
        public void visitDeletedNode(long id) {
            block39: {
                try (StoreStatement statement = KernelTransactionImplementation.this.storeLayer.acquireStatement();){
                    KernelTransactionImplementation.this.counts.incrementNodeCount(-1, -1L);
                    try (Cursor<NodeItem> node = statement.acquireSingleNodeCursor(id);){
                        int[] removed;
                        PrimitiveIntIterator labels;
                        if (!node.next() || !(labels = ((NodeItem)node.get()).getLabels()).hasNext()) break block39;
                        for (int label : removed = PrimitiveIntCollections.asArray((PrimitiveIntIterator)labels)) {
                            KernelTransactionImplementation.this.counts.incrementNodeCount(label, -1L);
                        }
                        try (Cursor<DegreeItem> degrees = ((NodeItem)node.get()).degrees();){
                            while (degrees.next()) {
                                DegreeItem degree = (DegreeItem)degrees.get();
                                for (int label : removed) {
                                    KernelTransactionImplementation.this.updateRelationshipsCountsFromDegrees(degree.type(), label, -degree.outgoing(), -degree.incoming());
                                }
                            }
                        }
                    }
                }
            }
            KernelTransactionImplementation.this.recordState.nodeDelete(id);
        }

        @Override
        public void visitCreatedRelationship(long id, int type, long startNode, long endNode) {
            try {
                KernelTransactionImplementation.this.updateRelationshipCount(startNode, type, endNode, 1);
            }
            catch (EntityNotFoundException e) {
                throw new IllegalStateException("Nodes with added relationships should exist.", e);
            }
            KernelTransactionImplementation.this.recordState.relCreate(id, type, startNode, endNode);
        }

        @Override
        public void visitDeletedRelationship(long id) {
            try {
                KernelTransactionImplementation.this.storeLayer.relationshipVisit(id, this.edge);
                KernelTransactionImplementation.this.updateRelationshipCount(this.edge.startNode(), this.edge.type(), this.edge.endNode(), -1);
            }
            catch (EntityNotFoundException e) {
                throw new IllegalStateException("Relationship being deleted should exist along with its nodes.", e);
            }
            KernelTransactionImplementation.this.recordState.relDelete(id);
        }

        @Override
        public void visitNodePropertyChanges(long id, Iterator<DefinedProperty> added, Iterator<DefinedProperty> changed, Iterator<Integer> removed) {
            DefinedProperty prop;
            while (removed.hasNext()) {
                KernelTransactionImplementation.this.recordState.nodeRemoveProperty(id, removed.next());
            }
            while (changed.hasNext()) {
                prop = changed.next();
                KernelTransactionImplementation.this.recordState.nodeChangeProperty(id, prop.propertyKeyId(), prop.value());
            }
            while (added.hasNext()) {
                prop = added.next();
                KernelTransactionImplementation.this.recordState.nodeAddProperty(id, prop.propertyKeyId(), prop.value());
            }
        }

        @Override
        public void visitRelPropertyChanges(long id, Iterator<DefinedProperty> added, Iterator<DefinedProperty> changed, Iterator<Integer> removed) {
            DefinedProperty prop;
            while (removed.hasNext()) {
                KernelTransactionImplementation.this.recordState.relRemoveProperty(id, removed.next());
            }
            while (changed.hasNext()) {
                prop = changed.next();
                KernelTransactionImplementation.this.recordState.relChangeProperty(id, prop.propertyKeyId(), prop.value());
            }
            while (added.hasNext()) {
                prop = added.next();
                KernelTransactionImplementation.this.recordState.relAddProperty(id, prop.propertyKeyId(), prop.value());
            }
        }

        @Override
        public void visitGraphPropertyChanges(Iterator<DefinedProperty> added, Iterator<DefinedProperty> changed, Iterator<Integer> removed) {
            DefinedProperty prop;
            while (removed.hasNext()) {
                KernelTransactionImplementation.this.recordState.graphRemoveProperty(removed.next());
            }
            while (changed.hasNext()) {
                prop = changed.next();
                KernelTransactionImplementation.this.recordState.graphChangeProperty(prop.propertyKeyId(), prop.value());
            }
            while (added.hasNext()) {
                prop = added.next();
                KernelTransactionImplementation.this.recordState.graphAddProperty(prop.propertyKeyId(), prop.value());
            }
        }

        @Override
        public void visitNodeLabelChanges(long id, Set<Integer> added, Set<Integer> removed) {
            block43: {
                try (StoreStatement statement = KernelTransactionImplementation.this.storeLayer.acquireStatement();){
                    if (added.isEmpty() && removed.isEmpty()) break block43;
                    for (Integer label : added) {
                        KernelTransactionImplementation.this.counts.incrementNodeCount(label, 1L);
                    }
                    for (Integer label : removed) {
                        KernelTransactionImplementation.this.counts.incrementNodeCount(label, -1L);
                    }
                    try (Cursor<NodeItem> node = statement.acquireSingleNodeCursor(id);){
                        if (!node.next()) break block43;
                        try (Cursor<DegreeItem> degrees = ((NodeItem)node.get()).degrees();){
                            while (degrees.next()) {
                                DegreeItem degree = (DegreeItem)degrees.get();
                                for (Integer label : added) {
                                    KernelTransactionImplementation.this.updateRelationshipsCountsFromDegrees(degree.type(), label, degree.outgoing(), degree.incoming());
                                }
                                for (Integer label : removed) {
                                    KernelTransactionImplementation.this.updateRelationshipsCountsFromDegrees(degree.type(), label, -degree.outgoing(), -degree.incoming());
                                }
                            }
                        }
                    }
                }
            }
            for (Integer label : removed) {
                KernelTransactionImplementation.this.recordState.removeLabelFromNode(label, id);
            }
            for (Integer label : added) {
                KernelTransactionImplementation.this.recordState.addLabelToNode(label, id);
            }
        }

        @Override
        public void visitAddedIndex(IndexDescriptor element, boolean isConstraintIndex) {
            SchemaIndexProvider.Descriptor providerDescriptor = KernelTransactionImplementation.this.providerMap.getDefaultProvider().getProviderDescriptor();
            IndexRule rule = isConstraintIndex ? IndexRule.constraintIndexRule(KernelTransactionImplementation.this.schemaStorage.newRuleId(), element.getLabelId(), element.getPropertyKeyId(), providerDescriptor, null) : IndexRule.indexRule(KernelTransactionImplementation.this.schemaStorage.newRuleId(), element.getLabelId(), element.getPropertyKeyId(), providerDescriptor);
            KernelTransactionImplementation.this.recordState.createSchemaRule(rule);
        }

        @Override
        public void visitRemovedIndex(IndexDescriptor element, boolean isConstraintIndex) {
            SchemaStorage.IndexRuleKind kind = isConstraintIndex ? SchemaStorage.IndexRuleKind.CONSTRAINT : SchemaStorage.IndexRuleKind.INDEX;
            IndexRule rule = KernelTransactionImplementation.this.schemaStorage.indexRule(element.getLabelId(), element.getPropertyKeyId(), kind);
            KernelTransactionImplementation.this.recordState.dropSchemaRule(rule);
        }

        @Override
        public void visitAddedUniquePropertyConstraint(UniquenessConstraint element) {
            this.clearState = true;
            long constraintId = KernelTransactionImplementation.this.schemaStorage.newRuleId();
            IndexRule indexRule = KernelTransactionImplementation.this.schemaStorage.indexRule(element.label(), element.propertyKey(), SchemaStorage.IndexRuleKind.CONSTRAINT);
            KernelTransactionImplementation.this.recordState.createSchemaRule(KernelTransactionImplementation.this.constraintSemantics.writeUniquePropertyConstraint(constraintId, element.label(), element.propertyKey(), indexRule.getId()));
            KernelTransactionImplementation.this.recordState.setConstraintIndexOwner(indexRule, constraintId);
        }

        @Override
        public void visitRemovedUniquePropertyConstraint(UniquenessConstraint element) {
            try {
                this.clearState = true;
                UniquePropertyConstraintRule rule = KernelTransactionImplementation.this.schemaStorage.uniquenessConstraint(element.label(), element.propertyKey());
                KernelTransactionImplementation.this.recordState.dropSchemaRule(rule);
            }
            catch (SchemaRuleNotFoundException e) {
                throw new ThisShouldNotHappenError("Tobias Lindaaker", "Constraint to be removed should exist, since its existence should have been validated earlier and the schema should have been locked.");
            }
            catch (DuplicateSchemaRuleException de) {
                throw new IllegalStateException("Multiple constraints found for specified label and property.");
            }
            this.visitRemovedIndex(new IndexDescriptor(element.label(), element.propertyKey()), true);
        }

        @Override
        public void visitAddedNodePropertyExistenceConstraint(NodePropertyExistenceConstraint element) throws CreateConstraintFailureException {
            this.clearState = true;
            KernelTransactionImplementation.this.recordState.createSchemaRule(KernelTransactionImplementation.this.constraintSemantics.writeNodePropertyExistenceConstraint(KernelTransactionImplementation.this.schemaStorage.newRuleId(), element.label(), element.propertyKey()));
        }

        @Override
        public void visitRemovedNodePropertyExistenceConstraint(NodePropertyExistenceConstraint element) {
            try {
                this.clearState = true;
                KernelTransactionImplementation.this.recordState.dropSchemaRule(KernelTransactionImplementation.this.schemaStorage.nodePropertyExistenceConstraint(element.label(), element.propertyKey()));
            }
            catch (SchemaRuleNotFoundException e) {
                throw new IllegalStateException("Node property existence constraint to be removed should exist, since its existence should have been validated earlier and the schema should have been locked.");
            }
            catch (DuplicateSchemaRuleException de) {
                throw new IllegalStateException("Multiple node property constraints found for specified label and property.");
            }
        }

        @Override
        public void visitAddedRelationshipPropertyExistenceConstraint(RelationshipPropertyExistenceConstraint element) throws CreateConstraintFailureException {
            this.clearState = true;
            KernelTransactionImplementation.this.recordState.createSchemaRule(KernelTransactionImplementation.this.constraintSemantics.writeRelationshipPropertyExistenceConstraint(KernelTransactionImplementation.this.schemaStorage.newRuleId(), element.relationshipType(), element.propertyKey()));
        }

        @Override
        public void visitRemovedRelationshipPropertyExistenceConstraint(RelationshipPropertyExistenceConstraint element) {
            try {
                this.clearState = true;
                RelationshipPropertyExistenceConstraintRule rule = KernelTransactionImplementation.this.schemaStorage.relationshipPropertyExistenceConstraint(element.relationshipType(), element.propertyKey());
                KernelTransactionImplementation.this.recordState.dropSchemaRule(rule);
            }
            catch (SchemaRuleNotFoundException e) {
                throw new IllegalStateException("Relationship property existence constraint to be removed should exist, since its existence should have been validated earlier and the schema should have been locked.");
            }
            catch (DuplicateSchemaRuleException re) {
                throw new IllegalStateException("Multiple relationship property constraints found for specified property and relationship type.");
            }
        }

        @Override
        public void visitCreatedLabelToken(String name, int id) {
            KernelTransactionImplementation.this.recordState.createLabelToken(name, id);
        }

        @Override
        public void visitCreatedPropertyKeyToken(String name, int id) {
            KernelTransactionImplementation.this.recordState.createPropertyKeyToken(name, id);
        }

        @Override
        public void visitCreatedRelationshipTypeToken(String name, int id) {
            KernelTransactionImplementation.this.recordState.createRelationshipTypeToken(name, id);
        }

        @Override
        public void visitCreatedNodeLegacyIndex(String name, Map<String, String> config) {
            KernelTransactionImplementation.this.legacyIndexTransactionState.createIndex(IndexEntityType.Node, name, config);
        }

        @Override
        public void visitCreatedRelationshipLegacyIndex(String name, Map<String, String> config) {
            KernelTransactionImplementation.this.legacyIndexTransactionState.createIndex(IndexEntityType.Relationship, name, config);
        }

        @Override
        public void visitCreatedProcedure(ProcedureDescriptor procedureDescriptor) {
            KernelTransactionImplementation.this.procedureCache.createProcedure(procedureDescriptor);
        }

        @Override
        public void visitDroppedProcedure(ProcedureDescriptor procedureDescriptor) {
            KernelTransactionImplementation.this.procedureCache.dropProcedure(procedureDescriptor);
        }
    }

    private static enum TransactionType {
        ANY,
        DATA{

            @Override
            TransactionType upgradeToSchemaTransaction() throws InvalidTransactionTypeKernelException {
                throw new InvalidTransactionTypeKernelException("Cannot perform schema updates in a transaction that has performed data updates.");
            }
        }
        ,
        SCHEMA{

            @Override
            TransactionType upgradeToDataTransaction() throws InvalidTransactionTypeKernelException {
                throw new InvalidTransactionTypeKernelException("Cannot perform data updates in a transaction that has performed schema updates.");
            }
        };


        TransactionType upgradeToDataTransaction() throws InvalidTransactionTypeKernelException {
            return DATA;
        }

        TransactionType upgradeToSchemaTransaction() throws InvalidTransactionTypeKernelException {
            return SCHEMA;
        }
    }
}

