/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionRepresentationStoreApplier;
import org.neo4j.kernel.impl.api.index.IndexUpdatesValidator;
import org.neo4j.kernel.impl.api.index.ValidatedIndexUpdates;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.Commitment;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.StoreApplyEvent;

public class TransactionRepresentationCommitProcess
implements TransactionCommitProcess {
    private final TransactionAppender appender;
    private final TransactionRepresentationStoreApplier storeApplier;
    private final IndexUpdatesValidator indexUpdatesValidator;

    public TransactionRepresentationCommitProcess(TransactionAppender appender, TransactionRepresentationStoreApplier storeApplier, IndexUpdatesValidator indexUpdatesValidator) {
        this.appender = appender;
        this.storeApplier = storeApplier;
        this.indexUpdatesValidator = indexUpdatesValidator;
    }

    @Override
    public long commit(TransactionRepresentation transaction, LockGroup locks, CommitEvent commitEvent, TransactionApplicationMode mode) throws TransactionFailureException {
        try (ValidatedIndexUpdates indexUpdates = this.validateIndexUpdates(transaction);){
            Commitment commitment = this.appendToLog(transaction, commitEvent);
            this.applyToStore(transaction, locks, commitEvent, indexUpdates, commitment, mode);
            long l = commitment.transactionId();
            return l;
        }
    }

    private ValidatedIndexUpdates validateIndexUpdates(TransactionRepresentation transaction) throws TransactionFailureException {
        try {
            return this.indexUpdatesValidator.validate(transaction);
        }
        catch (Throwable e) {
            throw new TransactionFailureException((Status)Status.Transaction.ValidationFailed, e, "Validation of index updates failed", new Object[0]);
        }
    }

    private Commitment appendToLog(TransactionRepresentation transaction, CommitEvent commitEvent) throws TransactionFailureException {
        Commitment commitment;
        try (LogAppendEvent logAppendEvent = commitEvent.beginLogAppend();){
            commitment = this.appender.append(transaction, logAppendEvent);
        }
        catch (Throwable cause) {
            throw new TransactionFailureException((Status)Status.Transaction.CouldNotWriteToLog, cause, "Could not append transaction representation to log", new Object[0]);
        }
        commitEvent.setTransactionId(commitment.transactionId());
        return commitment;
    }

    private void applyToStore(TransactionRepresentation transaction, LockGroup locks, CommitEvent commitEvent, ValidatedIndexUpdates indexUpdates, Commitment commitment, TransactionApplicationMode mode) throws TransactionFailureException {
        try (StoreApplyEvent storeApplyEvent = commitEvent.beginStoreApply();){
            this.storeApplier.apply(transaction, indexUpdates, locks, commitment.transactionId(), mode);
        }
        catch (Throwable cause) {
            throw new TransactionFailureException((Status)Status.Transaction.CouldNotCommit, cause, "Could not apply the transaction to the store after written to log", new Object[0]);
        }
        finally {
            commitment.publishAsApplied();
        }
    }
}

