/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.Collections;
import java.util.Objects;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;

abstract class PropertyConstraintDefinition
implements ConstraintDefinition {
    protected final InternalSchemaActions actions;
    protected final String propertyKey;

    protected PropertyConstraintDefinition(InternalSchemaActions actions, String propertyKey) {
        this.actions = Objects.requireNonNull(actions);
        this.propertyKey = Objects.requireNonNull(propertyKey);
    }

    @Override
    public Iterable<String> getPropertyKeys() {
        this.assertInUnterminatedTransaction();
        return Collections.singleton(this.propertyKey);
    }

    @Override
    public boolean isConstraintType(ConstraintType type) {
        this.assertInUnterminatedTransaction();
        return this.getConstraintType().equals((Object)type);
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    protected void assertInUnterminatedTransaction() {
        this.actions.assertInUnterminatedTransaction();
    }
}

