/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.Arrays;
import java.util.concurrent.Callable;
import org.neo4j.function.Supplier;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.LongerShortString;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.ShortArray;
import org.neo4j.kernel.impl.store.record.PropertyBlock;

public enum PropertyType {
    BOOL(1){

        @Override
        public DefinedProperty readProperty(int propertyKeyId, PropertyBlock block, Supplier<PropertyStore> store) {
            return Property.booleanProperty(propertyKeyId, this.getValue(block.getSingleValueLong()));
        }

        @Override
        public Object getValue(PropertyBlock block, PropertyStore store) {
            return this.getValue(block.getSingleValueLong());
        }

        private boolean getValue(long propBlock) {
            return (propBlock & 1L) == 1L;
        }
    }
    ,
    BYTE(2){

        @Override
        public DefinedProperty readProperty(int propertyKeyId, PropertyBlock block, Supplier<PropertyStore> store) {
            return Property.byteProperty(propertyKeyId, block.getSingleValueByte());
        }

        @Override
        public Object getValue(PropertyBlock block, PropertyStore store) {
            return block.getSingleValueByte();
        }
    }
    ,
    SHORT(3){

        @Override
        public DefinedProperty readProperty(int propertyKeyId, PropertyBlock block, Supplier<PropertyStore> store) {
            return Property.shortProperty(propertyKeyId, block.getSingleValueShort());
        }

        @Override
        public Object getValue(PropertyBlock block, PropertyStore store) {
            return block.getSingleValueShort();
        }
    }
    ,
    CHAR(4){

        @Override
        public DefinedProperty readProperty(int propertyKeyId, PropertyBlock block, Supplier<PropertyStore> store) {
            return Property.charProperty(propertyKeyId, (char)block.getSingleValueShort());
        }

        @Override
        public Object getValue(PropertyBlock block, PropertyStore store) {
            return Character.valueOf((char)block.getSingleValueShort());
        }
    }
    ,
    INT(5){

        @Override
        public DefinedProperty readProperty(int propertyKeyId, PropertyBlock block, Supplier<PropertyStore> store) {
            return Property.intProperty(propertyKeyId, block.getSingleValueInt());
        }

        @Override
        public Object getValue(PropertyBlock block, PropertyStore store) {
            return block.getSingleValueInt();
        }
    }
    ,
    LONG(6){

        @Override
        public DefinedProperty readProperty(int propertyKeyId, PropertyBlock block, Supplier<PropertyStore> store) {
            long firstBlock = block.getSingleValueBlock();
            long value = this.valueIsInlined(firstBlock) ? block.getSingleValueLong() >>> 1 : block.getValueBlocks()[1];
            return Property.longProperty(propertyKeyId, value);
        }

        @Override
        public Object getValue(PropertyBlock block, PropertyStore store) {
            return this.getLongValue(block);
        }

        private long getLongValue(PropertyBlock block) {
            long firstBlock = block.getSingleValueBlock();
            return this.valueIsInlined(firstBlock) ? block.getSingleValueLong() >>> 1 : block.getValueBlocks()[1];
        }

        private boolean valueIsInlined(long firstBlock) {
            return (firstBlock & 0x10000000L) > 0L;
        }

        @Override
        public int calculateNumberOfBlocksUsed(long firstBlock) {
            return this.valueIsInlined(firstBlock) ? 1 : 2;
        }
    }
    ,
    FLOAT(7){

        @Override
        public DefinedProperty readProperty(int propertyKeyId, PropertyBlock block, Supplier<PropertyStore> store) {
            return Property.floatProperty(propertyKeyId, Float.intBitsToFloat(block.getSingleValueInt()));
        }

        @Override
        public Object getValue(PropertyBlock block, PropertyStore store) {
            return Float.valueOf(this.getValue(block.getSingleValueInt()));
        }

        private float getValue(int propBlock) {
            return Float.intBitsToFloat(propBlock);
        }
    }
    ,
    DOUBLE(8){

        @Override
        public DefinedProperty readProperty(int propertyKeyId, PropertyBlock block, Supplier<PropertyStore> store) {
            return Property.doubleProperty(propertyKeyId, Double.longBitsToDouble(block.getValueBlocks()[1]));
        }

        @Override
        public Object getValue(PropertyBlock block, PropertyStore store) {
            return this.getValue(block.getValueBlocks()[1]);
        }

        private double getValue(long propBlock) {
            return Double.longBitsToDouble(propBlock);
        }

        @Override
        public int calculateNumberOfBlocksUsed(long firstBlock) {
            return 2;
        }
    }
    ,
    STRING(9){

        @Override
        public DefinedProperty readProperty(int propertyKeyId, final PropertyBlock block, final Supplier<PropertyStore> store) {
            return Property.lazyStringProperty(propertyKeyId, new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return this.getValue(block, (PropertyStore)store.get());
                }
            });
        }

        @Override
        public String getValue(PropertyBlock block, PropertyStore store) {
            if (store == null) {
                return null;
            }
            return store.getStringFor(block);
        }

        @Override
        public byte[] readDynamicRecordHeader(byte[] recordBytes) {
            return EMPTY_BYTE_ARRAY;
        }
    }
    ,
    ARRAY(10){

        @Override
        public DefinedProperty readProperty(int propertyKeyId, final PropertyBlock block, final Supplier<PropertyStore> store) {
            return Property.lazyArrayProperty(propertyKeyId, new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return this.getValue(block, (PropertyStore)store.get());
                }
            });
        }

        @Override
        public Object getValue(PropertyBlock block, PropertyStore store) {
            if (store == null) {
                return null;
            }
            return store.getArrayFor(block);
        }

        @Override
        public byte[] readDynamicRecordHeader(byte[] recordBytes) {
            byte itemType = recordBytes[0];
            if (itemType == STRING.byteValue()) {
                return this.headOf(recordBytes, 5);
            }
            if (itemType <= DOUBLE.byteValue()) {
                return this.headOf(recordBytes, 3);
            }
            throw new IllegalArgumentException("Unknown array type " + itemType);
        }

        private byte[] headOf(byte[] bytes, int length) {
            return Arrays.copyOf(bytes, length);
        }
    }
    ,
    SHORT_STRING(11){

        @Override
        public DefinedProperty readProperty(int propertyKeyId, PropertyBlock block, Supplier<PropertyStore> store) {
            return Property.stringProperty(propertyKeyId, LongerShortString.decode(block));
        }

        @Override
        public Object getValue(PropertyBlock block, PropertyStore store) {
            return LongerShortString.decode(block);
        }

        @Override
        public int calculateNumberOfBlocksUsed(long firstBlock) {
            return LongerShortString.calculateNumberOfBlocksUsed(firstBlock);
        }
    }
    ,
    SHORT_ARRAY(12){

        @Override
        public DefinedProperty readProperty(int propertyKeyId, PropertyBlock block, Supplier<PropertyStore> store) {
            return Property.property(propertyKeyId, ShortArray.decode(block));
        }

        @Override
        public Object getValue(PropertyBlock block, PropertyStore store) {
            return ShortArray.decode(block);
        }

        @Override
        public int calculateNumberOfBlocksUsed(long firstBlock) {
            return ShortArray.calculateNumberOfBlocksUsed(firstBlock);
        }
    };

    public static final byte[] EMPTY_BYTE_ARRAY;
    public static final int BLOCKS_USED_FOR_BAD_TYPE_OR_ENCODING = -1;
    private final int type;
    private static int payloadSize;

    private PropertyType(int type) {
        this.type = type;
    }

    public int intValue() {
        return this.type;
    }

    public byte byteValue() {
        return (byte)this.type;
    }

    public abstract Object getValue(PropertyBlock var1, PropertyStore var2);

    public abstract DefinedProperty readProperty(int var1, PropertyBlock var2, Supplier<PropertyStore> var3);

    public static PropertyType getPropertyType(long propBlock, boolean nullOnIllegal) {
        int type = (int)((propBlock & 0xF000000L) >> 24);
        switch (type) {
            case 1: {
                return BOOL;
            }
            case 2: {
                return BYTE;
            }
            case 3: {
                return SHORT;
            }
            case 4: {
                return CHAR;
            }
            case 5: {
                return INT;
            }
            case 6: {
                return LONG;
            }
            case 7: {
                return FLOAT;
            }
            case 8: {
                return DOUBLE;
            }
            case 9: {
                return STRING;
            }
            case 10: {
                return ARRAY;
            }
            case 11: {
                return SHORT_STRING;
            }
            case 12: {
                return SHORT_ARRAY;
            }
        }
        if (nullOnIllegal) {
            return null;
        }
        throw new InvalidRecordException("Unknown property type for type " + type);
    }

    public static int getPayloadSize() {
        return payloadSize;
    }

    public static int getPayloadSizeLongs() {
        return payloadSize >>> 3;
    }

    public static void setPayloadSize(int newPayloadSize) {
        if (newPayloadSize % 8 != 0) {
            throw new RuntimeException("Payload must be divisible by 8");
        }
        payloadSize = newPayloadSize;
    }

    public int calculateNumberOfBlocksUsed(long firstBlock) {
        return 1;
    }

    public byte[] readDynamicRecordHeader(byte[] recordBytes) {
        throw new UnsupportedOperationException();
    }

    static {
        EMPTY_BYTE_ARRAY = new byte[0];
        payloadSize = 32;
    }
}

