/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts;

import java.io.IOException;
import org.neo4j.function.Function;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyFactory;
import org.neo4j.kernel.impl.store.kvstore.EntryUpdater;
import org.neo4j.kernel.impl.store.kvstore.ValueUpdate;
import org.neo4j.kernel.impl.store.kvstore.WritableBuffer;

final class CountsUpdater
implements CountsAccessor.Updater,
CountsAccessor.IndexStatsUpdater,
AutoCloseable {
    static final Function<EntryUpdater<CountsKey>, CountsUpdater> FACTORY = new Function<EntryUpdater<CountsKey>, CountsUpdater>(){

        public CountsUpdater apply(EntryUpdater<CountsKey> updater) throws RuntimeException {
            return new CountsUpdater(updater);
        }
    };
    private final EntryUpdater<CountsKey> updater;

    public CountsUpdater(EntryUpdater<CountsKey> updater) {
        this.updater = updater;
    }

    @Override
    public void incrementNodeCount(int labelId, long delta) {
        try {
            this.updater.apply(CountsKeyFactory.nodeKey(labelId), CountsUpdater.incrementSecondBy(delta));
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    @Override
    public void incrementRelationshipCount(int startLabelId, int typeId, int endLabelId, long delta) {
        try {
            this.updater.apply(CountsKeyFactory.relationshipKey(startLabelId, typeId, endLabelId), CountsUpdater.incrementSecondBy(delta));
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    @Override
    public void replaceIndexUpdateAndSize(int labelId, int propertyKeyId, long updates, long size) {
        try {
            this.updater.apply(CountsKeyFactory.indexStatisticsKey(labelId, propertyKeyId), new Write(updates, size));
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    @Override
    public void replaceIndexSample(int labelId, int propertyKeyId, long unique, long size) {
        try {
            this.updater.apply(CountsKeyFactory.indexSampleKey(labelId, propertyKeyId), new Write(unique, size));
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    @Override
    public void incrementIndexUpdates(int labelId, int propertyKeyId, long delta) {
        try {
            this.updater.apply(CountsKeyFactory.indexStatisticsKey(labelId, propertyKeyId), CountsUpdater.incrementFirstBy(delta));
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    @Override
    public void close() {
        this.updater.close();
    }

    private static IncrementLong incrementFirstBy(long delta) {
        return new IncrementLong(0, delta);
    }

    private static IncrementLong incrementSecondBy(long delta) {
        return new IncrementLong(8, delta);
    }

    private static class IncrementLong
    implements ValueUpdate {
        private final int offset;
        private final long delta;

        private IncrementLong(int offset, long delta) {
            this.offset = offset;
            this.delta = delta;
        }

        @Override
        public void update(WritableBuffer target) {
            target.putLong(this.offset, target.getLong(this.offset) + this.delta);
        }
    }

    private static class Write
    implements ValueUpdate {
        private final long first;
        private final long second;

        Write(long first, long second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public void update(WritableBuffer target) {
            target.putLong(0, this.first);
            target.putLong(8, this.second);
        }
    }
}

