/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import org.neo4j.function.Consumer;
import org.neo4j.function.Predicate;
import org.neo4j.function.Supplier;
import org.neo4j.kernel.impl.api.KernelTransactionsSnapshot;
import org.neo4j.kernel.impl.store.id.DelayedBuffer;
import org.neo4j.kernel.impl.store.id.IdGenerator;

class BufferingIdGenerator
extends IdGenerator.Delegate {
    private DelayedBuffer<KernelTransactionsSnapshot> buffer;

    public BufferingIdGenerator(IdGenerator delegate) {
        super(delegate);
    }

    void initialize(Supplier<KernelTransactionsSnapshot> boundaries, Predicate<KernelTransactionsSnapshot> safeThreshold) {
        this.buffer = new DelayedBuffer<KernelTransactionsSnapshot>(boundaries, safeThreshold, 10000, new Consumer<long[]>(){

            public void accept(long[] freedIds) {
                for (long id : freedIds) {
                    BufferingIdGenerator.this.actualFreeId(id);
                }
            }
        });
    }

    private void actualFreeId(long id) {
        super.freeId(id);
    }

    @Override
    public void freeId(long id) {
        this.buffer.offer(id);
    }

    void maintenance() {
        this.buffer.maintenance();
    }

    void clear() {
        this.buffer.clear();
    }

    @Override
    public void close() {
        if (this.buffer != null) {
            this.buffer.close();
        }
        super.close();
    }
}

