/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.util.concurrent.TimeUnit;
import org.neo4j.helpers.Clock;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.transaction.log.IllegalLogFormatException;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.pruning.FileCountThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.FileSizeThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruneStrategy;
import org.neo4j.kernel.impl.transaction.log.pruning.Threshold;
import org.neo4j.kernel.impl.transaction.log.pruning.ThresholdBasedPruneStrategy;
import org.neo4j.kernel.impl.transaction.log.pruning.TransactionCountThreshold;
import org.neo4j.kernel.impl.transaction.log.pruning.TransactionTimespanThreshold;

public class LogPruneStrategyFactory {
    public static final LogPruneStrategy NO_PRUNING = new LogPruneStrategy(){

        @Override
        public void prune(long upToLogVersion) {
        }

        public String toString() {
            return "NO_PRUNING";
        }
    };

    static boolean decidePruneForIllegalLogFormat(IllegalLogFormatException e) {
        if (e.wasNewerLogVersion()) {
            throw new RuntimeException("Unable to read database logs, because it contains logs from a newer version of Neo4j.", e);
        }
        return true;
    }

    public static LogPruneStrategy fromConfigValue(FileSystemAbstraction fileSystem, LogFileInformation logFileInformation, PhysicalLogFiles files, String configValue) {
        String[] tokens = configValue.split(" ");
        if (tokens.length == 0) {
            throw new IllegalArgumentException("Invalid log pruning configuration value '" + configValue + "'");
        }
        String boolOrNumber = tokens[0];
        if (tokens.length == 1) {
            switch (boolOrNumber) {
                case "true": {
                    return NO_PRUNING;
                }
                case "false": {
                    TransactionCountThreshold thresholdToUse = new TransactionCountThreshold(1L);
                    return new ThresholdBasedPruneStrategy(fileSystem, logFileInformation, files, thresholdToUse);
                }
            }
            throw new IllegalArgumentException("Invalid log pruning configuration value '" + configValue + "'. The form is 'all' or '<number><unit> <type>' for example '100k txs' " + "for the latest 100 000 transactions");
        }
        Threshold thresholdToUse = LogPruneStrategyFactory.getThresholdByType(fileSystem, tokens[1], boolOrNumber, configValue);
        return new ThresholdBasedPruneStrategy(fileSystem, logFileInformation, files, thresholdToUse);
    }

    static Threshold getThresholdByType(FileSystemAbstraction fileSystem, String type, String thresholdValueString, String originalConfigValue) {
        Threshold thresholdToUse;
        long thresholdValue = Config.parseLongWithUnit(thresholdValueString);
        switch (type) {
            case "files": {
                thresholdToUse = new FileCountThreshold(thresholdValue);
                break;
            }
            case "size": {
                thresholdToUse = new FileSizeThreshold(fileSystem, thresholdValue);
                break;
            }
            case "txs": {
                thresholdToUse = new TransactionCountThreshold(thresholdValue);
                break;
            }
            case "hours": {
                thresholdToUse = new TransactionTimespanThreshold(Clock.SYSTEM_CLOCK, TimeUnit.HOURS, thresholdValue);
                break;
            }
            case "days": {
                thresholdToUse = new TransactionTimespanThreshold(Clock.SYSTEM_CLOCK, TimeUnit.DAYS, thresholdValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid log pruning configuration value '" + originalConfigValue + "'. Invalid type '" + type + "', valid are files, size, txs, hours, days.");
            }
        }
        return thresholdToUse;
    }
}

