/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.neo4j.io.fs.FileUtils;

public class StoreUtil {
    public static final String BRANCH_SUBDIRECTORY = "branched";

    public static void cleanStoreDir(File storeDir) throws IOException {
        for (File file : StoreUtil.relevantDbFiles(storeDir)) {
            FileUtils.deleteRecursively((File)file);
        }
    }

    private static File[] relevantDbFiles(File storeDir) {
        if (!storeDir.exists()) {
            return new File[0];
        }
        return storeDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.getName().startsWith("metrics") && !file.getName().startsWith("messages.") && !StoreUtil.isBranchedDataRootDirectory(file);
            }
        });
    }

    public static File newBranchedDataDir(File storeDir) {
        File result = StoreUtil.getBranchedDataDirectory(storeDir, System.currentTimeMillis());
        result.mkdirs();
        return result;
    }

    private static boolean isBranchedDataRootDirectory(File file) {
        return file.isDirectory() && file.getName().equals(BRANCH_SUBDIRECTORY);
    }

    public static boolean isBranchedDataDirectory(File file) {
        return file.isDirectory() && file.getParentFile().getName().equals(BRANCH_SUBDIRECTORY) && StoreUtil.isNumerical(file.getName());
    }

    public static File getBranchedDataRootDirectory(File storeDir) {
        return new File(storeDir, BRANCH_SUBDIRECTORY);
    }

    public static File getBranchedDataDirectory(File storeDir, long timestamp) {
        return new File(StoreUtil.getBranchedDataRootDirectory(storeDir), "" + timestamp);
    }

    private static boolean isNumerical(String string) {
        for (char c : string.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static void moveAwayDb(File storeDir, File branchedDataDir) throws IOException {
        for (File file : StoreUtil.relevantDbFiles(storeDir)) {
            FileUtils.moveFileToDirectory((File)file, (File)branchedDataDir);
        }
    }
}

