/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert;

import java.util.Iterator;
import org.neo4j.function.Consumer;
import org.neo4j.function.Consumers;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.impl.api.store.StoreNodeRelationshipCursor;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;

abstract class BatchRelationshipIterable<T>
implements Iterable<T> {
    private final StoreNodeRelationshipCursor relationshipCursor;

    public BatchRelationshipIterable(NeoStores neoStores, long nodeId) {
        RelationshipRecord relationshipRecord = new RelationshipRecord(-1L);
        RelationshipGroupRecord relationshipGroupRecord = new RelationshipGroupRecord(-1L, -1);
        this.relationshipCursor = new StoreNodeRelationshipCursor(relationshipRecord, neoStores, relationshipGroupRecord, null, (Consumer<StoreNodeRelationshipCursor>)Consumers.noop(), LockService.NO_LOCK_SERVICE);
        try {
            NodeRecord nodeRecord = neoStores.getNodeStore().getRecord(nodeId);
            this.relationshipCursor.init(nodeRecord.isDense(), nodeRecord.getNextRel(), nodeId, Direction.BOTH);
        }
        catch (InvalidRecordException e) {
            throw new NotFoundException("Node " + nodeId + " not found");
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new PrefetchingIterator<T>(){

            @Override
            protected T fetchNextOrNull() {
                if (!BatchRelationshipIterable.this.relationshipCursor.next()) {
                    return null;
                }
                return BatchRelationshipIterable.this.nextFrom(BatchRelationshipIterable.this.relationshipCursor.id(), BatchRelationshipIterable.this.relationshipCursor.type(), BatchRelationshipIterable.this.relationshipCursor.startNode(), BatchRelationshipIterable.this.relationshipCursor.endNode());
            }
        };
    }

    protected abstract T nextFrom(long var1, int var3, long var4, long var6);
}

