/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.util.Collection;
import org.apache.lucene.document.Document;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.index.impl.lucene.AbstractIndexHits;
import org.neo4j.index.impl.lucene.IndexReference;

public class DocToIdIterator
extends AbstractIndexHits<Long> {
    private final Collection<Long> exclude;
    private IndexReference searcherOrNull;
    private final IndexHits<Document> source;

    public DocToIdIterator(IndexHits<Document> source, Collection<Long> exclude, IndexReference searcherOrNull) {
        this.source = source;
        this.exclude = exclude;
        this.searcherOrNull = searcherOrNull;
        if (source.size() == 0) {
            this.close();
        }
    }

    protected Long fetchNextOrNull() {
        Long result = null;
        while (result == null) {
            if (!this.source.hasNext()) {
                this.endReached();
                break;
            }
            Document doc = (Document)this.source.next();
            Long id = Long.valueOf(doc.get("_id_"));
            if (this.exclude.contains(id)) continue;
            result = id;
        }
        return result;
    }

    protected void endReached() {
        this.close();
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            this.searcherOrNull.close();
            this.searcherOrNull = null;
        }
    }

    public int size() {
        return Math.max(0, this.source.size() - this.exclude.size());
    }

    private boolean isClosed() {
        return this.searcherOrNull == null;
    }

    public float currentScore() {
        return this.source.currentScore();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

