/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexImplementation;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.impl.lucene.LuceneDataSource;
import org.neo4j.index.impl.lucene.LuceneXaConnection;
import org.neo4j.kernel.impl.index.IndexConnectionBroker;

public class LuceneIndexImplementation
implements IndexImplementation {
    static final String KEY_TYPE = "type";
    static final String KEY_ANALYZER = "analyzer";
    static final String KEY_TO_LOWER_CASE = "to_lower_case";
    static final String KEY_SIMILARITY = "similarity";
    public static final String SERVICE_NAME = "lucene";
    public static final Map<String, String> EXACT_CONFIG = Collections.unmodifiableMap(MapUtil.stringMap((String[])new String[]{"provider", "lucene", "type", "exact"}));
    public static final Map<String, String> FULLTEXT_CONFIG = Collections.unmodifiableMap(MapUtil.stringMap((String[])new String[]{"provider", "lucene", "type", "fulltext", "to_lower_case", "true"}));
    public static final int DEFAULT_LAZY_THRESHOLD = 100;
    private final GraphDatabaseService graphDb;
    private IndexConnectionBroker<LuceneXaConnection> broker;
    private LuceneDataSource dataSource;
    final int lazynessThreshold;

    public LuceneIndexImplementation(GraphDatabaseService db, LuceneDataSource dataSource, IndexConnectionBroker<LuceneXaConnection> broker) {
        this.graphDb = db;
        this.dataSource = dataSource;
        this.broker = broker;
        this.lazynessThreshold = 100;
    }

    IndexConnectionBroker<LuceneXaConnection> broker() {
        return this.broker;
    }

    LuceneDataSource dataSource() {
        return this.dataSource;
    }

    public Index<Node> nodeIndex(String indexName, Map<String, String> config) {
        return this.dataSource.nodeIndex(indexName, this.graphDb, this);
    }

    public RelationshipIndex relationshipIndex(String indexName, Map<String, String> config) {
        return this.dataSource.relationshipIndex(indexName, this.graphDb, this);
    }

    public Map<String, String> fillInDefaults(Map<String, String> source) {
        HashMap<String, String> result = source != null ? new HashMap<String, String>(source) : new HashMap();
        String analyzer = (String)result.get(KEY_ANALYZER);
        if (analyzer == null) {
            String type = (String)result.get(KEY_TYPE);
            if (type == null) {
                type = "exact";
                result.put(KEY_TYPE, type);
            }
            if (type.equals("fulltext") && !result.containsKey(KEY_TO_LOWER_CASE)) {
                result.put(KEY_TO_LOWER_CASE, "true");
            }
        }
        return result;
    }

    public boolean configMatches(Map<String, String> storedConfig, Map<String, String> config) {
        return this.match(storedConfig, config, KEY_TYPE, null) && this.match(storedConfig, config, KEY_TO_LOWER_CASE, "true") && this.match(storedConfig, config, KEY_ANALYZER, null) && this.match(storedConfig, config, KEY_SIMILARITY, null);
    }

    private boolean match(Map<String, String> storedConfig, Map<String, String> config, String key, String defaultValue) {
        String value1 = storedConfig.get(key);
        String value2 = config.get(key);
        if (value1 == null || value2 == null) {
            if (value1 == value2) {
                return true;
            }
            if (defaultValue != null) {
                value1 = value1 != null ? value1 : defaultValue;
                value2 = value2 != null ? value2 : defaultValue;
                return value1.equals(value2);
            }
        } else {
            return value1.equals(value2);
        }
        return false;
    }

    public String getDataSourceName() {
        return "lucene-index";
    }

    public boolean matches(GraphDatabaseService gdb) {
        return this.graphDb.equals(gdb);
    }

    public void reset(LuceneDataSource dataSource, IndexConnectionBroker<LuceneXaConnection> broker) {
        this.broker = broker;
        this.dataSource = dataSource;
    }

    public GraphDatabaseService graphDb() {
        return this.graphDb;
    }
}

