/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.IOException;
import org.neo4j.index.impl.lucene.Hits;
import org.neo4j.kernel.api.impl.index.LuceneDocumentStructure;
import org.neo4j.kernel.impl.util.AbstractPrimitiveLongIterator;

public class HitsPrimitiveLongIterator
extends AbstractPrimitiveLongIterator {
    private final Hits hits;
    private final int size;
    private int index;
    private final LuceneDocumentStructure documentStructure;

    public HitsPrimitiveLongIterator(Hits hits, LuceneDocumentStructure documentStructure) {
        this.hits = hits;
        this.documentStructure = documentStructure;
        this.size = hits.length();
        this.computeNext();
    }

    protected void computeNext() {
        if (this.index < this.size) {
            try {
                this.next(this.documentStructure.getNodeId(this.hits.doc(this.index++)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.endReached();
        }
    }
}

