/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.api.impl.index.BitmapDocumentFormat;
import org.neo4j.kernel.api.impl.index.bitmaps.BitmapExtractor;
import org.neo4j.kernel.api.impl.index.bitmaps.LongPageIterator;
import org.neo4j.kernel.impl.util.PrimitiveLongIterator;

class PageOfRangesIterator
extends PrefetchingIterator<PrimitiveLongIterator> {
    private IndexSearcher searcher;
    private final Query query;
    private final BitmapDocumentFormat format;
    private final int rangesPerPage;
    private final int[] labels;
    private ScoreDoc lastDoc;

    PageOfRangesIterator(BitmapDocumentFormat format, IndexSearcher searcher, int rangesPerPage, Query query, int ... labels) {
        this.searcher = searcher;
        this.query = query;
        this.format = format;
        this.rangesPerPage = rangesPerPage;
        this.labels = labels;
        if (labels.length == 0) {
            throw new IllegalArgumentException("At least one label required");
        }
    }

    protected PrimitiveLongIterator fetchNextOrNull() {
        if (this.searcher == null) {
            return null;
        }
        try {
            int docCount;
            TopDocs docs = this.searcher.searchAfter(this.lastDoc, this.query, this.rangesPerPage);
            this.lastDoc = null;
            int n = docCount = docs != null ? docs.scoreDocs.length : 0;
            if (docCount == 0) {
                this.searcher = null;
                return null;
            }
            this.lastDoc = docs.scoreDocs[docCount - 1];
            long[] rangeMap = new long[docCount * 2];
            for (int i = 0; i < docCount; ++i) {
                Document doc = this.searcher.doc(docs.scoreDocs[i].doc);
                rangeMap[i * 2] = this.format.rangeOf(doc);
                rangeMap[i * 2 + 1] = this.labeledBitmap(doc);
            }
            if (docCount < this.rangesPerPage) {
                this.searcher = null;
            }
            return new LongPageIterator((Iterator<long[]>)((Object)new BitmapExtractor(this.format.bitmapFormat(), rangeMap)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private long labeledBitmap(Document doc) {
        long bitmap = -1L;
        for (int label : this.labels) {
            bitmap &= this.format.mapOf(doc, label);
        }
        return bitmap;
    }
}

