/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.typeconversion;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.neo4j.ogm.typeconversion.AttributeConverter;

public class LocalDateTimeStringConverter
implements AttributeConverter<LocalDateTime, String> {
    private final DateTimeFormatter formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;

    @Override
    public String toGraphProperty(LocalDateTime value) {
        if (value == null) {
            return null;
        }
        return this.formatter.format(value);
    }

    @Override
    public LocalDateTime toEntityAttribute(String value) {
        if (value == null) {
            return null;
        }
        return this.formatter.parse((CharSequence)value, LocalDateTime::from);
    }
}

