/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.util.Objects;

public final class MessageVersion {
    public static final MessageVersion GEMINI = new MessageVersion("gemini");
    public static final MessageVersion HTTP_1_0 = new MessageVersion("HTTP", 1, 0);
    public static final MessageVersion HTTP_1_1 = new MessageVersion("HTTP", 1, 1);
    public static final MessageVersion WARC_1_0 = new MessageVersion("WARC", 1, 0);
    public static final MessageVersion WARC_1_1 = new MessageVersion("WARC", 1, 1);
    public static final MessageVersion ARC_1_1 = new MessageVersion("ARC", 1, 1);
    private final String protocol;
    private final int major;
    private final int minor;

    public MessageVersion(String protocol) {
        this.protocol = protocol;
        this.major = 0;
        this.minor = 0;
    }

    public MessageVersion(String protocol, int major, int minor) {
        this.protocol = protocol;
        this.major = major;
        this.minor = minor;
    }

    public String getProtocol() {
        return this.protocol;
    }

    void requireProtocol(String expectedProtocol) {
        if (!this.protocol.equals(expectedProtocol)) {
            throw new IllegalArgumentException("Expected a version of " + expectedProtocol + " but got " + this);
        }
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageVersion that = (MessageVersion)o;
        return this.major == that.major && this.minor == that.minor && Objects.equals(this.protocol, that.protocol);
    }

    public int hashCode() {
        return Objects.hash(this.protocol, this.major, this.minor);
    }

    public String toString() {
        if (this.major == 0 && this.minor == 0) {
            return this.protocol;
        }
        return this.protocol + "/" + this.major + "." + this.minor;
    }
}

