/*
 * Decompiled with CFR 0.152.
 */
package hero.client.grapheditor;

import com.jgraph.JGraph;
import com.jgraph.graph.CellMapper;
import com.jgraph.graph.CellViewRenderer;
import com.jgraph.graph.GraphConstants;
import com.jgraph.graph.VertexRenderer;
import com.jgraph.graph.VertexView;
import hero.client.grapheditor.BonitaActivityCell;
import hero.client.grapheditor.Frame;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.net.URL;
import java.util.Map;

public class BonitaActivityView
extends VertexView {
    public ActivityRenderer renderer;

    public BonitaActivityView(Object arg0, JGraph arg1, CellMapper arg2) {
        super(arg0, arg1, arg2);
        this.renderer = new ActivityRenderer((BonitaActivityCell)((Object)arg0));
    }

    public CellViewRenderer getRenderer() {
        return this.renderer;
    }

    public static class ActivityRenderer
    extends VertexRenderer {
        private BonitaActivityCell activity;

        public ActivityRenderer(BonitaActivityCell rb) {
            this.activity = rb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            Dimension d = this.getSize();
            boolean tmp = this.selected;
            try {
                this.setBorder(null);
                this.setOpaque(false);
                this.setText("");
                this.selected = false;
                super.paint(g);
            }
            finally {
                this.selected = tmp;
            }
            if (this.selected) {
                g2.setStroke(GraphConstants.SELECTION_STROKE);
            } else {
                g2.setStroke(new BasicStroke(1.0f));
            }
            int y = (this.getHeight() - 19) / 2 + 1;
            Color contour = Color.decode("#3E6AAB");
            Map props = this.activity.getAttributes();
            if (!this.selected) {
                g2.setColor(this.getBackground());
                if (((String)props.get("subProcess")).equals("yes")) {
                    g2.fillOval(4, 4, this.getWidth() - 9, this.getHeight() - 9);
                } else {
                    g2.fillRoundRect(4, 4, this.getWidth() - 9, this.getHeight() - 9, 10, 10);
                }
            }
            g2.setColor(contour);
            if (((String)props.get("subProcess")).equals("yes")) {
                g2.drawOval(4, 4, this.getWidth() - 9, this.getHeight() - 9);
            } else {
                g2.drawRoundRect(4, 4, this.getWidth() - 9, this.getHeight() - 9, 10, 10);
            }
            Map propers = this.activity.getAttributes();
            String iteration = (String)propers.get("iterate");
            if (!iteration.equals("false")) {
                String iconPath = null;
                iconPath = iteration.equals("from") ? "images/from.gif" : "images/to.gif";
                try {
                    URL iconUrl = Thread.currentThread().getContextClassLoader().getResource(iconPath);
                    g2.drawImage(Toolkit.getDefaultToolkit().getImage(iconUrl), 5, y, 10, 10, (ImageObserver)((Object)Frame.getFrame().getWorkflowGraph()));
                }
                catch (Exception e) {
                    System.out.println("Unable to load image " + iconPath);
                }
            }
            g2.setColor(Color.WHITE);
            if (((String)props.get("subProcess")).equals("yes")) {
                g2.setFont(g2.getFont().deriveFont(12.0f));
            } else {
                g2.setFont(g2.getFont().deriveFont(11.0f));
            }
            g2.setFont(g2.getFont().deriveFont(2));
            String name = (String)props.get("name");
            g2.drawString(name, 11, y + 12);
        }
    }
}

