/*
 * Decompiled with CFR 0.152.
 */
package hero.client.grapheditor;

import java.io.IOException;
import java.util.ResourceBundle;

public class BrowserControl {
    static ResourceBundle resource = ResourceBundle.getBundle("resources.Traduction");
    private static final String WIN_ID = "Windows";
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";
    private static final String UNIX_PATH = "netscape";
    private static final String UNIX_FLAG = "-remote openURL";

    public static void displayURL(String url) {
        block6: {
            boolean windows = BrowserControl.isWindowsPlatform();
            String cmd = null;
            try {
                if (windows) {
                    cmd = "rundll32 url.dll,FileProtocolHandler " + url;
                    Process p = Runtime.getRuntime().exec(cmd);
                    break block6;
                }
                cmd = "netscape -remote openURL(" + url + ")";
                Process p = Runtime.getRuntime().exec(cmd);
                try {
                    int exitCode = p.waitFor();
                    if (exitCode != 0) {
                        cmd = "netscape " + url;
                        p = Runtime.getRuntime().exec(cmd);
                    }
                }
                catch (InterruptedException x) {
                    System.err.println(resource.getString("browsercontrol.error") + cmd + "'");
                    System.err.println(resource.getString("browsercontrol.caught") + x);
                }
            }
            catch (IOException x) {
                System.err.println(resource.getString("browsercontrol.notinvoke") + cmd);
                System.err.println(resource.getString("browsercontrol.caught") + x);
            }
        }
    }

    public static boolean isWindowsPlatform() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith(WIN_ID);
    }

    public static void main(String[] args) {
        BrowserControl.displayURL("http://www.javaworld.com");
    }
}

