/*
 * Decompiled with CFR 0.152.
 */
package hero.client.grapheditor;

import com.sun.java.swing.plaf.motif.MotifComboBoxUI;
import com.sun.java.swing.plaf.windows.WindowsComboBoxUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;

public class DateComboBox
extends JComboBox {
    static ResourceBundle resource = ResourceBundle.getBundle("resources.Traduction");
    protected SimpleDateFormat dateFormat = new SimpleDateFormat("MMM d, yyyy");

    public void setDateFormat(SimpleDateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setSelectedItem(Object item) {
        this.removeAllItems();
        this.addItem(item);
        super.setSelectedItem(item);
    }

    public void updateUI() {
        Object cui = (ComboBoxUI)UIManager.getUI(this);
        if (cui instanceof MetalComboBoxUI) {
            cui = new MetalDateComboBoxUI();
        } else if (cui instanceof MotifComboBoxUI) {
            cui = new MotifDateComboBoxUI();
        } else if (cui instanceof WindowsComboBoxUI) {
            cui = new WindowsDateComboBoxUI();
        }
        this.setUI((ComboBoxUI)cui);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        Container c = f.getContentPane();
        c.setLayout(new FlowLayout());
        c.add(new JLabel("Date 1:"));
        c.add(new DateComboBox());
        c.add(new JLabel("Date 2:"));
        DateComboBox dcb = new DateComboBox();
        dcb.setEditable(true);
        c.add(dcb);
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.setSize(500, 200);
        f.show();
    }

    class DatePopup
    implements ComboPopup,
    MouseMotionListener,
    MouseListener,
    KeyListener,
    PopupMenuListener {
        protected JComboBox comboBox;
        protected Calendar calendar;
        protected JPopupMenu popup;
        protected JLabel monthLabel;
        protected JPanel days = null;
        protected SimpleDateFormat monthFormat = new SimpleDateFormat("MMM yyyy");
        protected Color selectedBackground;
        protected Color selectedForeground;
        protected Color background;
        protected Color foreground;
        protected JList list = new JList();
        protected boolean mouseInside = false;
        protected boolean hideNext = false;

        public DatePopup(JComboBox comboBox) {
            this.comboBox = comboBox;
            this.calendar = Calendar.getInstance();
            this.background = UIManager.getColor("ComboBox.background");
            this.foreground = UIManager.getColor("ComboBox.foreground");
            this.selectedBackground = UIManager.getColor("ComboBox.selectionBackground");
            this.selectedForeground = UIManager.getColor("ComboBox.selectionForeground");
            this.initializePopup();
        }

        public void show() {
            try {
                this.calendar.setTime(DateComboBox.this.dateFormat.parse(this.comboBox.getSelectedItem().toString()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.updatePopup();
            this.popup.show(this.comboBox, 0, this.comboBox.getHeight());
        }

        public void hide() {
            this.popup.setVisible(false);
        }

        public JList getList() {
            return this.list;
        }

        public MouseListener getMouseListener() {
            return this;
        }

        public MouseMotionListener getMouseMotionListener() {
            return this;
        }

        public KeyListener getKeyListener() {
            return this;
        }

        public boolean isVisible() {
            return this.popup.isVisible();
        }

        public void uninstallingUI() {
            this.popup.removePopupMenuListener(this);
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            if (!this.comboBox.isEnabled()) {
                return;
            }
            if (this.comboBox.isEditable()) {
                this.comboBox.getEditor().getEditorComponent().requestFocus();
            } else {
                this.comboBox.requestFocus();
            }
            this.togglePopup();
        }

        public void mouseEntered(MouseEvent e) {
            this.mouseInside = true;
        }

        public void mouseExited(MouseEvent e) {
            this.mouseInside = false;
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 32 || e.getKeyCode() == 10) {
                this.togglePopup();
            }
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            this.hideNext = this.mouseInside;
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        protected void togglePopup() {
            if (this.isVisible() || this.hideNext) {
                this.hide();
            } else {
                this.show();
            }
            this.hideNext = false;
        }

        protected JLabel createUpdateButton(final int field, final int amount) {
            final JLabel label = new JLabel();
            final EtchedBorder selectedBorder = new EtchedBorder();
            final EmptyBorder unselectedBorder = new EmptyBorder(selectedBorder.getBorderInsets(new JLabel()));
            label.setBorder(unselectedBorder);
            label.setForeground(this.foreground);
            label.addMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent e) {
                    DatePopup.this.calendar.add(field, amount);
                    DatePopup.this.updatePopup();
                }

                public void mouseEntered(MouseEvent e) {
                    label.setBorder(selectedBorder);
                }

                public void mouseExited(MouseEvent e) {
                    label.setBorder(unselectedBorder);
                }
            });
            return label;
        }

        protected void initializePopup() {
            JPanel header = new JPanel();
            header.setLayout(new BoxLayout(header, 0));
            header.setBackground(this.background);
            header.setOpaque(true);
            JLabel label = this.createUpdateButton(1, -1);
            label.setText("<<");
            label.setToolTipText(resource.getString("datecombobox.prevyear"));
            header.add(Box.createHorizontalStrut(12));
            header.add(label);
            header.add(Box.createHorizontalStrut(12));
            label = this.createUpdateButton(2, -1);
            label.setText("<");
            label.setToolTipText(resource.getString("datecombobox.prevmonth"));
            header.add(label);
            this.monthLabel = new JLabel("", 0);
            this.monthLabel.setForeground(this.foreground);
            header.add(Box.createHorizontalGlue());
            header.add(this.monthLabel);
            header.add(Box.createHorizontalGlue());
            label = this.createUpdateButton(2, 1);
            label.setText(">");
            label.setToolTipText(resource.getString("datecombobox.nextmonth"));
            header.add(label);
            label = this.createUpdateButton(1, 1);
            label.setText(">>");
            label.setToolTipText(resource.getString("datecombobox.nextyear"));
            header.add(Box.createHorizontalStrut(12));
            header.add(label);
            header.add(Box.createHorizontalStrut(12));
            this.popup = new JPopupMenu();
            this.popup.setBorder(BorderFactory.createLineBorder(Color.black));
            this.popup.setLayout(new BorderLayout());
            this.popup.setBackground(this.background);
            this.popup.addPopupMenuListener(this);
            this.popup.add("North", header);
        }

        protected void updatePopup() {
            int i;
            this.monthLabel.setText(this.monthFormat.format(this.calendar.getTime()));
            if (this.days != null) {
                this.popup.remove(this.days);
            }
            this.days = new JPanel(new GridLayout(0, 7));
            this.days.setBackground(this.background);
            this.days.setOpaque(true);
            Calendar setupCalendar = (Calendar)this.calendar.clone();
            setupCalendar.set(7, setupCalendar.getFirstDayOfWeek());
            for (int i2 = 0; i2 < 7; ++i2) {
                int dayInt = setupCalendar.get(7);
                JLabel label = new JLabel();
                label.setHorizontalAlignment(0);
                label.setForeground(this.foreground);
                if (dayInt == 1) {
                    label.setText(resource.getString("datecombobox.sun"));
                } else if (dayInt == 2) {
                    label.setText(resource.getString("datecombobox.mon"));
                } else if (dayInt == 3) {
                    label.setText(resource.getString("datecombobox.tue"));
                } else if (dayInt == 4) {
                    label.setText(resource.getString("datecombobox.wed"));
                } else if (dayInt == 5) {
                    label.setText(resource.getString("datecombobox.thu"));
                } else if (dayInt == 6) {
                    label.setText(resource.getString("datecombobox.fri"));
                } else if (dayInt == 7) {
                    label.setText(resource.getString("datecombobox.sat"));
                }
                this.days.add(label);
                setupCalendar.roll(7, true);
            }
            setupCalendar = (Calendar)this.calendar.clone();
            setupCalendar.set(5, 1);
            int first = setupCalendar.get(7);
            for (i = 0; i < first - 1; ++i) {
                this.days.add(new JLabel(""));
            }
            i = 1;
            while (i <= setupCalendar.getActualMaximum(5)) {
                final int day = i++;
                final JLabel label = new JLabel(String.valueOf(day));
                label.setHorizontalAlignment(0);
                label.setForeground(this.foreground);
                label.addMouseListener(new MouseListener(){

                    public void mousePressed(MouseEvent e) {
                    }

                    public void mouseClicked(MouseEvent e) {
                    }

                    public void mouseReleased(MouseEvent e) {
                        label.setOpaque(false);
                        label.setBackground(DatePopup.this.background);
                        label.setForeground(DatePopup.this.foreground);
                        DatePopup.this.calendar.set(5, day);
                        DatePopup.this.comboBox.setSelectedItem(DateComboBox.this.dateFormat.format(DatePopup.this.calendar.getTime()));
                        DatePopup.this.comboBox.requestFocus();
                    }

                    public void mouseEntered(MouseEvent e) {
                        label.setOpaque(true);
                        label.setBackground(DatePopup.this.selectedBackground);
                        label.setForeground(DatePopup.this.selectedForeground);
                    }

                    public void mouseExited(MouseEvent e) {
                        label.setOpaque(false);
                        label.setBackground(DatePopup.this.background);
                        label.setForeground(DatePopup.this.foreground);
                    }
                });
                this.days.add(label);
            }
            this.popup.add("Center", this.days);
            this.popup.pack();
        }
    }

    class MotifDateComboBoxUI
    extends MotifComboBoxUI {
        MotifDateComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            return new DatePopup(this.comboBox);
        }
    }

    class WindowsDateComboBoxUI
    extends WindowsComboBoxUI {
        WindowsDateComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            return new DatePopup(this.comboBox);
        }
    }

    class MetalDateComboBoxUI
    extends MetalComboBoxUI {
        MetalDateComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            return new DatePopup(this.comboBox);
        }
    }
}

