/*
 * Decompiled with CFR 0.152.
 */
package hero.client.grapheditor;

import hero.client.grapheditor.WFGraph;
import hero.client.grapheditor.WFManager;
import hero.client.grapheditor.WFMenuBar;
import hero.client.grapheditor.WFPersistence;
import hero.client.grapheditor.WFToolBar;
import hero.client.grapheditor.WFToolBar2;
import hero.util.BonitaClient;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;

public class Frame
extends JFrame {
    static ResourceBundle resource = ResourceBundle.getBundle("resources.Traduction");
    private String project = null;
    WFManager manager;
    WFPersistence persistence;
    WFGraph wfGraph;
    JLabel statusBar = new JLabel(resource.getString("frame.workeditor"));
    JScrollPane scrollPane = null;
    public static final String imageBase = "images/";
    private final String CLOSE = "close";
    private static Frame frame;

    public Frame() {
        frame = this;
        frame.setBackground(new Color(177, 177, 251));
    }

    public Frame(String managerProject, BonitaClient soapclient, boolean subProcess) throws Exception {
        frame = this;
        URL iconUrl = Thread.currentThread().getContextClassLoader().getResource("images/icon.png");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(iconUrl));
        this.persistence = new WFPersistence(managerProject, soapclient);
        if (subProcess) {
            this.persistence.permission = false;
        }
        this.manager = new WFManager(this, this.persistence);
        this.getContentPane().removeAll();
        this.getContentPane().setBackground(new Color(177, 177, 251));
        WFMenuBar menuBar = new WFMenuBar(this, this.manager);
        menuBar.setBackground(new Color(153, 153, 255));
        this.setJMenuBar(menuBar);
        this.project = managerProject;
        this.wfGraph = new WFGraph(this.manager, this.persistence);
        this.wfGraph.setEditable(false);
        this.wfGraph.setBackground(new Color(177, 177, 251));
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this.wfGraph));
        ToolTipManager.sharedInstance().setInitialDelay(100);
        this.scrollPane = new JScrollPane((Component)((Object)this.wfGraph));
        this.scrollPane.setBackground(new Color(177, 177, 251));
        this.manager.setWFGraph(this.wfGraph);
        WFToolBar toolBar = new WFToolBar(this, this.manager);
        toolBar.setBackground(new Color(177, 177, 251));
        toolBar.setFloatable(false);
        WFToolBar2 toolBar2 = new WFToolBar2(this, this.manager);
        toolBar2.setBackground(new Color(177, 177, 251));
        toolBar2.setFloatable(false);
        JPanel toolPanel = new JPanel();
        toolPanel.setLayout(new BorderLayout());
        toolPanel.setBackground(new Color(177, 177, 251));
        toolPanel.add((Component)toolBar2, "Center");
        toolPanel.add((Component)this.statusBar, "South");
        this.statusBar.setBorder(BorderFactory.createLoweredBevelBorder());
        this.statusBar.setBackground(new Color(177, 177, 251));
        this.getContentPane().add((Component)toolBar, "North");
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.getContentPane().add((Component)toolPanel, "South");
        this.pack();
        frame.setSize(600, 600);
        frame.setBackground(new Color(177, 177, 251));
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screen.width - this.getWidth()) / 2, (screen.height - this.getHeight()) / 2);
        this.setTitle(resource.getString("frame.grapheditor"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Frame.this.setPropertyChange();
                Frame.this.manager.exit();
            }

            public void windowActivated(WindowEvent e) {
                try {
                    if (!Frame.this.persistence.soapclient.getProjectName().equals(Frame.this.persistence.getProjectName())) {
                        Frame.this.persistence.openProject(Frame.this.persistence.getProjectName());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.manager.openProject(managerProject);
    }

    public String getProject() {
        return this.project;
    }

    public void setPropertyChange() {
        this.firePropertyChange("close", "", frame.getProject());
    }

    public void setStatusBar(String info) {
        this.statusBar.setText(info);
        this.statusBar.setBackground(new Color(177, 177, 251));
    }

    public WFGraph getWorkflowGraph() {
        return this.wfGraph;
    }

    public static Frame getFrame() {
        return frame;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }
}

