/*
 * Decompiled with CFR 0.152.
 */
package hero.client.grapheditor;

import com.jgraph.JGraph;
import com.jgraph.graph.CellView;
import com.jgraph.graph.DefaultGraphModel;
import com.jgraph.graph.GraphModel;
import hero.client.grapheditor.Queue;
import hero.client.grapheditor.WFGraph;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.Set;

public class Spring {
    static ResourceBundle resource = ResourceBundle.getBundle("resources.Traduction");
    protected WFGraph graph;
    private CellView[] vertices = null;
    private static Rectangle rect;
    private static double xmax;
    private static double xmin;
    private static double ymax;
    private static double ymin;
    private static int[] orderedList;
    private static int N;
    private static int EDGES;
    private static long[][] D;
    private static double[][] K;
    private static double Ko;
    private static double[][] L;
    private static double epsilon;
    private static double[] delta;
    private static int MAX_TIMES_REPOSITIONED;
    private static int numTimesRepositioned;
    private static int[] NUM_TIMES_MOVED;
    private static int HY_SIZE;
    private static int HY_PERCENTAGE;
    private static double E;
    private static double[] E_HY;
    private static int COUNTER;
    private static int mv;
    private static double partial_x;
    private static double partial_y;
    private static double partial_xx;
    private static double partial_xy;
    private static double partial_yx;
    private static double partial_yy;
    private static boolean connected;
    private int DEBUG = 3;

    public Spring() {
        this(3);
    }

    public Spring(int debug) {
        this.DEBUG = debug;
    }

    public String compute(WFGraph G) {
        this.graph = G;
        int maxTimes = 0;
        rect = G.fromScreen(G.getBounds());
        this.Initialize(G);
        while (this.DEBUG-- > 0) {
            int v;
            int index;
            this.CheckPositions(G);
            double maxDel = 0.0;
            for (index = 0; index < N; ++index) {
                v = index;
                Spring.delta[v] = Math.sqrt(this.findDelta2(G, v));
                if (delta[v] > maxDel) {
                    maxDel = delta[v];
                }
                if (NUM_TIMES_MOVED[v] <= maxTimes) continue;
                maxTimes = NUM_TIMES_MOVED[v];
            }
            mv = 0;
            int mvi = 0;
            double maxValue = 0.0;
            v = mv;
            for (index = 1; index < N; ++index) {
                v = index;
                double tempValue = maxTimes != 0 ? Spring.TempFunction(delta[v] / maxDel, 1 - NUM_TIMES_MOVED[v]) : delta[v] / maxDel;
                if (!(tempValue > maxValue)) continue;
                mvi = mv = v;
                maxValue = tempValue;
            }
            if (delta[mvi] < epsilon) break;
            if (COUNTER > HY_SIZE) {
                double d;
                E = this.findE(G);
                if (E_HY[COUNTER % HY_SIZE] * (double)HY_PERCENTAGE / 100.0 > d) break;
            }
            Spring.E_HY[Spring.COUNTER % Spring.HY_SIZE] = E;
            for (numTimesRepositioned = 0; delta[mvi] > epsilon && numTimesRepositioned < MAX_TIMES_REPOSITIONED; ++numTimesRepositioned) {
                this.MoveToNewPosition2(G);
                Spring.delta[mvi] = Math.sqrt(this.findDelta2(G, mv));
            }
            int n = mvi;
            NUM_TIMES_MOVED[n] = NUM_TIMES_MOVED[n] + 1;
        }
        return null;
    }

    private void Initialize(JGraph G) {
        EDGES = 0;
        Object[] cells = G.getRoots();
        LinkedList<Object> list = new LinkedList<Object>();
        for (int idx = 0; idx < cells.length; ++idx) {
            if (this.graph.isVertex(cells[idx])) {
                list.add(cells[idx]);
                continue;
            }
            if (!this.graph.isEdge(cells[idx])) continue;
            ++EDGES;
        }
        this.vertices = this.graph.getView().getMapping(list.toArray());
        N = this.vertices.length;
        this.makeOrderedList(G);
        NUM_TIMES_MOVED = new int[N];
        for (int i = 0; i < N; ++i) {
            Spring.NUM_TIMES_MOVED[i] = 0;
        }
        EDGES = 0;
        epsilon = 0.5 * (double)(N + EDGES);
        this.findDistances(G);
        this.find_l_and_k(G);
        delta = new double[N];
        E_HY = new double[HY_SIZE];
        xmin = Spring.rect.x;
        xmax = xmin + (double)Spring.rect.width;
        ymin = Spring.rect.y;
        ymax = ymin + (double)Spring.rect.height;
    }

    private void findDistances(JGraph G) {
        int j;
        int i;
        Queue queue = new Queue();
        int vertexCount = this.vertices.length;
        boolean[] done = new boolean[vertexCount];
        D = new long[vertexCount][vertexCount];
        for (i = 0; i < vertexCount; ++i) {
            for (j = i; j < vertexCount; ++j) {
                Spring.D[i][j] = 0L;
                Spring.D[j][i] = 0L;
            }
        }
        for (int index = 0; index < vertexCount; ++index) {
            int v;
            for (i = 0; i < vertexCount; ++i) {
                done[i] = false;
            }
            done[index] = true;
            CellView[] adj = this.getVerticesFor(G, index);
            for (int idx2 = 0; idx2 < adj.length; ++idx2) {
                v = this.getIndexOf(adj[idx2]);
                queue.push(v);
                queue.push(index);
                done[v] = true;
            }
            while (!queue.isEmpty()) {
                v = queue.pop();
                int p = queue.pop();
                Spring.D[index][v] = D[p][index] + 1L;
                Spring.D[v][index] = D[index][v];
                for (int idx3 = 0; idx3 < vertexCount; ++idx3) {
                    CellView[] adj2 = this.getVerticesFor(G, idx3);
                    for (int idx2 = 0; idx2 < adj2.length; ++idx2) {
                        int u = this.getIndexOf(adj2[idx2]);
                        if (done[u]) continue;
                        queue.push(u);
                        queue.push(v);
                        done[u] = true;
                    }
                }
            }
        }
        connected = true;
        for (i = 0; i < N; ++i) {
            for (j = i + 1; j < N; ++j) {
                if (D[i][j] != 0L) continue;
                connected = false;
                Spring.D[i][j] = Long.MAX_VALUE;
                Spring.D[j][i] = Long.MAX_VALUE;
            }
        }
    }

    public int getIndexOf(CellView v) {
        for (int i = 0; i < this.vertices.length; ++i) {
            if (this.vertices[i] != v) continue;
            return i;
        }
        return 0;
    }

    public CellView[] getVerticesFor(JGraph G, int index) {
        Set set = DefaultGraphModel.getEdges((GraphModel)G.getModel(), (Object[])new Object[]{this.vertices[index].getCell()});
        Object[] obj = set.toArray();
        if (obj != null) {
            CellView[] adj = new CellView[obj.length];
            for (int i = 0; i < obj.length; ++i) {
                adj[i] = this.graph.getView().getMapping(this.graph.getNeighbour(obj[i], this.vertices[index]), false);
            }
            return adj;
        }
        return new CellView[0];
    }

    private void makeOrderedList(JGraph G) {
        orderedList = new int[this.vertices.length];
        for (int index = 0; index < this.vertices.length; ++index) {
            Spring.orderedList[index] = index;
        }
    }

    private static int enume(int Index) {
        int i = 0;
        while (orderedList[i] != Index) {
            ++i;
        }
        return i;
    }

    private void find_l_and_k(JGraph G) {
        int j;
        int i;
        if (D.length == 0) {
            return;
        }
        Ko = 0.0;
        int vertexCount = this.vertices.length;
        L = new double[vertexCount][vertexCount];
        K = new double[vertexCount][vertexCount];
        long diam = D[0][0];
        for (i = 0; i < vertexCount; ++i) {
            for (j = i + 1; j < vertexCount; ++j) {
                if (diam < D[i][j] && D[i][j] < Long.MAX_VALUE) {
                    diam = D[i][j];
                }
                Ko += (double)D[i][j];
            }
        }
        Ko /= (double)vertexCount;
        for (i = 0; i < vertexCount; ++i) {
            for (j = i + 1; j < vertexCount; ++j) {
                double Lo = Math.sqrt(Spring.rect.width * Spring.rect.height / 4) / (double)diam;
                Spring.L[i][j] = Lo * (double)D[i][j];
                Spring.L[j][i] = L[i][j];
                Spring.K[i][j] = D[i][j] < Long.MAX_VALUE ? Ko * Ko / (double)(D[i][j] * D[i][j]) : 0.0;
                Spring.K[j][i] = K[i][j];
            }
        }
    }

    private double findDelta2(JGraph G, int v) {
        this.findPartials(G, v);
        double delta = partial_x * partial_x + partial_y * partial_y;
        return delta;
    }

    private void findPartials(JGraph G, int v) {
        int vi = v;
        partial_x = 0.0;
        partial_y = 0.0;
        partial_xx = 0.0;
        partial_xy = 0.0;
        partial_yx = 0.0;
        partial_yy = 0.0;
        for (int u = 0; u < N; ++u) {
            if (v == u) continue;
            int ui = u;
            double dx = this.vertices[v].getBounds().x - this.vertices[u].getBounds().x;
            double dy = this.vertices[v].getBounds().y - this.vertices[u].getBounds().y;
            double dd = Math.sqrt(dx * dx + dy * dy);
            partial_x += K[vi][ui] * (dx - L[vi][ui] * dx / dd);
            partial_y += K[vi][ui] * (dy - L[vi][ui] * dy / dd);
            partial_xx += K[vi][ui] * (1.0 - L[vi][ui] * dy * dy / (dd * dd * dd));
            partial_xy += K[vi][ui] * (L[vi][ui] * dx * dy / (dd * dd * dd));
            partial_yx += K[vi][ui] * (L[vi][ui] * dy * dx / (dd * dd * dd));
            partial_yy += K[vi][ui] * (1.0 - L[vi][ui] * dx * dx / (dd * dd * dd));
        }
    }

    private static double TempFunction(double del, double times) {
        return 0.5 * del + 0.5 * times;
    }

    private double findE(JGraph G) {
        double total = 0.0;
        for (int v = 0; v < N; ++v) {
            int vi = v;
            for (int u = v; u < N; ++u) {
                int ui = u;
                double dx = this.vertices[v].getBounds().x - this.vertices[u].getBounds().x;
                double dy = this.vertices[v].getBounds().y - this.vertices[u].getBounds().y;
                double dd = Math.sqrt(dx * dx + dy * dy);
                double dif = dd - L[vi][ui];
                total += K[vi][ui] * dif * dif;
            }
        }
        return total / 2.0;
    }

    private void MoveToNewPosition(JGraph G) {
        double xpos = this.vertices[Spring.mv].getBounds().x;
        double ypos = this.vertices[Spring.mv].getBounds().y;
        int mvi = mv;
        this.findPartials(G, mv);
        double A = partial_xx;
        double B = partial_xy;
        double C = -partial_x;
        double D = partial_yx;
        double E = partial_yy;
        double F = -partial_y;
        double dy = (A * F - C * D) / (A * E - B * D);
        double dx = (C * E - B * F) / (A * E - B * D);
        while (dy != 0.0 && dx != 0.0) {
            double yfrac;
            double xfrac = xpos + dx < xmin ? (xpos - xmin) / dx : (xpos + dx > xmax ? (xmax - xpos) / dx : 1.0);
            if (xfrac < (yfrac = ypos + dy < ymin ? (ypos - ymin) / dy : (ypos + dy > ymax ? (ymax - ypos) / dy : 1.0))) {
                xpos += dx * xfrac;
                dx *= xfrac - 1.0;
                ypos += dy * xfrac;
                dy *= 1.0 - xfrac;
                continue;
            }
            if (yfrac < xfrac) {
                ypos += dy * yfrac;
                dy *= yfrac - 1.0;
                xpos += dx * yfrac;
                dx *= 1.0 - yfrac;
                continue;
            }
            xpos += dx;
            dx = 0.0;
            ypos += dy;
            dy = 0.0;
        }
        if (xpos < 0.0) {
            xpos = 0.0;
        }
        if (ypos < 0.0) {
            ypos = 0.0;
        }
        Point p = G.snap(new Point((int)xpos, (int)ypos));
        this.vertices[mv].getBounds().setLocation(p);
        this.vertices[mv].getBounds().setLocation(new Point((int)xpos, (int)ypos));
    }

    private void MoveToNewPosition1(JGraph G) {
        double xpos = this.vertices[Spring.mv].getBounds().x;
        double ypos = this.vertices[Spring.mv].getBounds().y;
        int mvi = mv;
        this.findPartials(G, mv);
        double A = partial_xx;
        double B = partial_xy;
        double C = -partial_x;
        double D = partial_yx;
        double E = partial_yy;
        double F = -partial_y;
        double dy = (A * F - C * D) / (A * E - B * D);
        double dx = (C * E - B * F) / (A * E - B * D);
        double xfrac = xpos + dx < xmin ? (xpos - xmin) / dx : (xpos + dx > xmax ? (xmax - xpos) / dx : 1.0);
        double yfrac = ypos + dy < ymin ? (ypos - ymin) / dy : (ypos + dy > ymax ? (ymax - ypos) / dy : 1.0);
        if (xfrac < yfrac) {
            yfrac = xfrac;
        } else if (yfrac < xfrac) {
            xfrac = yfrac;
        }
        double x = xpos + dx;
        double y = ypos + dy;
        xpos += dx * xfrac;
        dx = 0.0;
        ypos += dy * yfrac;
        dy = 0.0;
        if (xpos < 0.0) {
            xpos = 0.0;
        }
        if (ypos < 0.0) {
            ypos = 0.0;
        }
        Point p = G.snap(new Point((int)xpos, (int)ypos));
        this.vertices[mv].getBounds().setLocation(p);
    }

    private void MoveToNewPosition2(JGraph G) {
        double xpos = this.vertices[Spring.mv].getBounds().x;
        double ypos = this.vertices[Spring.mv].getBounds().y;
        int mvi = mv;
        this.findPartials(G, mv);
        double A = partial_xx;
        double B = partial_xy;
        double C = -partial_x;
        double D = partial_yx;
        double E = partial_yy;
        double F = -partial_y;
        double dy = (A * F - C * D) / (A * E - B * D);
        double dx = (C * E - B * F) / (A * E - B * D);
        if (xpos < 0.0) {
            xpos = 0.0;
        }
        if (ypos < 0.0) {
            ypos = 0.0;
        }
        Point p = G.snap(new Point((int)(xpos + dx), (int)(ypos + dy)));
        this.vertices[mv].getBounds().setLocation(p);
    }

    private void CheckPositions(JGraph G) {
        boolean OK = false;
        OK = true;
        for (int v = 0; v < N; ++v) {
            for (int u = v; u < N; ++u) {
                if (this.vertices[v].getBounds().x != this.vertices[u].getBounds().x || this.vertices[v].getBounds().y != this.vertices[u].getBounds().y) continue;
                int vi = v;
                int ui = u;
                double rand = (1.4 * Math.random() - 1.0) * L[vi][ui];
                Point tmp = new Point(this.vertices[u].getBounds().x + (int)rand, this.vertices[u].getBounds().y);
                this.vertices[u].getBounds().setLocation(tmp);
                rand = (1.4 * Math.random() - 1.0) * L[vi][ui];
                tmp = new Point(this.vertices[u].getBounds().x + (int)rand, this.vertices[u].getBounds().y);
                this.vertices[u].getBounds().setLocation(tmp);
                OK = false;
            }
        }
    }

    static {
        MAX_TIMES_REPOSITIONED = 10;
        numTimesRepositioned = 0;
        HY_SIZE = 10;
        HY_PERCENTAGE = 5;
        COUNTER = 0;
        mv = -1;
    }
}

