/*
 * Decompiled with CFR 0.152.
 */
package hero.client.grapheditor;

import hero.client.grapheditor.Frame;
import hero.client.grapheditor.WFManager;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class WFMenuBar
extends JMenuBar {
    static ResourceBundle resource = ResourceBundle.getBundle("resources.Traduction");
    Frame frame;

    public WFMenuBar(Frame frame, final WFManager manager) {
        this.frame = frame;
        boolean buttonState = manager.getPersistence().hasPermission();
        ClassLoader cl = frame.getClass().getClassLoader();
        JMenu menu = new JMenu(resource.getString("wfmenubar.file"));
        menu.setBackground(new Color(153, 153, 255));
        this.add(menu);
        JMenuItem mi = new JMenuItem(new ImageIcon(cl.getResource("images/new.png")));
        mi.setText(resource.getString("wfmenubar.new"));
        mi.setBackground(new Color(153, 153, 255));
        mi.setAccelerator(KeyStroke.getKeyStroke(78, 8));
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                manager.newProject();
            }
        });
        menu.add(mi);
        mi = new JMenuItem(new ImageIcon(cl.getResource("images/clone.gif")));
        mi.setText(resource.getString("wfmenubar.clone"));
        mi.setBackground(new Color(153, 153, 255));
        mi.setAccelerator(KeyStroke.getKeyStroke(68, 8));
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                manager.cloneProject();
            }
        });
        menu.add(mi);
        mi = new JMenuItem(new ImageIcon(cl.getResource("images/open.png")));
        mi.setText(resource.getString("wfmenubar.open"));
        mi.setBackground(new Color(153, 153, 255));
        mi.setAccelerator(KeyStroke.getKeyStroke(79, 8));
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                manager.openProject();
            }
        });
        menu.add(mi);
        menu.addSeparator();
        JMenu export = new JMenu(resource.getString("wfmenubar.export"));
        export.setBackground(new Color(153, 153, 255));
        export.setIcon(new ImageIcon(cl.getResource("images/export.gif")));
        String[] s = ImageIO.getWriterFormatNames();
        for (int i = 0; i < s.length; ++i) {
            final String format = s[i];
            if (!format.toUpperCase().equals(format)) continue;
            AbstractAction a = new AbstractAction(format){

                public void actionPerformed(ActionEvent e) {
                    block6: {
                        String name = WFMenuBar.this.saveDialog(resource.getString("wfmenubar.saveas") + format.toUpperCase());
                        if (manager.getGraph().getModel().getRootCount() > 0) {
                            if (name != null) {
                                try {
                                    BufferedImage im = manager.getGraphImage();
                                    if (im != null) {
                                        File f = new File(name);
                                        ImageIO.write((RenderedImage)im, format, f);
                                        JOptionPane.showMessageDialog(null, resource.getString("wfmenubar.successexport"));
                                        break block6;
                                    }
                                    WFMenuBar.this.error("");
                                }
                                catch (IOException ex) {
                                    WFMenuBar.this.error(ex.toString());
                                }
                            }
                        } else {
                            WFMenuBar.this.error("");
                        }
                    }
                }
            };
            JMenuItem imageFormat = new JMenuItem(a);
            imageFormat.setBackground(new Color(153, 153, 255));
            export.add(imageFormat);
        }
        menu.addSeparator();
        AbstractAction b = new AbstractAction("VRML"){

            public void actionPerformed(ActionEvent e) {
                block6: {
                    String name = WFMenuBar.this.saveDialog(resource.getString("wfmenubar.saveasvrm"));
                    if (manager.getGraph().getModel().getRootCount() > 0) {
                        if (name != null) {
                            try {
                                String data = manager.getGraphVRML();
                                if (data != null) {
                                    File f = new File(name + ".wrl");
                                    FileOutputStream fout = new FileOutputStream(f);
                                    fout.write(data.getBytes());
                                    fout.close();
                                    JOptionPane.showMessageDialog(null, resource.getString("wfmenubar.successexport"));
                                    break block6;
                                }
                                WFMenuBar.this.error("");
                            }
                            catch (IOException ex) {
                                WFMenuBar.this.error(ex.toString());
                            }
                        }
                    } else {
                        WFMenuBar.this.error("");
                    }
                }
            }
        };
        JMenuItem vrmlFormat = new JMenuItem(b);
        vrmlFormat.setBackground(new Color(153, 153, 255));
        export.add(vrmlFormat);
        menu.add(export);
        menu.addSeparator();
        mi = new JMenuItem(resource.getString("wfmenubar.exit"));
        mi.setBackground(new Color(153, 153, 255));
        mi.setIcon(new ImageIcon(cl.getResource("images/exit.png")));
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                manager.exit();
            }
        });
        menu.add(mi);
        menu = new JMenu(resource.getString("wfmenubar.edit"));
        menu.setBackground(new Color(153, 153, 255));
        this.add(menu);
        mi = new JMenuItem(resource.getString("wfmenubar.copy"));
        mi.setBackground(new Color(153, 153, 255));
        mi.setIcon(new ImageIcon(cl.getResource("images/Copy.gif")));
        mi.setEnabled(buttonState);
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                manager.copySelection();
            }
        });
        menu.add(mi);
        mi = new JMenuItem(resource.getString("wfmenubar.paste"));
        mi.setBackground(new Color(153, 153, 255));
        mi.setIcon(new ImageIcon(cl.getResource("images/Paste.gif")));
        mi.setEnabled(buttonState);
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                manager.pasteSelection();
            }
        });
        menu.add(mi);
        mi = new JMenuItem(resource.getString("wfmenubar.delete"));
        mi.setBackground(new Color(153, 153, 255));
        mi.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        mi.setIcon(new ImageIcon(cl.getResource("images/Delete.gif")));
        mi.setEnabled(buttonState);
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                manager.deleteSelection();
            }
        });
        menu.add(mi);
        menu.addSeparator();
        mi = new JMenuItem(resource.getString("wfmenubar.selectall"), 65);
        mi.setBackground(new Color(153, 153, 255));
        mi.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                manager.selectAll();
            }
        });
        menu.add(mi);
        mi = new JMenuItem(resource.getString("wfmenubar.deselectall"), 68);
        mi.setBackground(new Color(153, 153, 255));
        mi.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                manager.clearSelection();
            }
        });
        menu.add(mi);
        menu = new JMenu(resource.getString("wfmenubar.format"));
        menu.setBackground(new Color(153, 153, 255));
        this.add(menu);
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(resource.getString("wfmenubar.autolay"));
        menu.add(menuItem);
        menu.setBackground(new Color(153, 153, 255));
        menuItem.setState(true);
        menuItem.setBackground(new Color(153, 153, 255));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                manager.automaticLayout();
            }
        });
        menu.add(menuItem);
        mi = new JMenuItem(resource.getString("wfmenubar.circlelay"));
        mi.setBackground(new Color(153, 153, 255));
        mi.setIcon(new ImageIcon(cl.getResource("images/Arrange.gif")));
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                manager.setLayout1();
            }
        });
        menu.add(mi);
        mi = new JMenuItem(resource.getString("wfmenubar.expandlay"));
        mi.setBackground(new Color(153, 153, 255));
        mi.setIcon(new ImageIcon(cl.getResource("images/Layout.gif")));
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                manager.setLayout2();
            }
        });
        menu.add(mi);
        menu = new JMenu(resource.getString("wfmenubar.user"));
        menu.setEnabled(buttonState);
        menu.setBackground(new Color(153, 153, 255));
        this.add(menu);
        mi = menu.add(new JMenuItem(resource.getString("wfmenubar.newuser")));
        mi.setBackground(new Color(153, 153, 255));
        mi.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        mi.setIcon(new ImageIcon(cl.getResource("images/User.gif")));
        mi.setEnabled(buttonState);
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                manager.newUser();
            }
        });
        menu.add(mi);
        mi = menu.add(new JMenuItem(resource.getString("wfmenubar.projuser")));
        mi.setBackground(new Color(153, 153, 255));
        mi.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        mi.setIcon(new ImageIcon(cl.getResource("images/User2.gif")));
        mi.setEnabled(buttonState);
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                manager.usersInProject();
            }
        });
        menu.add(mi);
        menu.addSeparator();
        mi = menu.add(new JMenuItem(resource.getString("wfmenubar.addrole")));
        mi.setBackground(new Color(153, 153, 255));
        mi.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        mi.setIcon(new ImageIcon(cl.getResource("images/Role2.gif")));
        mi.setEnabled(buttonState);
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                manager.newRole();
            }
        });
        menu.add(mi);
        mi = menu.add(new JMenuItem(resource.getString("wfmenubar.addrole2")));
        mi.setBackground(new Color(153, 153, 255));
        mi.setAccelerator(KeyStroke.getKeyStroke(74, 2));
        mi.setIcon(new ImageIcon(cl.getResource("images/Role.gif")));
        mi.setEnabled(buttonState);
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                manager.addUserToRole();
            }
        });
        menu.add(mi);
        mi = menu.add(new JMenuItem(resource.getString("wfmenubar.addmapper")));
        mi.setBackground(new Color(153, 153, 255));
        mi.setIcon(new ImageIcon(cl.getResource("images/rolemapper.gif")));
        mi.setEnabled(buttonState);
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                manager.addMapperToRole();
            }
        });
        menu.add(mi);
        menu = new JMenu(resource.getString("wfmenubar.zoom"));
        menu.setBackground(new Color(153, 153, 255));
        this.add(menu);
        mi = new JMenuItem(resource.getString("wfmenubar.fit"));
        mi.setBackground(new Color(153, 153, 255));
        mi.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                manager.fitWindow();
            }
        });
        menu.add(mi);
        mi = new JMenuItem(resource.getString("wfmenubar.zoom100"));
        mi.setBackground(new Color(153, 153, 255));
        mi.setIcon(new ImageIcon(cl.getResource("images/Zoom100.gif")));
        mi.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                manager.zoom(100);
            }
        });
        menu.add(mi);
        mi = new JMenuItem(resource.getString("wfmenubar.zoomin"));
        mi.setBackground(new Color(153, 153, 255));
        mi.setIcon(new ImageIcon(cl.getResource("images/ZoomIn.gif")));
        mi.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                manager.zoomIn();
            }
        });
        menu.add(mi);
        mi = new JMenuItem(resource.getString("wfmenubar.zoomout"));
        mi.setBackground(new Color(153, 153, 255));
        mi.setIcon(new ImageIcon(cl.getResource("images/ZoomOut.gif")));
        mi.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                manager.zoomOut();
            }
        });
        menu.add(mi);
        menu = new JMenu(resource.getString("wfmenubar.info"));
        menu.setBackground(new Color(153, 153, 255));
        this.add(menu);
        mi = new JMenuItem(resource.getString("wfmenubar.about"));
        mi.setBackground(new Color(153, 153, 255));
        mi.setIcon(new ImageIcon(cl.getResource("images/toolbar-info.png")));
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                manager.Info();
            }
        });
        menu.add(mi);
    }

    public void error(String message) {
        JOptionPane.showMessageDialog(this, message, resource.getString("wfmenubar.info"), 0);
    }

    public String saveDialog(String message) {
        return this.dialog(message, 1);
    }

    public String loadDialog(String message) {
        return this.dialog(message, 0);
    }

    protected String dialog(String message, int mode) {
        FileDialog f = new FileDialog((java.awt.Frame)this.frame, message, mode);
        f.show();
        if (f.getFile() != null) {
            return f.getDirectory() + f.getFile();
        }
        return null;
    }
}

