/*
 * Decompiled with CFR 0.152.
 */
package hero.client.grapheditor;

import hero.net.ProjectSession.StrutsNodeValue;
import hero.util.BonitaClient;
import hero.util.ProjectNodes;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class WFPersistence {
    private String projectName;
    public boolean permission = false;
    private String endpoint = null;
    private String url = null;
    private String userPassword = null;
    public BonitaClient soapclient;
    private ProjectNodes pn = new ProjectNodes();
    public static final String imageBase = "images/";
    public static final ImageIcon icon = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("images/icon.png"));

    public WFPersistence(String managerProject, BonitaClient soapclient) throws Exception {
        this.soapclient = soapclient;
        soapclient.openProject(managerProject);
        this.projectName = managerProject;
        this.permission = this.isInRole(this.getUser(), "admin");
    }

    public boolean openProject(String projectName) throws Exception {
        this.soapclient.openProject(projectName);
        this.projectName = projectName;
        this.setProjectNodes();
        return true;
    }

    public boolean createProject(String projectName) throws Exception {
        if (this.exists(projectName)) {
            return false;
        }
        this.soapclient.createProject(projectName);
        this.projectName = projectName;
        return true;
    }

    public boolean createModel(String modelName) throws Exception {
        if (this.exists(modelName)) {
            return false;
        }
        this.soapclient.createModel(modelName);
        this.projectName = modelName;
        return true;
    }

    public boolean cloneProject(String projectSrc, String projectDest) throws Exception {
        if (this.exists(projectDest)) {
            return false;
        }
        this.soapclient.cloneProject(projectSrc, projectDest);
        this.projectName = projectDest;
        return true;
    }

    public boolean cloneSubProject(String projectSrc, String projectDest) throws Exception {
        this.soapclient.cloneProject(projectSrc, projectDest);
        return true;
    }

    public String getUser() throws Exception {
        return this.soapclient.getUser();
    }

    public boolean hasPermission() {
        return this.permission;
    }

    private boolean exists(String name) throws Exception {
        Collection projects = this.soapclient.getProjects();
        for (String prj : projects) {
            if (!prj.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public Object[] getProjects() throws Exception {
        Collection projects = this.soapclient.getProjects();
        return projects.toArray();
    }

    public boolean containsNode(String value) throws Exception {
        Collection nodes = this.soapclient.getNodes();
        for (String nodeName : nodes) {
            if (!value.equalsIgnoreCase(nodeName)) continue;
            return true;
        }
        return false;
    }

    public boolean containsProject(String value) throws Exception {
        Collection projects = this.soapclient.getProjects();
        for (String projectName : projects) {
            if (!value.equalsIgnoreCase(projectName)) continue;
            return true;
        }
        return false;
    }

    public Object[] getNodes() throws Exception {
        Collection nodes = this.soapclient.getNodes();
        return nodes.toArray();
    }

    public Object[] getEdges() throws Exception {
        Collection nodes = this.soapclient.getEdges();
        return nodes.toArray();
    }

    public void addNode(String name, String type) throws Exception {
        this.soapclient.addNode(name, type);
    }

    public void addNodeSubProcess(String name, String projectName) throws Exception {
        this.soapclient.addNodeSubProcess(name, projectName);
    }

    public boolean deleteNode(String node) throws Exception {
        this.soapclient.deleteNode(node);
        return true;
    }

    public boolean deleteProject(String project) throws Exception {
        this.soapclient.deleteProject(project);
        return true;
    }

    public void deleteEdges(Object[] edges) throws Exception {
        this.soapclient.deleteEdges(edges);
    }

    public String addEdge(String src, String dest) throws Exception {
        return this.soapclient.addEdge(src, dest);
    }

    public String setEdgeCondition(String edgeName, String condition) throws Exception {
        this.soapclient.setEdgeCondition(edgeName, condition);
        return edgeName;
    }

    public String getEdgeCondition(String edgeName) throws Exception {
        return this.soapclient.getEdgeCondition(edgeName);
    }

    public String getState(String name) throws Exception {
        int state = this.soapclient.getNodeState(name);
        switch (state) {
            case 0: {
                return "Initial";
            }
            case 1: {
                return "READY";
            }
            case 3: {
                return "Anticipable";
            }
            case 5: {
                return "Anticipating";
            }
            case 6: {
                return "Executing";
            }
            case 7: {
                return "Executed";
            }
            case 10: {
                return "Terminated";
            }
            case 12: {
                return "Ant_suspended";
            }
            case 13: {
                return "Exec_suspended";
            }
        }
        return "";
    }

    public int getNodeState(String name) throws Exception {
        return this.soapclient.getNodeState(name);
    }

    public int getNodeType(String name) throws Exception {
        return this.soapclient.getNodeType(name);
    }

    public String getEdgeInNode(String name) throws Exception {
        return this.soapclient.getEdgeInNode(name);
    }

    public String getEdgeOutNode(String name) throws Exception {
        return this.soapclient.getEdgeOutNode(name);
    }

    public boolean isActive(String name) throws Exception {
        int state = this.soapclient.getNodeState(name);
        switch (state) {
            case 0: {
                return false;
            }
            case 1: {
                return false;
            }
            case 3: {
                return false;
            }
            case 5: {
                return true;
            }
            case 6: {
                return true;
            }
            case 7: {
                return false;
            }
            case 10: {
                return true;
            }
            case 12: {
                return false;
            }
            case 13: {
                return false;
            }
        }
        return false;
    }

    public String getType(String name) throws Exception {
        return this.soapclient.getType(name);
    }

    public String getRole(String name) throws Exception {
        return this.soapclient.getRole(name);
    }

    public void setNodeRole(String node, String newRole) throws Exception {
        this.soapclient.setNodeRole(node, newRole);
        this.setProjectNodeRole(node, newRole);
    }

    public String getDeadline(String name) throws Exception {
        this.setProjectNodes();
        return this.soapclient.getDeadline(name);
    }

    public void setDeadline(String name, long dl) throws Exception {
        this.soapclient.setDeadline(name, dl);
    }

    public String getNodeInterHookValue(String nodeName, String hookName) throws Exception {
        return this.soapclient.getNodeInterHookValue(nodeName, hookName);
    }

    public String getProjectInterHookValue(String hookName) throws Exception {
        return this.soapclient.getProjectInterHookValue(hookName);
    }

    public String getNodeDescription(String nodeName) throws Exception {
        return this.soapclient.getNodeDescription(nodeName);
    }

    public void setNodeDescription(String nodeName, String description) throws Exception {
        this.soapclient.setNodeDescription(nodeName, description);
        this.setProjectNodeDescription(nodeName, description);
    }

    public void setNodeTraditional(String nodeName) throws Exception {
        this.soapclient.setNodeTraditional(nodeName);
    }

    public void setNodeAnticipable(String nodeName) throws Exception {
        this.soapclient.setNodeAnticipable(nodeName);
    }

    public boolean getNodeAnticipable(String nodeName) throws Exception {
        return this.soapclient.getNodeAnticipable(nodeName);
    }

    public void setNodeInterHookValue(String nodeName, String hookName, String value) throws Exception {
        this.soapclient.setNodeInterHookValue(nodeName, hookName, value);
    }

    public void setProjectInterHookValue(String hookName, String value) throws Exception {
        this.soapclient.setProjectInterHookValue(hookName, value);
    }

    public Object[] getRoles() throws Exception {
        Collection roles = this.soapclient.getRoles();
        return roles.toArray();
    }

    public Object[] getUsersInProject() throws Exception {
        Collection users = this.soapclient.getUsersInProject();
        return users.toArray();
    }

    public Object[] getAllUsers() throws Exception {
        Collection users = this.soapclient.getAllUsers();
        return users.toArray();
    }

    public void addUser(String name) throws Exception {
        this.soapclient.addUser(name);
    }

    public void addRole(String name, String desc) throws Exception {
        this.soapclient.addRole(name, desc);
    }

    public void addNodeProperty(String nodeName, String key, String value, boolean propagate) throws Exception {
        this.soapclient.addNodeProperty(nodeName, key, value, propagate);
    }

    public void addProjectProperty(String key, String value) throws Exception {
        this.soapclient.addProjectProperty(key, value);
    }

    public void setUserRole(String name, String role) throws Exception {
        this.soapclient.setUserRole(name, role);
    }

    public void addRoleMapper(String role, String mapper, String type) throws Exception {
        this.soapclient.addRoleMapper(role, mapper, type);
    }

    public void addPerformerAssigment(String node, String performerName, String type, String property) throws Exception {
        this.soapclient.addNodePerformerAssigment(node, performerName, type, property);
    }

    public void setEditNode(String node, String role, String description, Date deadline) throws Exception {
        this.soapclient.setEditNode(node, role, description, deadline.getTime());
        this.setProjectNodeRole(node, role);
        this.setProjectNodeDescription(node, description);
        this.setProjectNodeDeadline(node, deadline.getTime());
    }

    public void addNodeInterHook(String nodeName, String hookName, String event, String value) throws Exception {
        this.soapclient.addNodeInterHook(nodeName, hookName, event, value);
    }

    public void addProjectInterHook(String hookName, String event, String value) throws Exception {
        this.soapclient.addProjectInterHook(hookName, event, value);
    }

    public void addIteration(String from, String to, String condition) throws Exception {
        this.soapclient.addIteration(from, to, condition);
    }

    public Collection getIterations() throws Exception {
        return this.soapclient.getIterations();
    }

    public boolean isInRole(String name, String role) throws Exception {
        return this.soapclient.isInRole(name, role);
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getStateString(int state) throws Exception {
        switch (state) {
            case 0: {
                return "INITIAL";
            }
            case 1: {
                return "READY";
            }
            case 3: {
                return "ANTICIPABLE";
            }
            case 5: {
                return "ANTICIPATING";
            }
            case 6: {
                return "EXECUTING";
            }
            case 7: {
                return "EXECUTED";
            }
            case 10: {
                return "TERMINATED";
            }
            case 12: {
                return "ANT_SUSPENDED";
            }
            case 13: {
                return "EXEC_SUSPENDED";
            }
        }
        return "";
    }

    public int getStateInt(String state) throws Exception {
        if (state.equals("INITIAL")) {
            return 0;
        }
        if (state.equals("READY")) {
            return 1;
        }
        if (state.equals("ANTICIPABLE")) {
            return 3;
        }
        if (state.equals("ANTICIPATING")) {
            return 5;
        }
        if (state.equals("EXECUTING")) {
            return 6;
        }
        if (state.equals("TERMINATED")) {
            return 10;
        }
        return -1;
    }

    public String getTypeString(int type) throws Exception {
        switch (type) {
            case 1: {
                return "And Join";
            }
            case 2: {
                return "Or Join";
            }
            case 3: {
                return "And Join Automatic";
            }
            case 4: {
                return "Or Join Automatic";
            }
        }
        return "";
    }

    public void setProjectNodes() throws Exception {
        this.pn.setNodes(this.soapclient.getProjectNodes());
    }

    public Object[] getProjectNodes() throws Exception {
        return this.soapclient.getProjectNodes();
    }

    public Object[] getProjectNodesArray() throws Exception {
        return this.pn.getNodes();
    }

    public Collection getProperties() throws Exception {
        return this.soapclient.getProperties();
    }

    public void windowMessage(String msg) {
        JOptionPane.showMessageDialog(null, msg);
    }

    public StrutsNodeValue getProjectNode(String nodeName) throws Exception {
        Object[] nodes = this.pn.getNodes();
        for (int i = 0; i < nodes.length; ++i) {
            StrutsNodeValue node = (StrutsNodeValue)nodes[i];
            if (!node.getName().equals(nodeName)) continue;
            return node;
        }
        return null;
    }

    public void setProjectNodeState(String nodeName, int state) throws Exception {
        Object[] nodes = this.pn.getNodes();
        for (int i = 0; i < nodes.length; ++i) {
            StrutsNodeValue node = (StrutsNodeValue)nodes[i];
            if (!node.getName().equals(nodeName)) continue;
            node.setState(this.getStateString(state));
        }
    }

    public void setProjectNodeRole(String nodeName, String role) throws Exception {
        Object[] nodes = this.pn.getNodes();
        for (int i = 0; i < nodes.length; ++i) {
            StrutsNodeValue node = (StrutsNodeValue)nodes[i];
            if (!node.getName().equals(nodeName)) continue;
            node.setRole(role);
        }
    }

    public void setProjectNodeDescription(String nodeName, String description) throws Exception {
        Object[] nodes = this.pn.getNodes();
        for (int i = 0; i < nodes.length; ++i) {
            StrutsNodeValue node = (StrutsNodeValue)nodes[i];
            if (!node.getName().equals(nodeName)) continue;
            node.setDescription(description);
        }
    }

    public void setProjectNodeDeadline(String nodeName, long deadline) throws Exception {
        Object[] nodes = this.pn.getNodes();
        for (int i = 0; i < nodes.length; ++i) {
            StrutsNodeValue node = (StrutsNodeValue)nodes[i];
            if (!node.getName().equals(nodeName)) continue;
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            node.setDeadline(df.format(df.parse(new java.sql.Date(deadline).toString())));
        }
    }
}

