/*
 * Decompiled with CFR 0.152.
 */
package hero.client.grapheditor;

import hero.client.grapheditor.DateComboBox;
import hero.client.grapheditor.WFManager;
import hero.client.grapheditor.WFPersistence;
import hero.interfaces.Constants;
import hero.net.ProjectSession.StrutsNodeValue;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class WFWindowManager
implements Constants {
    static ResourceBundle resource = ResourceBundle.getBundle("resources.Traduction");
    WFManager manager;
    WFPersistence persistence;
    public static final String imageBase = "images/";
    public static final ImageIcon icon = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("images/icon.png"));

    public String newProjectWindow() {
        block4: {
            try {
                JPanel jp = new JPanel();
                ArrayList<String> types = new ArrayList<String>();
                types.add("Model");
                types.add("Cooperative");
                JComboBox<Object> processTypes = new JComboBox<Object>(types.toArray());
                processTypes.setSelectedItem("Model");
                JTextField projectName = new JTextField();
                jp.add(new JLabel(resource.getString("wfwindowsmanager.newproj"), 2));
                jp.add(projectName);
                jp.setLayout(new GridLayout(0, 2));
                jp.add(new JLabel(resource.getString("wfwindowsmanager.choosetype"), 2));
                jp.add(processTypes);
                int cloneOption = JOptionPane.showConfirmDialog(null, jp, resource.getString("wfwindowsmanager.newproj"), 2, 3, icon);
                if (cloneOption == 2) break block4;
                while (projectName.getText().equals("") && cloneOption != 2) {
                    JOptionPane.showMessageDialog(null, resource.getString("wfwindowsmanager.enterproj"), resource.getString("wfwindowsmanager.newproj"), 1, icon);
                    cloneOption = JOptionPane.showConfirmDialog(null, jp, resource.getString("wfwindowsmanager.newproj"), 2, 3, icon);
                }
                if (cloneOption == 2) break block4;
                boolean ok = false;
                ok = processTypes.getSelectedItem().equals("Model") ? this.persistence.createModel(projectName.getText()) : this.persistence.createProject(projectName.getText());
                if (!ok) {
                    JOptionPane.showMessageDialog(null, resource.getString("wfwindowsmanager.existproj"), resource.getString("wfwindowsmanager.newproj"), 1, icon);
                    break block4;
                }
                this.manager.setTitle(projectName.getText());
                return projectName.getText();
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(null, resource.getString("wfwindowsmanager.createerror"), resource.getString("wfwindowsmanager.newproj"), 1, icon);
            }
        }
        return null;
    }

    public WFWindowManager(WFManager manager, WFPersistence persistence) {
        this.manager = manager;
        this.persistence = persistence;
    }

    public boolean cloneProjectWindow() {
        block4: {
            try {
                JPanel jp = new JPanel();
                Object[] possibleValues = this.persistence.getProjects();
                JComboBox<Object> projectNames = new JComboBox<Object>(possibleValues);
                jp.setLayout(new GridLayout(0, 2));
                jp.add(new JLabel(resource.getString("wfwindowsmanager.chooseproj"), 2));
                jp.add(projectNames);
                JTextField newProject = new JTextField("", 0);
                jp.setLayout(new GridLayout(0, 2));
                jp.add(new JLabel(resource.getString("wfwindowsmanager.projname"), 2));
                jp.add(newProject);
                int cloneOption = JOptionPane.showConfirmDialog(null, jp, resource.getString("wfwindowsmanager.cloneproj"), 2, 3, icon);
                if (cloneOption == 2) break block4;
                while (newProject.getText().equals("") && cloneOption != 2) {
                    JOptionPane.showMessageDialog(null, resource.getString("wfwindowsmanager.enterproj"), resource.getString("wfwindowsmanager.cloneproj"), 1, icon);
                    cloneOption = JOptionPane.showConfirmDialog(null, jp, resource.getString("wfwindowsmanager.cloneproj"), 2, 3, icon);
                }
                if (cloneOption == 2) break block4;
                boolean ok = this.persistence.cloneProject((String)projectNames.getSelectedItem(), newProject.getText());
                if (!ok) {
                    JOptionPane.showMessageDialog(null, resource.getString("wfwindowsmanager.existproj"), resource.getString("wfwindowsmanager.cloneproj"), 1, icon);
                    break block4;
                }
                this.manager.openProject(newProject.getText());
                return true;
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(null, resource.getString("wfwindowsmanager.cloneerror"), resource.getString("wfwindowsmanager.cloneproj"), 1, icon);
            }
        }
        return false;
    }

    public void openProject() {
        try {
            Object[] values = this.persistence.getProjects();
            Object selectedValue = JOptionPane.showInputDialog(null, resource.getString("wfwindowsmanager.graphedit"), resource.getString("wfwindowsmanager.openproj"), 1, icon, values, values[0]);
            if (selectedValue != null) {
                this.manager.openProject((String)selectedValue);
            }
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(null, resource.getString("wfwindowsmanager.openerror"), resource.getString("wfwindowsmanager.openproj"), 1, icon);
        }
    }

    public void editNode(String nodeName) {
        Object result = null;
        JPanel jp = new JPanel();
        try {
            this.persistence.setProjectNodes();
            StrutsNodeValue nl = this.persistence.getProjectNode(nodeName);
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            jp.setLayout(gridbag);
            c.fill = 1;
            c.weightx = 1.0;
            jp.add(new JLabel(resource.getString("wfwindowsmanager.deadline")));
            DateComboBox dcb = new DateComboBox();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd,yyyy");
            if (this.persistence.getDeadline(nodeName) != null) {
                dcb.setSelectedItem(dateFormat.format(df.parse(nl.getDeadline().toString())));
            }
            dcb.setEditable(true);
            jp.add(dcb);
            gridbag.setConstraints(dcb, c);
            c.gridwidth = 0;
            c.weightx = 1.0;
            Object[] possibleRoles = this.persistence.getRoles();
            JComboBox<Object> roles = new JComboBox<Object>(possibleRoles);
            roles.setSelectedItem(this.persistence.getRole(nodeName));
            jp.add(new JLabel(resource.getString("wfwindowsmanager.selectrole"), 2));
            jp.add(roles);
            gridbag.setConstraints(roles, c);
            c.gridwidth = 0;
            c.weightx = 0.0;
            JTextArea description = new JTextArea(nl.getDescription());
            JScrollPane areaScrollPane = new JScrollPane(description);
            areaScrollPane.setVerticalScrollBarPolicy(22);
            areaScrollPane.setPreferredSize(new Dimension(200, 100));
            jp.add(new JLabel(resource.getString("wfwindowsmanager.description"), 2));
            jp.add(areaScrollPane);
            gridbag.setConstraints(areaScrollPane, c);
            JCheckBox anti = new JCheckBox(resource.getString("wfwindowsmanager.anticipable"));
            if (this.persistence.getNodeAnticipable(nodeName)) {
                anti.setSelected(true);
            } else {
                anti.setSelected(false);
            }
            jp.add(anti);
            gridbag.setConstraints(anti, c);
            int option = JOptionPane.showConfirmDialog(null, jp, resource.getString("wfwindowsmanager.editact"), 2, 3, icon);
            if (option != 2) {
                if (dcb.getSelectedItem() != null) {
                    Date deadline = dateFormat.parse((String)dcb.getSelectedItem());
                    while (deadline.getTime() <= System.currentTimeMillis() && option != 2) {
                        JOptionPane.showMessageDialog(null, resource.getString("wfwindowsmanager.datedeadline"), resource.getString("wfwindowsmanager.editact"), 1, icon);
                        option = JOptionPane.showConfirmDialog(null, jp, "Edit Activity", 2, 3, icon);
                        deadline = dateFormat.parse((String)dcb.getSelectedItem());
                    }
                    this.persistence.setEditNode(nodeName, (String)roles.getSelectedItem(), description.getText(), deadline);
                } else {
                    this.persistence.setNodeDescription(nodeName, description.getText());
                    this.persistence.setNodeRole(nodeName, (String)roles.getSelectedItem());
                    if (!anti.isSelected()) {
                        this.persistence.setNodeTraditional(nodeName);
                    } else {
                        this.persistence.setNodeAnticipable(nodeName);
                    }
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, resource.getString("wfwindowsmanager.editerror") + e.getMessage(), resource.getString("wfwindowsmanager.editact"), 1, icon);
        }
    }

    public Vector addInterHook() {
        Vector<String> result = new Vector<String>();
        Vector<String> hookTypes = new Vector<String>();
        hookTypes.add("afterStart");
        hookTypes.add("beforeStart");
        hookTypes.add("afterTerminate");
        hookTypes.add("beforeTerminate");
        hookTypes.add("anticipate");
        hookTypes.add("onCancel");
        hookTypes.add("onDeadline");
        hookTypes.add("onReady");
        JPanel jp = new JPanel();
        JTextField hook = new JTextField("", 10);
        jp.add(new JLabel(resource.getString("wfwindowsmanager.namehook"), 2));
        jp.add(hook);
        JComboBox types = new JComboBox(hookTypes);
        jp.setLayout(new GridLayout(0, 2));
        jp.add(new JLabel(resource.getString("wfwindowsmanager.choosetype"), 2));
        jp.add(types);
        int option = JOptionPane.showConfirmDialog(null, jp, resource.getString("wfwindowsmanager.newhook"), 2, 3, icon);
        if (option != 2) {
            while (hook.getText().equals("") && option != 2) {
                JOptionPane.showMessageDialog(null, hook.getText() + resource.getString("wfwindowsmanager.nullhook"), resource.getString("wfwindowsmanager.newhook"), 1, icon);
                option = JOptionPane.showConfirmDialog(null, jp, resource.getString("wfwindowsmanager.newhook"), 2, 3, icon);
            }
            if (option != 2) {
                result.add(hook.getText());
                result.add((String)types.getSelectedItem());
                String value = null;
                switch (types.getSelectedIndex()) {
                    case 0: {
                        value = "import hero.interfaces.*;\nimport hero.interfaces.BnNodeLocal;\nafterStart (Object b,Object n) {\n\n\n}";
                        break;
                    }
                    case 1: {
                        value = "import hero.interfaces.*;\nimport hero.interfaces.BnNodeLocal;\nbeforeStart (Object b,Object n) {\n\n\n}";
                        break;
                    }
                    case 2: {
                        value = "import hero.interfaces.*;\nimport hero.interfaces.BnNodeLocal;\nafterTerminate (Object b,Object n) {\n\n\n}";
                        break;
                    }
                    case 3: {
                        value = "import hero.interfaces.*;\nimport hero.interfaces.BnNodeLocal;\nbeforeTerminate (Object b,Object n) {\n\n\n}";
                        break;
                    }
                    case 4: {
                        value = "import hero.interfaces.*;\nimport hero.interfaces.BnNodeLocal;\nanticipate (Object b,Object n) {\n\n\n}";
                        break;
                    }
                    case 5: {
                        value = "import hero.interfaces.*;\nimport hero.interfaces.BnNodeLocal;\nonCancel (Object b,Object n) {\n\n\n}";
                        break;
                    }
                    case 6: {
                        value = "import hero.interfaces.*;\nimport hero.interfaces.BnNodeLocal;\nonDeadline (Object b,Object n) {\n\n\n}";
                        break;
                    }
                    case 7: {
                        value = "import hero.interfaces.*;\nimport hero.interfaces.BnNodeLocal;\nonReady (Object b,Object n) {\n\n\n}";
                    }
                }
                result.add(value);
                return result;
            }
        }
        return result;
    }

    public String setInterHookValue(String value) {
        String result = null;
        JPanel jp = new JPanel();
        JTextArea hook = new JTextArea(value);
        JScrollPane areaScrollPane = new JScrollPane(hook);
        areaScrollPane.setVerticalScrollBarPolicy(22);
        areaScrollPane.setPreferredSize(new Dimension(350, 250));
        jp.add(new JLabel(resource.getString("wfwindowsmanager.hookaction"), 2));
        jp.add(areaScrollPane);
        int option = JOptionPane.showConfirmDialog(null, jp, resource.getString("wfwindowsmanager.hookscript"), 2, 3, icon);
        if (option != 2) {
            while (hook.getText().equals("") && option != 2) {
                JOptionPane.showMessageDialog(null, hook.getText() + resource.getString("wfwindowsmanager.nullhook"), resource.getString("wfwindowsmanager.hookscript"), 1, icon);
                option = JOptionPane.showConfirmDialog(null, jp, resource.getString("wfwindowsmanager.hookscript"), 2, 3, icon);
            }
            if (option != 2) {
                result = hook.getText();
            }
        }
        return result;
    }

    public void addNodePropertyWindow(String node) {
        JPanel jp = new JPanel();
        JTextField key = new JTextField("", 0);
        jp.setLayout(new GridLayout(0, 2));
        jp.add(new JLabel(resource.getString("wfwindowsmanager.keyprop"), 2));
        jp.add(key);
        JTextField value = new JTextField("", 0);
        jp.setLayout(new GridLayout(0, 2));
        jp.add(new JLabel(resource.getString("wfwindowsmanager.valprop"), 2));
        jp.add(value);
        JCheckBox prop = new JCheckBox(resource.getString("wfwindowsmanager.propagate"));
        prop.setSelected(true);
        jp.add(prop);
        int option = JOptionPane.showConfirmDialog(null, jp, resource.getString("wfwindowsmanager.newnodeprop"), 2, 3, icon);
        if (option != 2) {
            while (key.getText().equals("") && option != 2) {
                JOptionPane.showMessageDialog(null, resource.getString("wfwindowsmanager.enterprop"), resource.getString("wfwindowsmanager.newnodeprop"), 1, icon);
                option = JOptionPane.showConfirmDialog(null, jp, resource.getString("wfwindowsmanager.newprop"), 2, 3, icon);
            }
            if (option != 2 && !prop.isSelected()) {
                try {
                    this.persistence.addNodeProperty(node, key.getText(), value.getText(), false);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, resource.getString("wfwindowsmanager.existprop"), resource.getString("wfwindowsmanager.newnodeproperty"), 1, icon);
                }
            } else if (option != 2 && prop.isSelected()) {
                try {
                    this.persistence.addNodeProperty(node, key.getText(), value.getText(), true);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, resource.getString("wfwindowsmanager.adderrorprop"), resource.getString("wfwindowsmanager.newnodeprop"), 1, icon);
                }
            }
        }
    }

    public void addProjectPropertyWindow() {
        JPanel jp = new JPanel();
        JTextField key = new JTextField("", 0);
        jp.setLayout(new GridLayout(0, 2));
        jp.add(new JLabel(resource.getString("wfwindowsmanager.keyprop"), 2));
        jp.add(key);
        JTextField value = new JTextField("", 0);
        jp.setLayout(new GridLayout(0, 2));
        jp.add(new JLabel(resource.getString("wfwindowsmanager.valprop"), 2));
        jp.add(value);
        int option = JOptionPane.showConfirmDialog(null, jp, resource.getString("wfwindowsmanager.newpropproj"), 2, 3, icon);
        if (option != 2) {
            while (key.getText().equals("") && option != 2) {
                JOptionPane.showMessageDialog(null, resource.getString("wfwindowsmanager.enterprop"), resource.getString("wfwindowsmanager.newpropproj"), 1, icon);
                option = JOptionPane.showConfirmDialog(null, jp, resource.getString("wfwindowsmanager.newprop"), 2, 3, icon);
            }
            if (option != 2) {
                try {
                    this.persistence.addProjectProperty(key.getText(), value.getText());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, resource.getString("wfwindowsmanager.adderrorprop"), resource.getString("wfwindowsmanager.newpropproj"), 1, icon);
                }
            }
        }
    }

    public void iterate(String node) {
        JPanel jp = new JPanel();
        JTextField from = new JTextField(node, 0);
        from.setEditable(false);
        jp.setLayout(new GridLayout(0, 2));
        jp.add(new JLabel(resource.getString("wfwindowsmanager.fromnode"), 2));
        jp.add(from);
        JTextField to = new JTextField("", 0);
        jp.setLayout(new GridLayout(0, 2));
        jp.add(new JLabel(resource.getString("wfwindowsmanager.tonode"), 2));
        jp.add(to);
        JTextField condition = new JTextField("", 30);
        jp.add(new JLabel(resource.getString("wfwindowsmanager.itecond"), 2));
        jp.add(condition);
        int option = JOptionPane.showConfirmDialog(null, jp, resource.getString("wfwindowsmanager.iterate"), 2, 3, icon);
        if (option != 2) {
            while (from.getText().equals("") && condition.getText().equals("") && option != 2) {
                JOptionPane.showMessageDialog(null, resource.getString("wfwindowsmanager.enternode"), resource.getString("wfwindowsmanager.iterate"), 1, icon);
                option = JOptionPane.showConfirmDialog(null, jp, resource.getString("wfwindowsmanager.iterate"), 2, 3, icon);
            }
            if (option != 2) {
                try {
                    this.persistence.addIteration(node, to.getText(), condition.getText());
                    this.manager.wfGraph.updateIterationNodes(node, to.getText());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, resource.getString("wfwindowsmanager.iterno"), resource.getString("wfwindowsmanager.iterate"), 1, icon);
                }
            }
        }
    }

    public Vector addNode() {
        Vector<String> result = new Vector<String>();
        try {
            JPanel jp = new JPanel();
            Vector<String> nodeTypes = new Vector<String>();
            nodeTypes.add("AND JOIN");
            nodeTypes.add("OR JOIN");
            nodeTypes.add("AND JOIN AUTO");
            nodeTypes.add("OR JOIN AUTO");
            JTextField nodeName = new JTextField("", 10);
            jp.add(new JLabel(resource.getString("wfwindowsmanager.namenode"), 2));
            jp.add(nodeName);
            JComboBox types = new JComboBox(nodeTypes);
            jp.setLayout(new GridLayout(0, 2));
            jp.add(new JLabel(resource.getString("wfwindowsmanager.choosetype"), 2));
            jp.add(types);
            int option = JOptionPane.showConfirmDialog(null, jp, resource.getString("wfwindowsmanager.newnode"), 2, 3, icon);
            if (option != 2) {
                while ((this.persistence.containsNode(nodeName.getText()) || nodeName.getText().equals("")) && option != 2) {
                    JOptionPane.showMessageDialog(null, nodeName.getText() + resource.getString("wfwindowsmanager.existnode"), resource.getString("wfwindowsmanager.newnode"), 1, icon);
                    option = JOptionPane.showConfirmDialog(null, jp, "New Activity", 2, 3, icon);
                }
                if (option != 2) {
                    result.add(nodeName.getText());
                    result.add((String)types.getSelectedItem());
                    return result;
                }
            }
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(null, resource.getString("wfwindowsmanager.errornode"), resource.getString("wfwindowsmanager.newnode"), 1, icon);
        }
        return result;
    }

    public Vector addNodeSubProcess() {
        Vector<String> result = new Vector<String>();
        try {
            JPanel jp = new JPanel();
            Object[] possibleValues = this.persistence.getProjects();
            JComboBox<Object> projectNames = new JComboBox<Object>(possibleValues);
            jp.setLayout(new GridLayout(0, 2));
            jp.add(new JLabel(resource.getString("wfwindowsmanager.choosesub"), 2));
            jp.add(projectNames);
            JTextField nodeName = new JTextField("", 10);
            jp.add(new JLabel(resource.getString("wfwindowsmanager.namenode"), 2));
            jp.add(nodeName);
            int option = JOptionPane.showConfirmDialog(null, jp, resource.getString("wfwindowsmanager.newsub"), 2, 3, icon);
            if (option != 2) {
                while ((this.persistence.containsNode(nodeName.getText()) || nodeName.getText().equals("")) && option != 2) {
                    JOptionPane.showMessageDialog(null, (String)projectNames.getSelectedItem() + resource.getString("wfwindowsmanager.existnodesub"), resource.getString("wfwindowsmanager.newsub"), 1, icon);
                    option = JOptionPane.showConfirmDialog(null, jp, resource.getString("wfwindowsmanager.newsub"), 2, 3, icon);
                }
                while (this.persistence.containsProject(nodeName.getText()) && option != 2) {
                    JOptionPane.showMessageDialog(null, (String)projectNames.getSelectedItem() + resource.getString("wfwindowsmanager.existsub"), resource.getString("wfwindowsmanager.newsub"), 1, icon);
                    option = JOptionPane.showConfirmDialog(null, jp, resource.getString("wfwindowsmanager.newsub"), 2, 3, icon);
                }
                if (option != 2) {
                    result.add(nodeName.getText());
                    result.add((String)projectNames.getSelectedItem());
                    return result;
                }
            }
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(null, resource.getString("wfwindowsmanager.errorsystem"), resource.getString("wfwindowsmanager.newsub"), 1, icon);
        }
        return result;
    }

    public String setEdgeCondition(String edgeName) {
        String result = null;
        try {
            JPanel jp = new JPanel();
            JTextField condition = new JTextField("", 30);
            jp.add(new JLabel(resource.getString("wfwindowsmanager.edgecond"), 2));
            jp.add(condition);
            result = this.persistence.getEdgeCondition(edgeName);
            condition.setText(result);
            int option = JOptionPane.showConfirmDialog(null, jp, resource.getString("wfwindowsmanager.setedge"), 2, 3, icon);
            if (option != 2) {
                while (condition.getText().equals("") && option != 2) {
                    JOptionPane.showMessageDialog(null, condition.getText() + resource.getString("wfwindowsmanager.entercond"), resource.getString("wfwindowsmanager.setedge"), 1, icon);
                    option = JOptionPane.showConfirmDialog(null, jp, resource.getString("wfwindowsmanager.setedge"), 2, 3, icon);
                }
                if (option != 2) {
                    result = condition.getText();
                    return result;
                }
            }
        }
        catch (Exception ec) {
            JOptionPane.showMessageDialog(null, resource.getString("wfwindowsmanager.erroredge"), resource.getString("wfwindowsmanager.setedge"), 1, icon);
        }
        return result;
    }

    public void changeRoleWindow(String node) {
        try {
            Object[] possibleRoles = this.persistence.getRoles();
            JPanel jp = new JPanel();
            JComboBox<Object> roles = new JComboBox<Object>(possibleRoles);
            jp.setLayout(new GridLayout(0, 2));
            jp.add(new JLabel(resource.getString("wfwindowsmanager.selectrole"), 2));
            jp.add(roles);
            int option = JOptionPane.showConfirmDialog(null, jp, resource.getString("wfwindowsmanager.changerole"), 2, 3, icon);
            if (option != 2) {
                this.persistence.setNodeRole(node, (String)roles.getSelectedItem());
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, resource.getString("wfwindowsmanager.errorchangerole"), resource.getString("wfwindowsmanager.changerole"), 1, icon);
        }
    }

    protected String dialog(String message, int mode) {
        FileDialog f = new FileDialog((Frame)this.manager.getFrame(), message, mode);
        f.show();
        if (f.getFile() != null) {
            return f.getDirectory() + f.getFile();
        }
        return null;
    }

    private boolean contains(Object[] data, String elem) {
        for (int i = 0; i < data.length; ++i) {
            if (!((String)data[i]).equalsIgnoreCase(elem)) continue;
            return true;
        }
        return false;
    }

    public void newUser() {
        try {
            Object[] usersIn = this.persistence.getUsersInProject();
            Object[] allUsers = this.persistence.getAllUsers();
            int size = allUsers.length - usersIn.length;
            if (size == 0) {
                JOptionPane.showMessageDialog(null, resource.getString("wfwindowsmanager.nomoreuser"));
            } else {
                Object[] possibleUsers = new Object[size];
                int j = 0;
                for (int i = 0; i < allUsers.length; ++i) {
                    if (this.contains(usersIn, (String)allUsers[i])) continue;
                    possibleUsers[j] = allUsers[i];
                    ++j;
                }
                JPanel jp = new JPanel();
                JComboBox<Object> users = new JComboBox<Object>(possibleUsers);
                jp.setLayout(new GridLayout(0, 2));
                jp.add(new JLabel(resource.getString("wfwindowsmanager.selectuser"), 2));
                jp.add(users);
                int option = JOptionPane.showConfirmDialog(null, jp, resource.getString("wfwindowsmanager.newuser"), 2, 3, icon);
                if (option != 2) {
                    this.persistence.addUser((String)users.getSelectedItem());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void newRole() {
        JPanel jp = new JPanel();
        JTextField roleName = new JTextField("", 0);
        jp.setLayout(new GridLayout(0, 2));
        jp.add(new JLabel(resource.getString("wfwindowsmanager.namerole"), 2));
        jp.add(roleName);
        JTextField description = new JTextField("", 0);
        jp.setLayout(new GridLayout(0, 2));
        jp.add(new JLabel(resource.getString("wfwindowsmanager.description"), 2));
        jp.add(description);
        int option = JOptionPane.showConfirmDialog(null, jp, resource.getString("wfwindowsmanager.newrole"), 2, 3, icon);
        if (option != 2) {
            while (roleName.getText().equals("") && option != 2) {
                JOptionPane.showMessageDialog(null, resource.getString("wfwindowsmanager.enterrolename"), resource.getString("wfwindowsmanager.newrole"), 1, icon);
                option = JOptionPane.showConfirmDialog(null, jp, "New Role", 2, 3, icon);
            }
            if (option != 2) {
                try {
                    this.persistence.addRole(roleName.getText(), description.getText());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, resource.getString("wfwindowsmanager.existrole"), resource.getString("wfwindowsmanager.newrole"), 1, icon);
                }
            }
        }
    }

    public void addUserToRole() {
        try {
            JPanel jp = new JPanel();
            Object[] possibleUsers = this.persistence.getUsersInProject();
            JComboBox<Object> users = new JComboBox<Object>(possibleUsers);
            jp.setLayout(new GridLayout(0, 2));
            jp.add(new JLabel(resource.getString("wfwindowsmanager.selectuser"), 2));
            jp.add(users);
            Object[] possibleRoles = this.persistence.getRoles();
            JComboBox<Object> roles = new JComboBox<Object>(possibleRoles);
            jp.setLayout(new GridLayout(0, 2));
            jp.add(new JLabel(resource.getString("wfwindowsmanager.selectrole"), 2));
            jp.add(roles);
            int option = JOptionPane.showConfirmDialog(null, jp, resource.getString("wfwindowsmanager.adduserrole"), 2, 3, icon);
            if (option != 2) {
                try {
                    this.persistence.setUserRole((String)users.getSelectedItem(), (String)roles.getSelectedItem());
                }
                catch (Exception exx) {
                    JOptionPane.showMessageDialog(null, resource.getString("wfwindowsmanager.existuserrole"), resource.getString("wfwindowsmanager.adduserrole"), 1, icon);
                }
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, resource.getString("wfwindowsmanager.exerole"), resource.getString("wfwindowsmanager.adduserrole"), 1, icon);
        }
    }

    public void addMapperToRole() {
        try {
            JPanel jp = new JPanel();
            Vector<String> mapperTypes = new Vector<String>();
            mapperTypes.add("LDAP");
            mapperTypes.add("Properties");
            mapperTypes.add("Custom");
            Object[] possibleRoles = this.persistence.getRoles();
            JComboBox<Object> roles = new JComboBox<Object>(possibleRoles);
            jp.setLayout(new GridLayout(0, 2));
            jp.add(new JLabel(resource.getString("wfwindowsmanager.selectrole"), 2));
            jp.add(roles);
            JTextField mapperName = new JTextField("", 0);
            jp.setLayout(new GridLayout(0, 2));
            jp.add(new JLabel(resource.getString("wfwindowsmanager.mapper"), 2));
            jp.add(mapperName);
            JComboBox types = new JComboBox(mapperTypes);
            jp.setLayout(new GridLayout(0, 2));
            jp.add(new JLabel(resource.getString("wfwindowsmanager.mappertype"), 2));
            jp.add(types);
            int option = JOptionPane.showConfirmDialog(null, jp, resource.getString("wfwindowsmanager.addmapperrole"), 2, 3, icon);
            if (option != 2) {
                try {
                    this.persistence.addRoleMapper((String)roles.getSelectedItem(), mapperName.getText(), (String)types.getSelectedItem());
                }
                catch (Exception exx) {
                    JOptionPane.showMessageDialog(null, resource.getString("wfwindowsmanager.existmapperrole"), resource.getString("wfwindowsmanager.addmapperrole"), 1, icon);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(null, resource.getString("wfwindowsmanager.exemapper"), resource.getString("wfwindowsmanager.addmapperrole"), 1, icon);
        }
    }

    public void addPerformerAssigment(String nodeName) {
        JPanel jp = new JPanel();
        Vector<String> performerTypes = new Vector<String>();
        performerTypes.add("Callback");
        performerTypes.add("Property");
        JComboBox types = new JComboBox(performerTypes);
        jp.setLayout(new GridLayout(0, 2));
        jp.add(new JLabel(resource.getString("wfwindowsmanager.performertype"), 2));
        jp.add(types);
        JTextField performerName = new JTextField("", 0);
        jp.setLayout(new GridLayout(0, 2));
        jp.add(new JLabel(resource.getString("wfwindowsmanager.performername"), 2));
        jp.add(performerName);
        JTextField property = new JTextField("", 0);
        jp.setLayout(new GridLayout(0, 2));
        jp.add(new JLabel(resource.getString("wfwindowsmanager.performerprop"), 2));
        jp.add(property);
        int option = JOptionPane.showConfirmDialog(null, jp, resource.getString("wfwindowsmanager.addperformer"), 2, 3, icon);
        if (option != 2) {
            try {
                this.persistence.addPerformerAssigment(nodeName, performerName.getText(), (String)types.getSelectedItem(), property.getText());
            }
            catch (Exception exx) {
                JOptionPane.showMessageDialog(null, resource.getString("wfwindowsmanager.existperformer"), resource.getString("wfwindowsmanager.addperformer"), 1, icon);
            }
        }
    }

    public void usersInProject() {
        try {
            JPanel jp = new JPanel();
            Object[] users = this.persistence.getUsersInProject();
            String text = resource.getString("wfwindowsmanager.userhtml");
            Object[] nameRoles = this.persistence.getRoles();
            for (int i = 0; i < nameRoles.length; ++i) {
                text = text + "<th>" + (String)nameRoles[i] + "</th>";
            }
            for (int j = 0; j < users.length; ++j) {
                text = text + "<tr bgcolor=white><td>" + (String)users[j] + "</td>";
                for (int i = 0; i < nameRoles.length; ++i) {
                    text = this.persistence.isInRole((String)users[j], (String)nameRoles[i]) ? text + "<td align=center> X </td>" : text + "<td></td>";
                }
                text = text + "</tr>";
            }
            text = text + "</table></html>";
            JLabel jText = new JLabel(text);
            jp.add(jText);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            JScrollPane scroll = new JScrollPane(jp);
            scroll.setMaximumSize(new Dimension(screenSize.width / 2, screenSize.height / 2));
            JFrame fr = new JFrame(resource.getString("wfwindowsmanager.userproj"));
            fr.getContentPane().add((Component)scroll, "Center");
            fr.pack();
            Dimension jpDim = scroll.getPreferredSize();
            fr.setLocation(screenSize.width / 2 - jpDim.width / 2, screenSize.height / 2 - jpDim.height / 2);
            fr.setResizable(true);
            fr.setVisible(true);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, resource.getString("wfwindowsmanager.exeuserrole"), resource.getString("wfwindowsmanager.userole"), 1, icon);
        }
    }
}

