/*
 * Decompiled with CFR 0.152.
 */
package hero.client.manager;

import hero.client.grapheditor.Frame;
import hero.client.manager.BrowserControl;
import hero.client.manager.MListener;
import hero.interfaces.Constants;
import hero.util.BonitaClient;
import hero.util.EventConstants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;

public class JProjectList
extends JPanel
implements PropertyChangeListener,
Constants.Nd,
EventConstants,
MouseListener {
    static ResourceBundle resource = ResourceBundle.getBundle("resources.Traduction");
    private JScrollPane jsppl;
    private JTree tree;
    private MListener ml;
    private DefaultMutableTreeNode top;
    private DefaultTreeModel treeModel;
    public static final String SELECTED = "selected";
    public static final String PROJECTCLOSE = "close";
    public Hashtable projects = new Hashtable();
    private Frame frame;
    private BonitaClient soapclient;
    private String newStatus = "Active";
    private Collection actualProjects;
    public static final String imageBase = "images/";
    public static final ImageIcon icon = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("images/icon.png"));
    private Toolkit toolkit = Toolkit.getDefaultToolkit();

    public JProjectList(BonitaClient soapclient, MListener ml, Collection initialProjects) {
        try {
            this.actualProjects = initialProjects;
            ml.addEventProjectListener(this);
            this.add((Component)new JLabel(resource.getString("jprojectlist.project")), "North");
            this.soapclient = soapclient;
            this.top = new DefaultMutableTreeNode(resource.getString("jprojectlist.project"));
            this.treeModel = new DefaultTreeModel(this.top);
            this.treeModel.addTreeModelListener(new MyTreeModelListener());
            this.tree = new JTree(this.treeModel);
            this.tree.getSelectionModel().setSelectionMode(1);
            TreeCellRenderer cr = this.tree.getCellRenderer();
            CustomDefaultRenderer dtcr = new CustomDefaultRenderer();
            this.tree.setCellRenderer(dtcr);
            dtcr.setBackgroundNonSelectionColor(Color.white);
            dtcr.setTextSelectionColor(Color.white);
            dtcr.setTextNonSelectionColor(Color.black);
            dtcr.setLeafForeground(Color.blue);
            ImageIcon leafIcon = new ImageIcon("images/ast.gif");
            dtcr.setLeafIcon(leafIcon);
            dtcr.setClosedIcon(leafIcon);
            dtcr.setOpenIcon(leafIcon);
            this.tree.setRowHeight(0);
            this.tree.setBackground(Color.white);
            this.createNodes(this.actualProjects);
            this.jsppl = new JScrollPane(this.tree);
            this.setLayout(new BorderLayout());
            this.setBackground(new Color(177, 177, 251));
            this.add((Component)this.jsppl, "Center");
            this.tree.addMouseListener(this);
            this.tree.setVisibleRowCount(10);
            this.setVisible(true);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void newProject() {
        JPanel jp = new JPanel();
        ArrayList<String> types = new ArrayList<String>();
        types.add("Model");
        types.add("Cooperative");
        JComboBox<Object> processTypes = new JComboBox<Object>(types.toArray());
        processTypes.setSelectedItem("Model");
        JTextField projectName = new JTextField();
        jp.add(new JLabel(resource.getString("wfwindowsmanager.newproj"), 2));
        jp.add(projectName);
        jp.setLayout(new GridLayout(0, 2));
        jp.add(new JLabel(resource.getString("wfwindowsmanager.choosetype"), 2));
        jp.add(processTypes);
        int cloneOption = JOptionPane.showConfirmDialog(null, jp, resource.getString("wfwindowsmanager.newproj"), 2, 3, icon);
        if (cloneOption != 2) {
            while (projectName.getText().equals("") && cloneOption != 2) {
                JOptionPane.showMessageDialog(null, resource.getString("wfwindowsmanager.enterproj"), resource.getString("wfwindowsmanager.newproj"), 1, icon);
                cloneOption = JOptionPane.showConfirmDialog(null, jp, resource.getString("wfwindowsmanager.newproj"), 2, 3, icon);
            }
            if (cloneOption != 2) {
                try {
                    if (this.exists(projectName.getText())) {
                        JOptionPane.showMessageDialog(null, resource.getString("jprojectlist.exist"), resource.getString("jprojectlist.name"), 1, icon);
                    } else if (processTypes.getSelectedItem().equals("Model")) {
                        this.soapclient.createModel(projectName.getText());
                    } else {
                        this.soapclient.createProject(projectName.getText());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(null, resource.getString("jprojectlist.exist"), resource.getString("jprojectlist.new"), 1, icon);
                }
            }
        }
    }

    private boolean exists(String project) {
        try {
            Object[] elems = this.actualProjects.toArray();
            for (int i = 0; i < elems.length; ++i) {
                if (!((String)elems[i]).equalsIgnoreCase(project)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public void mouseReleased(MouseEvent e) {
        block7: {
            try {
                if (this.tree.isSelectionEmpty()) break block7;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
                if ((e.getModifiers() & 4) != 0) {
                    JPopupMenu menu = new JPopupMenu();
                    this.PopupMenu(menu);
                    Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
                    Dimension size = menu.getPreferredSize();
                    int x = e.getX();
                    int y = e.getY();
                    menu.show(this, e.getX() - (int)this.jsppl.getViewport().getViewPosition().getX(), e.getY() - (int)this.jsppl.getViewport().getViewPosition().getY());
                    break block7;
                }
                if (e.getClickCount() == 1 && !node.isRoot()) {
                    String pl = node.getUserObject().toString();
                    this.firePropertyChange(SELECTED, "", pl);
                    break block7;
                }
                if (e.getClickCount() != 2 || node.isRoot()) break block7;
                try {
                    if (!this.projects.containsKey(node.getUserObject().toString())) {
                        this.frame = new Frame(node.getUserObject().toString(), this.soapclient, false);
                        this.frame.setSize(new Dimension(500, 400));
                        this.frame.setVisible(true);
                        this.projects.put(node.getUserObject().toString(), this.frame);
                        this.frame.addPropertyChangeListener(PROJECTCLOSE, this);
                        break block7;
                    }
                    this.frame = (Frame)this.projects.get(node.getUserObject().toString());
                    this.frame.requestFocus();
                }
                catch (Exception exception) {}
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(null, resource.getString("jprojectlist.error"), resource.getString("jprojectlist.interror"), 1, icon);
            }
        }
    }

    public String getProjectType(String projectName) {
        try {
            this.soapclient.initProject(projectName);
            return this.soapclient.getType();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getProjectStatus(String projectName) {
        try {
            this.soapclient.initProject(projectName);
            return this.soapclient.getStatus();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void PopupMenu(JPopupMenu menu) {
        ClassLoader cl = this.getClass().getClassLoader();
        if (!((DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent()).isRoot()) {
            JMenuItem mi;
            try {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
                String status = this.getProjectStatus(node.getUserObject().toString());
                if (status != null) {
                    String message = "";
                    if (status.equals("Active")) {
                        message = resource.getString("jprojectlist.hideproject");
                        this.newStatus = "Hidden";
                    } else {
                        message = resource.getString("jprojectlist.activeproject");
                        this.newStatus = "Active";
                    }
                    mi = menu.add(new JMenuItem(message));
                    mi.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            DefaultMutableTreeNode node = (DefaultMutableTreeNode)JProjectList.this.tree.getLastSelectedPathComponent();
                            JProjectList.this.setStatus(node.getUserObject().toString());
                        }
                    });
                }
            }
            catch (Exception statusEx) {
                statusEx.printStackTrace();
            }
            mi = menu.add(new JMenuItem(resource.getString("jprojectlist.clone")));
            mi.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)JProjectList.this.tree.getLastSelectedPathComponent();
                    JProjectList.this.cloneProject(node.getUserObject().toString());
                }
            });
            mi = menu.add(new JMenuItem(resource.getString("jprojectlist.inst")));
            mi.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)JProjectList.this.tree.getLastSelectedPathComponent();
                    JProjectList.this.instantiateProject(node.getUserObject().toString());
                }
            });
            mi = menu.add(new JMenuItem(resource.getString("jprojectlist.details")));
            mi.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)JProjectList.this.tree.getLastSelectedPathComponent();
                    BrowserControl.displayURL(System.getProperty("bonita.host") + "/bonita/protected/Action.jsp?projectname=" + node.getUserObject().toString());
                }
            });
            mi = menu.add(new JMenuItem(resource.getString("jprojectlist.terminate")));
            mi.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)JProjectList.this.tree.getLastSelectedPathComponent();
                    JProjectList.this.terminateProject(node.getUserObject().toString());
                }
            });
            mi = menu.add(new JMenuItem(resource.getString("jprojectlist.delete")));
            mi.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)JProjectList.this.tree.getLastSelectedPathComponent();
                    JProjectList.this.deleteProject(node.getUserObject().toString());
                }
            });
        }
    }

    public void deleteProject(String project) {
        try {
            int option = JOptionPane.showConfirmDialog(null, resource.getString("jprojectlist.deleteproject"), resource.getString("jprojectlist.delete"), 2, 3, icon);
            if (option == 0 && this.soapclient.deleteProject(project)) {
                JOptionPane.showMessageDialog(null, resource.getString("jprojectlist.proj") + project + " " + resource.getString("jprojectlist.remove"), resource.getString("jprojectlist.delete"), 1, icon);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), resource.getString("jprojectlist.delete"), 1, icon);
        }
    }

    public void cloneProject(String project) {
        try {
            String newProject = (String)JOptionPane.showInputDialog(null, resource.getString("jprojectlist.name"), resource.getString("jprojectlist.clone"), 3, icon, null, null);
            while (newProject != null && newProject.equals("")) {
                JOptionPane.showMessageDialog(null, resource.getString("jprojectlist.enternew"), resource.getString("jprojectlist.clone"), 1, icon);
                newProject = (String)JOptionPane.showInputDialog(null, resource.getString("jprojectlist.name"), resource.getString("jprojectlist.clone"), 1, icon, null, null);
            }
            if (newProject != null) {
                this.soapclient.cloneProject(project, newProject);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, resource.getString("jprojectlist.exist"), resource.getString("jprojectlist.clone"), 1, icon);
        }
    }

    public void setStatus(String project) {
        try {
            String type = this.getProjectType(project);
            if (project.matches(".*_instance.*")) {
                this.soapclient.initProject(project);
            } else if (type.equals("Model")) {
                this.soapclient.initModel(project);
            } else {
                this.soapclient.initProject(project);
            }
            this.soapclient.setStatus(this.newStatus);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, resource.getString("jprojectlist.status"), resource.getString("jprojectlist.clone"), 1, icon);
        }
    }

    public void instantiateProject(String project) {
        try {
            this.soapclient.instantiateProject(project);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, resource.getString("jprojectlist.inst.error") + ", " + e.getMessage(), resource.getString("jprojectlist.inst"), 1, icon);
        }
    }

    public void terminateProject(String project) {
        try {
            this.soapclient.terminateProject(project);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, resource.getString("jprojectlist.term.error") + ": " + e.getMessage(), resource.getString("jprojectlist.inst"), 1, icon);
        }
    }

    public void changeEvent(Object[] e, String projectName) {
        DefaultMutableTreeNode node = this.findParent(projectName);
        if (node != null) {
            this.treeModel.removeNodeFromParent(node);
            this.actualProjects.remove(projectName);
        }
    }

    public void addElement(String projectName) {
        if (!this.exists(projectName)) {
            this.addObject(projectName);
        }
    }

    public void addObject(String child) {
        DefaultMutableTreeNode node;
        boolean startRow = false;
        String prefix = null;
        prefix = child.matches(".*_instance.*") ? child.substring(0, child.indexOf("_instance")) : resource.getString("jprojectlist.project");
        DefaultMutableTreeNode nd = this.findParent(prefix);
        if (nd != null) {
            node = nd;
        } else {
            this.treeModel.insertNodeInto(new DefaultMutableTreeNode(this.getModel(child)), this.top, this.top.getChildCount());
            this.actualProjects.add(this.getModel(child));
            node = this.findParent(prefix);
        }
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(child);
        this.treeModel.insertNodeInto(newNode, node, node.getChildCount());
        this.actualProjects.add(child);
    }

    public void propertyChange(PropertyChangeEvent e) {
        try {
            if (e.getPropertyName().equals(PROJECTCLOSE)) {
                this.projects.remove(e.getNewValue());
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private void createNodes(Collection iniProj) throws Exception {
        DefaultMutableTreeNode project = null;
        Object instance = null;
        Collection instances = this.soapclient.getInstances();
        for (String instName : instances) {
            if (iniProj.contains(this.getModel(instName))) continue;
            iniProj.add(this.getModel(instName));
        }
        for (String projectName : iniProj) {
            project = new DefaultMutableTreeNode(projectName);
            this.top.add(project);
        }
        for (String instName : instances) {
            this.findParent(this.getModel(instName)).add(new DefaultMutableTreeNode(instName));
        }
        this.actualProjects.addAll(instances);
    }

    private DefaultMutableTreeNode findParent(String parent) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        DefaultMutableTreeNode node = null;
        if (root != null) {
            Enumeration<TreeNode> e = root.breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode current = (DefaultMutableTreeNode)e.nextElement();
                if (!parent.equals(current.getUserObject())) continue;
                node = current;
                break;
            }
        }
        if (node != null) {
            return node;
        }
        return null;
    }

    private String getModel(String instanceName) {
        int i = instanceName.indexOf("_instance");
        return instanceName.substring(0, i);
    }

    public Collection getActualProjects() {
        return this.actualProjects;
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    protected static class CustomDefaultRenderer
    extends DefaultTreeCellRenderer {
        private Color leafForeground;

        protected CustomDefaultRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (leaf && this.leafForeground != null) {
                c.setForeground(this.leafForeground);
            }
            return c;
        }

        public void setLeafForeground(Color color) {
            this.leafForeground = color;
        }
    }

    class MyTreeModelListener
    implements TreeModelListener {
        MyTreeModelListener() {
        }

        public void treeNodesChanged(TreeModelEvent e) {
        }

        public void treeNodesInserted(TreeModelEvent e) {
        }

        public void treeNodesRemoved(TreeModelEvent e) {
        }

        public void treeStructureChanged(TreeModelEvent e) {
        }
    }
}

