/*
 * Decompiled with CFR 0.152.
 */
package hero.client.manager;

import hero.client.events.JMSServicesClient;
import hero.client.manager.JActivityList;
import hero.client.manager.JProjectList;
import hero.client.manager.JTodoList;
import hero.client.manager.MListener;
import hero.client.manager.Menubar;
import hero.util.BonitaClient;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class Manager
extends JPanel {
    static ResourceBundle resource = ResourceBundle.getBundle("resources.Traduction");
    String url = null;
    String host = null;
    int port;
    String userName = null;
    String userPassword = null;
    Collection projects = new ArrayList();
    JProjectList projectList = null;
    final JFrame p = new JFrame();
    BonitaClient soapclient;
    public static final String imageBase = "images/";
    public static final ImageIcon icon = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("images/icon.png"));

    public Manager(String userName, String userPassword) throws Exception {
        this.userName = userName;
        this.userPassword = userPassword;
        this.url = System.getProperty("bonita.host");
        this.host = this.url.substring(7);
        int point = this.host.indexOf(":");
        this.url = this.host;
        this.host = this.host.substring(0, point);
        int portPoint = this.url.indexOf("/");
        this.port = portPoint != -1 ? new Integer(this.url.substring(point + 1, portPoint)).intValue() : new Integer(this.url.substring(point + 1)).intValue();
        BonitaClient soapclient = new BonitaClient(this.host, this.port, "/bonita_ws/services/");
        soapclient.login(userName, userPassword);
        this.soapclient = soapclient;
        this.buildView();
    }

    public void buildView() throws Exception {
        String subscription = "(event = 'addUserProject' AND userName = '" + this.userName + "')" + " OR";
        Collection allProjects = this.soapclient.getProjects();
        for (String name : allProjects) {
            subscription = subscription + " projectName = '" + name + "' OR";
            if (name.matches(".*_instance.*")) continue;
            this.projects.add(name);
        }
        MListener ml = MListener.getInstance(this.userName, this.userPassword, this.host, this.port);
        ml.subscription(subscription.substring(0, subscription.length() - 3));
        this.projectList = new JProjectList(this.soapclient, ml, this.projects);
        this.projectList.setBackground(new Color(177, 177, 251));
        JTodoList todoList = new JTodoList(this.soapclient, ml);
        todoList.setBackground(new Color(177, 177, 251));
        JActivityList activityList = new JActivityList(this.soapclient, ml);
        activityList.setBackground(new Color(177, 177, 251));
        this.projectList.addPropertyChangeListener("selected", todoList);
        this.projectList.addPropertyChangeListener("selected", activityList);
        URL iconUrl = Thread.currentThread().getContextClassLoader().getResource("images/icon.png");
        this.p.setIconImage(Toolkit.getDefaultToolkit().getImage(iconUrl));
        Menubar menubar = new Menubar(this);
        menubar.setBackground(new Color(153, 153, 255));
        this.p.setJMenuBar(menubar);
        Container c = this.p.getContentPane();
        c.setLayout(new GridLayout(3, 1));
        c.add(this.projectList);
        c.add(todoList);
        c.add(activityList);
        this.p.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                try {
                    JMSServicesClient jms = JMSServicesClient.getInstance();
                    jms.closeConnection();
                    System.exit(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.p.setSize(new Dimension(150, 400));
        this.p.setTitle(resource.getString("manager.activity") + this.userName);
        this.p.pack();
        this.p.show();
    }

    public void CloneProject() {
        JPanel jp = new JPanel();
        Object[] possibleValues = this.projects.toArray();
        JComboBox<Object> projectNames = new JComboBox<Object>(possibleValues);
        jp.setLayout(new GridLayout(0, 2));
        jp.add(new JLabel(resource.getString("manager.choose"), 2));
        jp.add(projectNames);
        JTextField newProject = new JTextField("", 0);
        jp.setLayout(new GridLayout(0, 2));
        jp.add(new JLabel(resource.getString("manager.create.name2"), 2));
        jp.add(newProject);
        int cloneOption = JOptionPane.showConfirmDialog(null, jp, resource.getString("manager.create.clone"), 2, 3, icon);
        if (cloneOption != 2) {
            while (newProject.getText().equals("") && cloneOption != 2) {
                JOptionPane.showMessageDialog(null, resource.getString("manager.create.name"), resource.getString("manager.create.clone"), 1, icon);
                cloneOption = JOptionPane.showConfirmDialog(null, jp, resource.getString("manager.create.clone"), 2, 3, icon);
            }
            if (cloneOption != 2) {
                try {
                    if (this.exists(newProject.getText())) {
                        JOptionPane.showMessageDialog(null, resource.getString("manager.create.exist"), resource.getString("manager.create.clone"), 1, icon);
                    } else {
                        this.soapclient.cloneProject((String)projectNames.getSelectedItem(), newProject.getText());
                        this.projects.clear();
                        Collection allProjects = this.soapclient.getProjects();
                        for (String name : allProjects) {
                            if (name.matches(".*_instance.*")) continue;
                            this.projects.add(name);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(null, resource.getString("manager.create.exist"), resource.getString("manager.create.clone"), 1, icon);
                }
            }
        }
    }

    public void InstantiateProject() {
        JPanel jp = new JPanel();
        Object[] possibleValues = this.projects.toArray();
        JComboBox<Object> projectNames = new JComboBox<Object>(possibleValues);
        jp.setLayout(new GridLayout(0, 2));
        jp.add(new JLabel(resource.getString("manager.choose"), 2));
        jp.add(projectNames);
        int instOption = JOptionPane.showConfirmDialog(null, jp, resource.getString("manager.create.inst"), 2, 3, icon);
        if (instOption != 2) {
            try {
                this.soapclient.instantiateProject((String)projectNames.getSelectedItem());
                this.projects.clear();
                Collection allProjects = this.soapclient.getProjects();
                for (String name : allProjects) {
                    if (name.matches(".*_instance.*")) continue;
                    this.projects.add(name);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, resource.getString("manager.inst.error") + ", " + e.getMessage(), resource.getString("manager.create.inst"), 1, icon);
            }
        }
    }

    private boolean exists(String project) {
        try {
            Object[] elems = this.projects.toArray();
            for (int i = 0; i < elems.length; ++i) {
                if (!((String)elems[i]).equalsIgnoreCase(project)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public void NewProject() {
        this.projectList.newProject();
    }

    public static void main(String[] args) {
        boolean exit = false;
        String userName = null;
        String userPassword = null;
        if (System.getProperty("user.login") != null && System.getProperty("user.password") != null) {
            try {
                userName = System.getProperty("user.login");
                char[] password = System.getProperty("user.password").toCharArray();
                userPassword = new String(password);
                new Manager(userName, userPassword);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, resource.getString("manager.login.failed"), resource.getString("manager.login.login"), 1, icon);
                System.exit(0);
            }
        } else {
            while (!exit) {
                JPanel jp = new JPanel();
                JTextField login = new JTextField("", 0);
                jp.setLayout(new GridLayout(0, 2));
                jp.add(new JLabel(resource.getString("manager.login.login"), 2));
                jp.add(login);
                JPasswordField passwd = new JPasswordField("", 0);
                jp.setLayout(new GridLayout(0, 2));
                jp.add(new JLabel(resource.getString("manager.login.password"), 2));
                jp.add(passwd);
                try {
                    if (System.getProperty("user.login") != null && System.getProperty("user.password") != null) {
                        userName = System.getProperty("user.login");
                        char[] password = System.getProperty("user.password").toCharArray();
                        userPassword = new String(password);
                        new Manager(userName, userPassword);
                        exit = true;
                        continue;
                    }
                    int option = JOptionPane.showConfirmDialog(null, jp, resource.getString("manager.login"), 2, 3, icon);
                    if (option != 2) {
                        while ((login.getText().equals("") || passwd.getPassword().length == 0) && option != 2) {
                            JOptionPane.showMessageDialog(null, null, resource.getString("manager.login.relogin"), 3, icon);
                            option = JOptionPane.showConfirmDialog(null, jp, resource.getString("manager.login"), 2, 3, icon);
                        }
                        if (option != 2) {
                            userName = login.getText();
                            char[] password = passwd.getPassword();
                            userPassword = new String(password);
                            new Manager(userName, userPassword);
                            exit = true;
                            continue;
                        }
                        System.exit(0);
                        continue;
                    }
                    System.exit(0);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, resource.getString("manager.login.failed") + ": " + e.getMessage(), resource.getString("manager.login.login"), 3, icon);
                    exit = false;
                }
            }
        }
    }
}

