/*
 * Decompiled with CFR 0.152.
 */
package hero.client.samples;

import hero.client.test.SimpleCallbackHandler;
import hero.interfaces.ProjectSession;
import hero.interfaces.ProjectSessionHome;
import hero.interfaces.ProjectSessionUtil;
import hero.interfaces.UserSession;
import hero.interfaces.UserSessionHome;
import hero.interfaces.UserSessionUtil;
import java.util.Collection;
import java.util.Iterator;
import javax.security.auth.login.LoginContext;

public class Sample1RunningSession {
    public static void main(String[] args) throws Exception {
        char[] passwordJack = new char[]{'j', 'a', 'c', 'k'};
        SimpleCallbackHandler handlerJack = new SimpleCallbackHandler("jack", passwordJack);
        LoginContext lcJack = new LoginContext("TestClient", handlerJack);
        lcJack.login();
        UserSessionHome userHome = UserSessionUtil.getHome();
        UserSession userSession = userHome.create();
        Collection names = userSession.getProjectInstancesNames("Order Processing");
        Iterator i = names.iterator();
        String instNameOP = (String)i.next();
        ProjectSessionHome prjHome = ProjectSessionUtil.getHome();
        ProjectSession prjSession = prjHome.create();
        System.out.println("SessionBean created");
        try {
            prjSession.initProject(instNameOP);
        }
        catch (Exception e) {
            System.out.println("initProject : exception raised");
        }
        try {
            Collection roleNames = prjSession.getUserRolesInProject("jack");
            Iterator j = roleNames.iterator();
            while (j.hasNext()) {
                System.out.println("user jack : r\u00f4le : " + j.next());
            }
        }
        catch (Exception e) {
            System.out.println("getUserRolesInProject : exception raised : " + e);
        }
        String activityName = "Receive Order";
        int state = 0;
        try {
            state = prjSession.getNodeState(activityName);
        }
        catch (Exception e) {
            System.out.println("getNodeState : exception raised");
        }
        System.out.println("Verification : Node State : " + state);
        try {
            userSession.startActivity(instNameOP, activityName);
            System.out.println("(Jack) Activity started : " + activityName);
        }
        catch (Exception e) {
            System.out.println("startActivity : exception raised : " + e);
        }
        try {
            state = prjSession.getNodeState(activityName);
        }
        catch (Exception e) {
            System.out.println("getNodeState : exception raised");
        }
        System.out.println("Verification : Node State : " + state);
        try {
            prjSession.setNodeProperty(activityName, "customer_name", "jack", true);
            prjSession.setNodeProperty(activityName, "product_name", "tv", true);
            prjSession.setNodeProperty(activityName, "items", "1", true);
        }
        catch (Exception e) {
            System.out.println("setNodeProperty : exception raised : " + e);
        }
        System.out.println("properties set");
        try {
            Collection Properties2 = prjSession.getNodeProperties(activityName);
            Iterator k = Properties2.iterator();
            while (k.hasNext()) {
                System.out.println("Activity  " + activityName + " property : " + k.next());
            }
        }
        catch (Exception e) {
            System.out.println("getNodeProperties : exception raised : " + e);
        }
        try {
            userSession.terminateActivity(instNameOP, activityName);
            System.out.println("(Jack) Activity terminated : " + activityName);
        }
        catch (Exception e) {
            System.out.println("terminateActivity : exception raised : " + e);
        }
        char[] passwordJohn = new char[]{'j', 'o', 'h', 'n'};
        SimpleCallbackHandler handlerJohn = new SimpleCallbackHandler("john", passwordJohn);
        LoginContext lcJohn = new LoginContext("TestClient", handlerJohn);
        lcJohn.login();
        names = userSession.getProjectInstancesNames("Accept Order");
        i = names.iterator();
        String instNameAO = (String)i.next();
        lcJack.login();
        activityName = "Ask Customer";
        try {
            userSession.startActivity(instNameAO, activityName);
            System.out.println("(Jack) Activity started : " + activityName);
        }
        catch (Exception e) {
            System.out.println("startActivity : exception raised : " + e);
        }
        try {
            userSession.terminateActivity(instNameAO, activityName);
            System.out.println("(Jack) Activity terminated : " + activityName);
        }
        catch (Exception e) {
            System.out.println("terminateActivity : exception raised : " + e);
        }
        lcJohn.login();
        activityName = "Notify Sales";
        try {
            userSession.startActivity(instNameAO, activityName);
            System.out.println("(John) Activity started : " + activityName);
        }
        catch (Exception e) {
            System.out.println("startActivity : exception raised : " + e);
        }
        try {
            userSession.terminateActivity(instNameAO, activityName);
            System.out.println("(John) Activity terminated : " + activityName);
        }
        catch (Exception e) {
            System.out.println("terminateActivity : exception raised : " + e);
        }
        System.out.println(" ");
        System.out.println(" ------------------------------------------");
        System.out.println(" First Iteration terminated");
        System.out.println(" Play other iterations with Bonita manager tool (jack and john users)");
        System.out.println(" To stop : just use Bonita Web admin page (admin user) and ");
        System.out.println(" position the once_more property to KO for the Accept Order_Instance1 SUB PROJECT ");
        System.out.println("(and not activity) before terminating the Notify Sales activity ");
        System.out.println(" ------------------------------------------");
    }
}

