/*
 * Decompiled with CFR 0.152.
 */
package hero.client.samples;

import hero.client.test.SimpleCallbackHandler;
import hero.interfaces.BnNodePropertyValue;
import hero.interfaces.BnProjectPropertyValue;
import hero.interfaces.ProjectSession;
import hero.interfaces.ProjectSessionHome;
import hero.interfaces.ProjectSessionUtil;
import hero.interfaces.UserRegistration;
import hero.interfaces.UserRegistrationHome;
import hero.interfaces.UserRegistrationUtil;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import javax.security.auth.login.LoginContext;

public class SampleProjectApi {
    public static void main(String[] args) throws Exception {
        Collection rolesNames;
        UserRegistrationHome urHome = UserRegistrationUtil.getHome();
        UserRegistration userReg = urHome.create();
        try {
            userReg.userCreate("jack", "jack", "miguel.valdes-faura@ext.bull.net");
            userReg.userCreate("john", "john", "miguel.valdes-faura@ext.bull.net");
        }
        catch (Exception e) {
            // empty catch block
        }
        userReg.remove();
        char[] password = new char[]{'t', 'o', 't', 'o'};
        SimpleCallbackHandler handler = new SimpleCallbackHandler("admin", password);
        LoginContext lc = new LoginContext("TestClient", handler);
        lc.login();
        ProjectSessionHome prjHome = ProjectSessionUtil.getHome();
        ProjectSession prjSession = prjHome.create();
        System.out.println("Original Process creation ");
        prjSession.initModel("Original Process");
        System.out.println("Original Process cloning into Clone Process ");
        try {
            prjSession.initProject("Original Process", "Clone Process");
        }
        catch (Exception e) {
            System.out.println(e);
        }
        System.out.println("Original Process : current Process");
        prjSession.initModel("Original Process");
        String processName = prjSession.getName();
        System.out.println("Current Process : " + processName);
        try {
            String parentName = prjSession.getParent();
            System.out.println("Parent Process : " + parentName);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        try {
            String creatorName = prjSession.getCreator();
            System.out.println("Process Creator : " + creatorName);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        try {
            prjSession.setProperty("userId", "user1");
            prjSession.setProperty("recordId", "1111");
            prjSession.setProperty("orderId", "0001");
        }
        catch (Exception e) {
            System.out.println(e);
        }
        System.out.println("First way to access proprerty values : ");
        Collection properties = prjSession.getProperties();
        for (BnProjectPropertyValue property : properties) {
            try {
                String propertyKeyName = property.getTheKey();
                String propertyValue = property.getTheValue();
                System.out.println("Property (Key, Value) : " + propertyKeyName + "/" + propertyValue);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        System.out.println("Second  way to access proprerty values : ");
        properties = prjSession.getPropertiesKey();
        Iterator i = properties.iterator();
        while (i.hasNext()) {
            String propertyKey = (String)i.next();
            try {
                BnProjectPropertyValue propertyValue = prjSession.getProperty(propertyKey);
                System.out.println("Property (Key, Value) : " + i + "/" + propertyValue);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        try {
            prjSession.deleteProperty("orderId");
        }
        catch (Exception e) {
            System.out.println(e);
        }
        System.out.println("Properties after one deletion : ");
        Collection propertiesLeft = prjSession.getPropertiesKey();
        for (String propertyLeftKey : properties) {
            try {
                BnProjectPropertyValue propertyValue = prjSession.getProperty(propertyLeftKey);
                System.out.println("Property (Key, Value) : " + i + "/" + propertyValue);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        System.out.println("Activities creation ... ");
        try {
            prjSession.addNode("Activity 1", 1);
        }
        catch (Exception e) {
            System.out.println(" --> " + e);
        }
        try {
            prjSession.addNode("Activity 2", 1);
        }
        catch (Exception e) {
            System.out.println(" --> " + e);
        }
        try {
            prjSession.addNode("Activity 3", 1);
        }
        catch (Exception e) {
            System.out.println(" --> " + e);
        }
        System.out.println("Activity 3 definition ... ");
        try {
            Date dateLim = new Date(2005, 5, 2);
            prjSession.setNodeDeadline("Activity 3", dateLim.getTime());
            prjSession.setNodeDescription("Activity 3", "Activity 3 Description");
        }
        catch (Exception e) {
            System.out.println(" --> " + e);
        }
        System.out.println("Setting Activities types");
        try {
            prjSession.setNodeTraditional("Activity 1");
            prjSession.setNodeAutomatic("Activity 2");
            prjSession.setNodeTraditional("Activity 3");
        }
        catch (Exception e) {
            System.out.println(" --> " + e);
        }
        System.out.println("Setting node properties which will not be propagated to other nodes");
        try {
            prjSession.setNodeProperty("Activity 1", "color", "blue", false);
            System.out.println("Setting node properties which will be propagated to other nodes");
            prjSession.setNodeProperty("Activity 1", "price", "expensive", true);
            prjSession.setNodeProperty("Activity 1", "shape", "square");
        }
        catch (Exception e) {
            System.out.println(" --> " + e);
        }
        System.out.println("Adding edges between activities");
        try {
            prjSession.addEdge("Activity 1", "Activity 2");
            prjSession.addEdge("Activity 2", "Activity 3");
        }
        catch (Exception e) {
            System.out.println(" --> " + e);
        }
        System.out.println("Getting names of all the nodes in the project");
        Collection nodesNames = prjSession.getNodesNames();
        for (String nodeName : nodesNames) {
            System.out.println("Node :  " + nodeName + " (anticipable : " + prjSession.getNodeAnticipable(nodeName) + " )");
            Collection nodeProperties = prjSession.getNodeProperties(nodeName);
            for (BnNodePropertyValue nodeProperty : nodeProperties) {
                try {
                    String nodePropertyKeyName = nodeProperty.getTheKey();
                    String nodePropertyValue = nodeProperty.getTheValue();
                    System.out.println(" --> Property (Key, Value) : " + nodePropertyKeyName + "/" + nodePropertyValue);
                }
                catch (Exception e) {
                    System.out.println(" --> " + e);
                }
            }
        }
        System.out.println("Node deletion");
        try {
            prjSession.deleteNode("Activity 3");
        }
        catch (Exception e) {
            System.out.println(" --> " + e);
        }
        System.out.println("Node deletion verification");
        try {
            nodesNames = prjSession.getNodesNames();
            for (String nodeName : nodesNames) {
                System.out.println("Node :  " + nodeName);
            }
        }
        catch (Exception e) {
            System.out.println(" --> " + e);
        }
        System.out.println("Adding a role in the project (before instantiation) ");
        try {
            prjSession.addRole("Customer", "customer");
        }
        catch (Exception e) {
            System.out.println(" --> " + e);
        }
        System.out.println("  Getting role names of the project ");
        try {
            rolesNames = prjSession.getRolesNames();
            for (String roleName : rolesNames) {
                System.out.println("Role :  " + roleName);
            }
        }
        catch (Exception e) {
            System.out.println(" --> " + e);
        }
        System.out.println("Creating project new intance");
        try {
            prjSession.instantiateProject("Original Process");
        }
        catch (Exception e) {
            System.out.println(" --> " + e);
        }
        processName = prjSession.getName();
        System.out.println("Current Process : " + processName);
        System.out.println("  Getting role names of the instance ");
        try {
            rolesNames = prjSession.getRolesNames();
            for (String roleName : rolesNames) {
                System.out.println("Role :  " + roleName);
            }
        }
        catch (Exception e) {
            System.out.println(" --> " + e);
        }
        System.out.println("  Getting users names of the project ");
        try {
            Collection usersNames = prjSession.getUsers();
            for (String userName : usersNames) {
                System.out.println("User :  " + userName);
            }
        }
        catch (Exception e) {
            System.out.println(" --> " + e);
        }
        System.out.println("  Adding John in the project ");
        try {
            prjSession.addUser("john");
        }
        catch (Exception e) {
            System.out.println(" --> " + e);
        }
        processName = prjSession.getName();
        System.out.println("  --> Current Process : " + processName + " contains john :" + prjSession.containsUser("john"));
        System.out.println("Adding a Custumer role for john in the current project ");
        try {
            prjSession.setUserRole("john", "Customer");
        }
        catch (Exception e) {
            System.out.println(" --> " + e);
        }
        System.out.println("  Getting role names of the project ");
        try {
            rolesNames = prjSession.getRolesNames();
            for (String roleName : rolesNames) {
                System.out.println("Role :  " + roleName);
            }
        }
        catch (Exception e) {
            System.out.println(" --> " + e);
        }
        System.out.println("  Getting role names for john user in this project ");
        try {
            Collection johnRolesNames = prjSession.getRolesNames();
            for (String johnRoleName : johnRolesNames) {
                System.out.println("John role :  " + johnRoleName);
            }
        }
        catch (Exception e) {
            System.out.println(" --> " + e);
        }
        System.out.println("  Setting role names for an activites of this project ");
        try {
            Collection prjNodesNames = prjSession.getNodesNames();
            for (String prjNodeName : prjNodesNames) {
                System.out.println("Node --> " + prjNodeName);
                System.out.println("  --> Getting the actuel role names for Activities ");
                try {
                    System.out.println("      Activity role :  " + prjSession.getNodeRoleName(prjNodeName));
                }
                catch (Exception e) {
                    System.out.println(" --> " + e);
                }
                System.out.println("  --> Setting activities new roles ");
                try {
                    prjSession.setNodeRole(prjNodeName, "admin");
                }
                catch (Exception e) {
                    System.out.println(" --> " + e);
                }
                System.out.println("  --> Getting the new role names for Activities ");
                try {
                    System.out.println("      Activity role :  " + prjSession.getNodeRoleName(prjNodeName));
                }
                catch (Exception e) {
                    System.out.println(" --> " + e);
                }
            }
        }
        catch (Exception e) {
            System.out.println(" --> " + e);
        }
    }
}

